/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.variables.preferences.internal.ui;

import com.nxp.s32ds.cle.ide.variables.preferences.CleVariableCategory;
import com.nxp.s32ds.cle.ide.variables.preferences.internal.ui.Messages;
import com.nxp.s32ds.cle.ide.variables.preferences.internal.ui.S32DSVariable;
import com.nxp.s32ds.cle.ide.variables.preferences.internal.ui.S32DSVariablesContentProvider;
import com.nxp.s32ds.cle.ide.variables.preferences.internal.ui.S32DSVariablesFilterLabelProvider;
import com.nxp.s32ds.cle.ide.variables.preferences.internal.ui.S32DSVariablesGroup;
import com.nxp.s32ds.cle.ide.variables.preferences.internal.ui.S32DSVariablesLabelProviders;
import com.nxp.s32ds.ext.rcp.jface.viewers.IgnoreCaseSubstringPatternFilter;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public class S32DSVariablesFilteredTreeViewer
extends FilteredTree {
    private static final int TREE_HORIZONTAL_HINT = 600;
    private static final int FILTER_HORIZONTAL_HINT = 330;

    public S32DSVariablesFilteredTreeViewer(Composite parent) {
        super(parent, 68354, (PatternFilter)new IgnoreCaseSubstringPatternFilter(), true, true);
        this.setQuickSelectionMode(true);
    }

    protected Control createTreeControl(Composite parent, int style) {
        TreeColumnLayout layout = new TreeColumnLayout();
        parent.setLayout((Layout)layout);
        Control treeControl = super.createTreeControl(parent, style);
        this.createColumns(layout);
        return treeControl;
    }

    protected TreeViewer doCreateTreeViewer(Composite parent, int style) {
        TreeViewer treeViewer = super.doCreateTreeViewer(parent, style);
        Tree tree = treeViewer.getTree();
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        treeViewer.setLabelProvider((IBaseLabelProvider)new S32DSVariablesFilterLabelProvider(new ILabelProvider[]{S32DSVariablesLabelProviders.NAME_LABEL_PROVIDER, S32DSVariablesLabelProviders.VALUE_LABEL_PROVIDER, S32DSVariablesLabelProviders.DESCRIPTION_LABEL_PROVIDER, S32DSVariablesLabelProviders.CONTRIBUTED_BY_LABEL_PROVIDER}));
        treeViewer.setContentProvider((IContentProvider)new S32DSVariablesContentProvider());
        treeViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                int cat2;
                int cat1 = this.category(e1);
                if (cat1 != (cat2 = this.category(e2))) {
                    return cat1 - cat2;
                }
                return this.getLabel(e1).compareTo(this.getLabel(e2));
            }

            private String getLabel(Object element) {
                return S32DSVariablesLabelProviders.NAME_LABEL_PROVIDER.getText(element);
            }

            public int category(Object element) {
                return CleVariableCategory.UNCATEGORIZED_NAME.equals(this.getLabel(element)) ? 0 : 1;
            }
        });
        this.createMenu(tree);
        return treeViewer;
    }

    protected void createFilterText(Composite parent) {
        super.createFilterText(parent);
        GridDataFactory.swtDefaults().align(1, 0x1000000).hint(330, -1).applyTo((Control)this.filterText);
    }

    private void createMenu(Tree tree) {
        Menu menu = new Menu((Control)tree);
        MenuItem menuItem = new MenuItem(menu, 0);
        menuItem.setText(Messages.S32DSVariablesTreeViewer_copy);
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                S32DSVariablesFilteredTreeViewer.this.copySelected();
            }
        });
        tree.setMenu(menu);
        tree.addListener(1, e -> {
            if ((e.stateMask & 0x40000) == 262144 && e.keyCode == 99) {
                this.copySelected();
            }
        });
    }

    private void createColumns(TreeColumnLayout layout) {
        this.createColumn(layout, Messages.S32DSVariablesTreeViewer_name, (CellLabelProvider)S32DSVariablesLabelProviders.NAME_LABEL_PROVIDER, 30);
        this.createColumn(layout, Messages.S32DSVariablesTreeViewer_value, (CellLabelProvider)S32DSVariablesLabelProviders.VALUE_LABEL_PROVIDER, 25);
        this.createColumn(layout, Messages.S32DSVariablesTreeViewer_description, (CellLabelProvider)S32DSVariablesLabelProviders.DESCRIPTION_LABEL_PROVIDER, 25);
        this.createColumn(layout, Messages.S32DSVariablesTreeViewer_contributed_by, (CellLabelProvider)S32DSVariablesLabelProviders.CONTRIBUTED_BY_LABEL_PROVIDER, 20);
    }

    private TreeViewerColumn createColumn(TreeColumnLayout layout, String name, CellLabelProvider labelProvider, int columnWeight) {
        TreeViewerColumn column = new TreeViewerColumn(this.treeViewer, 0);
        column.getColumn().setText(name);
        column.setLabelProvider(labelProvider);
        layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(columnWeight, 6 * columnWeight));
        return column;
    }

    private void copySelected() {
        IStructuredSelection selection = (IStructuredSelection)this.getViewer().getSelection();
        List selections = selection.toList();
        if (selections.isEmpty()) {
            return;
        }
        String result = String.join((CharSequence)System.lineSeparator(), selections.stream().flatMap(o -> {
            if (o instanceof S32DSVariable) {
                return Stream.of(o);
            }
            if (o instanceof S32DSVariablesGroup) {
                return ((S32DSVariablesGroup)o).getChildren().stream();
            }
            throw new IllegalStateException("Unknown type " + o.getClass().getName());
        }).map(o -> ((S32DSVariable)o).asStringForClipboard()).collect(Collectors.toCollection(LinkedHashSet::new)));
        Clipboard clipboard = new Clipboard(Display.getDefault());
        clipboard.setContents((Object[])new String[]{result}, (Transfer[])new TextTransfer[]{TextTransfer.getInstance()});
        clipboard.dispose();
    }
}

