/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.debug.ka.freertos.controller;

import com.freescale.s32ds.debug.ka.dsf.DSFInterface;
import com.freescale.s32ds.debug.ka.freertos.controller.FreeRTOSIStoreManager;
import com.freescale.s32ds.debug.ka.freertos.controller.IFreeRTOSTaskStore;
import com.freescale.s32ds.debug.ka.freertos.controller.IQueueStore;
import com.freescale.s32ds.debug.ka.freertos.controller.ITimerStore;
import com.freescale.s32ds.debug.ka.freertos.controller.QueueStore;
import com.freescale.s32ds.debug.ka.freertos.controller.TaskStore;
import com.freescale.s32ds.debug.ka.freertos.controller.TimerStore;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.eclipse.cdt.dsf.debug.service.IRunControl;

public class StoreManager
implements FreeRTOSIStoreManager {
    private final Map<IRunControl.IExecutionDMContext, TargetInfo> TargetInfoMap = new HashMap<IRunControl.IExecutionDMContext, TargetInfo>();
    private static final StoreManager MANAGER = new StoreManager();

    public static FreeRTOSIStoreManager getDefault() {
        return MANAGER;
    }

    private StoreManager() {
    }

    synchronized TargetInfo getTargetInfo(IRunControl.IExecutionDMContext target) {
        TargetInfo info = this.TargetInfoMap.get(target);
        if (info == null) {
            info = new TargetInfo(target);
            this.TargetInfoMap.put(target, info);
        }
        return info;
    }

    @Override
    public IFreeRTOSTaskStore getTaskStore(IRunControl.IExecutionDMContext context) {
        return this.getTargetInfo(context).getTaskStore();
    }

    @Override
    public IQueueStore getQueueStore(IRunControl.IExecutionDMContext context) {
        return this.getTargetInfo(context).getQueueStore();
    }

    @Override
    public ITimerStore getTimerStore(IRunControl.IExecutionDMContext context) {
        return this.getTargetInfo(context).getTimerStore();
    }

    public boolean isBigEndian(IRunControl.IExecutionDMContext context) {
        return this.getTargetInfo(context).isBigEndian();
    }

    public void setBigEndian(IRunControl.IExecutionDMContext context, boolean bigEndian) {
        this.getTargetInfo(context).setBigEndian(bigEndian);
    }

    public void updateTaskStore(IRunControl.IExecutionDMContext context) {
        TargetInfo info = this.getTargetInfo(context);
        if (info.isKernelInitialised()) {
            info.getTaskStore().vHandleSuspendEvent();
        } else {
            try {
                long lCurrentTCB = info.getTaskStore().getCurrentTCB();
                if (lCurrentTCB != 0L) {
                    info.setKernelInitialised();
                    long lCurrentTCBAddress = info.getTaskStore().getCurrentTCBAddress();
                    String sCurrentTCB = DSFInterface.getDefault().sGetMemory(context, lCurrentTCBAddress, 4);
                    if (Long.decode(sCurrentTCB) != lCurrentTCB) {
                        boolean bigEndian = this.isBigEndian(context);
                        this.setBigEndian(context, !bigEndian);
                    }
                    info.getTaskStore().vHandleSuspendEvent();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void updateQueueStore(IRunControl.IExecutionDMContext context) {
        TargetInfo info = this.getTargetInfo(context);
        if (info.isKernelInitialised()) {
            info.getQueueStore().vHandleSuspendEvent();
        } else {
            try {
                long lCurrentTCB = info.getTaskStore().getCurrentTCB();
                if (lCurrentTCB != 0L) {
                    info.setKernelInitialised();
                    long lCurrentTCBAddress = info.getTaskStore().getCurrentTCBAddress();
                    String sCurrentTCB = DSFInterface.getDefault().sGetMemory(context, lCurrentTCBAddress, 4);
                    if (Long.decode(sCurrentTCB) != lCurrentTCB) {
                        boolean bigEndian = this.isBigEndian(context);
                        this.setBigEndian(context, !bigEndian);
                    }
                    info.getQueueStore().vHandleSuspendEvent();
                }
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    @Override
    public void updateTimerStore(IRunControl.IExecutionDMContext context) {
        TargetInfo info = this.getTargetInfo(context);
        if (info.isKernelInitialised()) {
            info.getTimerStore().vHandleSuspendEvent();
        } else {
            try {
                long lCurrentTCB = info.getTaskStore().getCurrentTCB();
                if (lCurrentTCB != 0L) {
                    info.setKernelInitialised();
                    long lCurrentTCBAddress = info.getTaskStore().getCurrentTCBAddress();
                    String sCurrentTCB = DSFInterface.getDefault().sGetMemory(context, lCurrentTCBAddress, 4);
                    if (Long.decode(sCurrentTCB) != lCurrentTCB) {
                        boolean bigEndian = this.isBigEndian(context);
                        this.setBigEndian(context, !bigEndian);
                    }
                    info.getTimerStore().vHandleSuspendEvent();
                }
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    private static class TargetInfo {
        private IFreeRTOSTaskStore taskStore;
        private IQueueStore queueStore;
        private ITimerStore timerStore;
        private boolean kernelInitialised = false;
        private boolean bigEndian = true;

        public TargetInfo(IRunControl.IExecutionDMContext target) {
            this.taskStore = new TaskStore(target, MANAGER);
            this.queueStore = new QueueStore(target, MANAGER);
            this.timerStore = new TimerStore(target, MANAGER);
        }

        IFreeRTOSTaskStore getTaskStore() {
            return this.taskStore;
        }

        IQueueStore getQueueStore() {
            return this.queueStore;
        }

        ITimerStore getTimerStore() {
            return this.timerStore;
        }

        boolean isKernelInitialised() {
            return this.kernelInitialised;
        }

        void setKernelInitialised() {
            this.kernelInitialised = true;
        }

        boolean isBigEndian() {
            return this.bigEndian;
        }

        void setBigEndian(boolean bigEndian) {
            this.bigEndian = bigEndian;
        }
    }
}

