/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.debug.ka.freertos.model;

import com.freescale.s32ds.debug.ka.KAPluginActivator;
import com.freescale.s32ds.debug.ka.dsf.DSFInterface;
import com.freescale.s32ds.debug.ka.freertos.controller.FreeRTOSIStoreManager;
import com.freescale.s32ds.debug.ka.freertos.model.OSData;
import java.util.concurrent.ExecutionException;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class StringPointerData
extends OSData {
    public StringPointerData(IRunControl.IExecutionDMContext context, String name, FreeRTOSIStoreManager storeManager) {
        super(context, name, storeManager);
    }

    @Override
    public boolean setValue(String sValueList) {
        this.saveValue();
        int iValueLocation = this.iOffsetIntoStruct / 4;
        iValueLocation *= 11;
        if (this.sValue == "") {
            String sStringMemory;
            try {
                String sStringPointer = sValueList.substring(iValueLocation, iValueLocation + 10);
                if (!this.storeManager.isBigEndian(this.context)) {
                    sStringPointer = StringPointerData.sSwapHexWord((String)sStringPointer);
                }
                sStringMemory = !sStringPointer.equals("0x00000000") ? DSFInterface.getDefault().sGetMemory(this.context, Long.decode(sStringPointer).longValue(), 100) : null;
            }
            catch (NumberFormatException e) {
                KAPluginActivator.log((IStatus)new Status(4, "com.freescale.s32ds.viewer.freertos", "DataItem: Failed to parse char * address.\n" + e.getMessage()));
                sStringMemory = null;
            }
            catch (ExecutionException e) {
                KAPluginActivator.log((IStatus)new Status(4, "com.freescale.s32ds.viewer.freertos", "DataItem: Failed to load char * address.\n" + e.getMessage()));
                sStringMemory = null;
            }
            this.sValue = sStringMemory != null ? StringPointerData.sReadStringFromBufferBigEndian(sStringMemory) : "";
        }
        return !this.sOriginal.equals(this.sValue);
    }
}

