/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.ui.actions;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.core.model.IFunctionDeclaration;
import org.eclipse.cdt.debug.core.model.IStepIntoSelectionHandler;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.internal.ui.sourcelookup.DsfSourceSelectionResolver;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.IRunControl3;
import org.eclipse.cdt.dsf.debug.ui.actions.IDsfStepIntoSelection;
import org.eclipse.cdt.dsf.internal.ui.DsfUIPlugin;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.IRequest;
import org.eclipse.debug.core.commands.AbstractDebugCommand;
import org.eclipse.debug.core.commands.IDebugCommandRequest;
import org.eclipse.debug.core.commands.IEnabledStateRequest;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.swt.widgets.Display;

public class DsfStepIntoSelectionCommand
extends AbstractDebugCommand
implements IStepIntoSelectionHandler,
IDsfStepIntoSelection {
    private final DsfSession fSession;
    private final DsfServicesTracker fTracker;

    public DsfStepIntoSelectionCommand(DsfSession session) {
        this.fSession = session;
        this.fTracker = new DsfServicesTracker(DsfUIPlugin.getBundleContext(), session.getId());
    }

    public void dispose() {
        this.fTracker.dispose();
    }

    protected void doExecute(Object[] targets, IProgressMonitor monitor, IRequest request) throws CoreException {
        if (targets.length != 1) {
            return;
        }
        IRunControl.IExecutionDMContext dmc = (IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)((IDMVMContext)targets[0]).getDMContext(), IRunControl.IExecutionDMContext.class);
        if (dmc == null) {
            return;
        }
        DsfSourceSelectionResolver resolveSelection = new DsfSourceSelectionResolver();
        Display.getDefault().syncExec((Runnable)resolveSelection);
        if (resolveSelection.isSuccessful()) {
            DsfSourceSelectionResolver.LineLocation location = resolveSelection.getLineLocation();
            this.runToSelection(location.getFileName(), location.getLineNumber(), resolveSelection.getFunction(), dmc);
        } else {
            DsfUIPlugin.debug("DSfStepIntoSelectionCommand: Unable to resolve a selected function");
        }
    }

    protected boolean isExecutable(Object[] targets, IProgressMonitor monitor, IEnabledStateRequest request) throws CoreException {
        if (targets.length != 1) {
            return false;
        }
        IRunControl.IExecutionDMContext dmc = (IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)((IDMVMContext)targets[0]).getDMContext(), IRunControl.IExecutionDMContext.class);
        return this.isExecutable(dmc);
    }

    protected Object getTarget(Object element) {
        if (element instanceof IDMVMContext) {
            return element;
        }
        return null;
    }

    protected boolean isRemainEnabled(IDebugCommandRequest request) {
        return true;
    }

    @Override
    public boolean isExecutable(final IRunControl.IExecutionDMContext dmc) {
        if (dmc == null) {
            return false;
        }
        if (this.fSession != null && this.fSession.isActive()) {
            try {
                Query<Boolean> query = new Query<Boolean>(){

                    protected void execute(DataRequestMonitor<Boolean> rm) {
                        IRunControl3 runControl = (IRunControl3)DsfStepIntoSelectionCommand.this.fTracker.getService(IRunControl3.class);
                        if (runControl == null) {
                            rm.done((Object)false);
                            return;
                        }
                        runControl.canStepIntoSelection(dmc, null, 0, null, rm);
                    }
                };
                this.fSession.getExecutor().execute((Runnable)query);
                return (Boolean)query.get();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public void runToSelection(final String fileName, final int lineLocation, final IFunctionDeclaration selectedFunction, final IRunControl.IExecutionDMContext dmc) {
        if (this.fSession != null && this.fSession.isActive()) {
            Exception exception = null;
            try {
                Query<Object> query = new Query<Object>(){

                    protected void execute(DataRequestMonitor<Object> rm) {
                        IRunControl3 runControl = (IRunControl3)DsfStepIntoSelectionCommand.this.fTracker.getService(IRunControl3.class);
                        if (runControl == null) {
                            rm.done((IStatus)new Status(4, "org.eclipse.cdt.dsf.ui", 10003, "IRunControl3 service not available", null));
                            return;
                        }
                        boolean skipBreakpoints = DebugUITools.getPreferenceStore().getBoolean("org.eclipse.debug.ui.skip_breakpoints_during_run_to_line");
                        runControl.stepIntoSelection(dmc, fileName, lineLocation, skipBreakpoints, selectedFunction, rm);
                    }
                };
                this.fSession.getExecutor().execute((Runnable)query);
                query.get();
            }
            catch (RejectedExecutionException e) {
                exception = e;
            }
            catch (InterruptedException e) {
                exception = e;
            }
            catch (ExecutionException e) {
                exception = e;
            }
            if (exception != null) {
                DsfUIPlugin.log((Throwable)new DebugException((IStatus)new Status(4, "org.eclipse.cdt.dsf.ui", 5012, "Failed executing Step into Selection", (Throwable)exception)));
            }
        } else {
            DsfUIPlugin.log((Throwable)new DebugException((IStatus)new Status(4, "org.eclipse.cdt.dsf.ui", 5012, "Debug session is not active", null)));
        }
    }
}

