/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.core.refactoring;

import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.IPath;

public class ProjectSet {
    private final String name;
    private final String comment;
    private final IPath path;
    private final IProjectDescription[] projects;

    public ProjectSet(IProjectDescription project) {
        this.name = project.getName();
        this.comment = project.getComment();
        this.path = Objects.requireNonNull(project.getLocation());
        this.projects = new IProjectDescription[]{project};
    }

    public ProjectSet(String name, String comment, IPath path, List<IProjectDescription> projects) {
        this.name = name;
        this.comment = comment;
        this.path = Objects.requireNonNull(path);
        this.projects = projects.toArray(new IProjectDescription[projects.size()]);
    }

    public String getName() {
        return this.name;
    }

    public String getComment() {
        return this.comment;
    }

    public IPath getRoot() {
        return this.path.removeLastSegments(1);
    }

    public IPath getPath() {
        return this.path;
    }

    public Stream<IProjectDescription> getProjects() {
        return Stream.of(this.projects);
    }

    public boolean isEmpty() {
        return this.projects.length == 0;
    }

    public String toString() {
        return String.valueOf(this.name) + " (" + this.path + ")";
    }
}

