/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.core.refactoring;

import com.nxp.s32ds.ext.ide.core.refactoring.ProjectSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;

public class RefactorContext {
    private String userProjectName;
    private ProjectSet projectsSet;
    private Map<String, String> nameMap;

    public RefactorContext(String userProjectName, ProjectSet projects) {
        this.userProjectName = userProjectName;
        this.projectsSet = projects;
        this.nameMap = Collections.unmodifiableMap(Stream.concat(projects.getProjects().map(IProjectDescription::getName), Stream.of(projects.getName())).distinct().collect(Collectors.toMap(String::toString, RefactorContext.replaceAllQuoted("^" + Pattern.quote(projects.getName()), userProjectName))));
    }

    public String getUserProjectName() {
        return this.userProjectName;
    }

    public ProjectSet getProjectsSet() {
        return this.projectsSet;
    }

    public Map<String, String> getNameMap() {
        return this.nameMap;
    }

    private static Function<String, String> replaceAllQuoted(String regex, String replacement) {
        return str -> str.replaceAll(regex, Matcher.quoteReplacement(replacement));
    }

    public List<IProject> getProjects() {
        return this.projectsSet.getProjects().map(descr -> ResourcesPlugin.getWorkspace().getRoot().getProject(descr.getName())).collect(Collectors.toList());
    }

    public List<IProjectDescription> getProjectDescriptions() {
        return this.projectsSet.getProjects().collect(Collectors.toList());
    }
}

