/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.core.refactoring;

import com.nxp.s32ds.ext.ide.core.internal.ExtIdeCoreActivator;
import com.nxp.s32ds.ext.ide.core.refactoring.RefactoringParticipant;
import com.nxp.s32ds.ext.ide.internal.validation.core.Messages;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class RefactorService {
    private static final String BUNDLE_ID = ExtIdeCoreActivator.getPluginId();
    private static final String EXEC_EXT = "class";
    private static final String EXT_ID_RENAME = "renameRefactoring";
    private static final String EXT_ID_IMPORT = "importRefactoring";
    private static final String ORDER_ATTR = "order";

    private RefactorService() {
    }

    public static List<RefactoringParticipant> getRenameRefactoringParticipants() {
        ArrayList<RefactoringParticipantWrapper> wrappedParticipants = new ArrayList<RefactoringParticipantWrapper>();
        IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint(BUNDLE_ID, EXT_ID_RENAME);
        if (ep == null) {
            return Collections.emptyList();
        }
        IExtension[] iExtensionArray = ep.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                try {
                    RefactoringParticipant participant = (RefactoringParticipant)element.createExecutableExtension(EXEC_EXT);
                    String order = element.getAttribute(ORDER_ATTR);
                    int orderNum = order == null || order.isEmpty() ? 1 : Integer.valueOf(order);
                    wrappedParticipants.add(new RefactoringParticipantWrapper(participant, orderNum));
                }
                catch (CoreException ex) {
                    ExtIdeCoreActivator.getInstance().logError(Messages.RefactorService_failed_to_load_rename_participants, ex);
                }
                ++n4;
            }
            ++n2;
        }
        List<RefactoringParticipant> participants = wrappedParticipants.stream().sorted(Comparator.comparing(RefactoringParticipantWrapper::getOrder)).map(RefactoringParticipantWrapper::getParticipant).collect(Collectors.toList());
        return participants;
    }

    public static List<RefactoringParticipant> getImportRefactoringParticipants() {
        ArrayList<RefactoringParticipant> lstRefactorPart = new ArrayList<RefactoringParticipant>();
        IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint(BUNDLE_ID, EXT_ID_IMPORT);
        if (ep == null) {
            return Collections.emptyList();
        }
        IExtension[] iExtensionArray = ep.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                try {
                    lstRefactorPart.add((RefactoringParticipant)element.createExecutableExtension(EXEC_EXT));
                }
                catch (CoreException ex) {
                    ExtIdeCoreActivator.getInstance().logError(Messages.RefactorService_failed_to_load_import_participants, ex);
                }
                ++n4;
            }
            ++n2;
        }
        return lstRefactorPart;
    }

    private static class RefactoringParticipantWrapper {
        private RefactoringParticipant participant;
        private int order;

        public RefactoringParticipantWrapper(RefactoringParticipant participant, int order) {
            this.participant = participant;
            this.order = order;
        }

        public RefactoringParticipant getParticipant() {
            return this.participant;
        }

        public int getOrder() {
            return this.order;
        }
    }
}

