/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.resource.internal.refactoring;

import com.nxp.s32ds.ext.ide.core.refactoring.RefactoringParticipant;
import com.nxp.s32ds.ext.ide.resource.internal.refactoring.ResourceRefactoringActivator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

public class ReferencedResourcesRefactoringParticipant
implements RefactoringParticipant {
    public IStatus apply(IProject target, IProject source, String search, String replace, IProgressMonitor monitor) {
        MultiStatus mtStatus = ResourceRefactoringActivator.getInstance().createMultiStatus();
        if (search != null && replace != null && !search.equals(replace)) {
            mtStatus.add(this.processLinkedResources(target, search, replace, monitor));
        }
        return mtStatus;
    }

    private IStatus processLinkedResources(IProject project, String search, String replace, IProgressMonitor monitor) {
        try {
            this.visit((IContainer)project, monitor, search, replace);
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        return Status.OK_STATUS;
    }

    private void visit(IContainer container, IProgressMonitor monitor, String search, String replace) throws CoreException {
        IResource[] iResourceArray = container.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            block6: {
                IResource resource = iResourceArray[n2];
                if (resource instanceof IContainer) {
                    this.visit((IContainer)resource, monitor, search, replace);
                }
                if (resource.isLinked() && resource instanceof IFile) {
                    IFile file = (IFile)resource;
                    try {
                        String location = file.getRawLocation().toString();
                        Path path = new Path(location.replaceAll(search, replace));
                        IStatus linkStatus = ResourcesPlugin.getWorkspace().validateLinkLocation((IResource)file, (IPath)path);
                        if (linkStatus.getSeverity() != 4) {
                            file.createLink((IPath)path, 256, monitor);
                            break block6;
                        }
                        throw new CoreException(linkStatus);
                    }
                    catch (Exception ex) {
                        IStatus s = ResourceRefactoringActivator.getInstance().createError(ex.getMessage(), ex);
                        throw new CoreException(s);
                    }
                }
            }
            ++n2;
        }
    }
}

