/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.toolchain.internal.registry.core;

import com.nxp.s32ds.cle.runtime.toolchain.internal.registry.core.CompilerDescriptorImplementation;
import com.nxp.s32ds.cle.runtime.toolchain.internal.registry.core.ToolChainConditionRuleImpl;
import com.nxp.s32ds.cle.runtime.toolchain.internal.registry.core.ToolChainDescriptorImplementation;
import com.nxp.s32ds.cle.runtime.toolchain.registry.CompilerRegistry;
import com.nxp.s32ds.cle.runtime.toolchain.registry.ToolChainContributor;
import com.nxp.s32ds.cle.runtime.toolchain.registry.ToolChainRegistry;
import com.nxp.s32ds.cle.runtime.toolchain.registry.ToolchainConditionRule;
import com.nxp.s32ds.ext.rcp.runtime.Extensions;
import com.nxp.s32ds.ext.rcp.runtime.RcpBundle;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class ToolChainRegistryCoreActivator
extends RcpBundle {
    private static ToolChainRegistryCoreActivator INSTANCE;
    private static BundleContext context;
    private ServiceTracker<ToolChainRegistry, ToolChainRegistry> toolChainRegistryServiceTracker;
    private ToolChainRegistry toolChainRegistryService;

    public static ToolChainRegistryCoreActivator getInstance() {
        return INSTANCE;
    }

    protected String getBundleId() {
        return "com.nxp.s32ds.cle.runtime.toolchain.registry.core";
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        context = bundleContext;
        INSTANCE = this;
        String toolChainRegistryClassName = ToolChainRegistry.class.getName();
        this.toolChainRegistryServiceTracker = new ServiceTracker(context, toolChainRegistryClassName, null);
        this.toolChainRegistryServiceTracker.open();
        this.toolChainRegistryService = (ToolChainRegistry)this.toolChainRegistryServiceTracker.getService();
        if (this.toolChainRegistryService != null) {
            this.registerCompilers(this.toolChainRegistryService.getCompilerRegistry());
            this.registerToolChains(this.toolChainRegistryService);
            this.registerToolChainValidationRules(this.toolChainRegistryService);
        }
    }

    private void registerCompilers(CompilerRegistry registry) {
        String ns = "com.nxp.s32ds.cle.runtime.toolchain.registry.core";
        String ep = "compilers";
        Extensions.getConfigrationElements((String)ns, (String)ep, (String)"compiler", (String[])new String[0]).stream().map(CompilerDescriptorImplementation::new).forEach(arg_0 -> ((CompilerRegistry)registry).addCompilerDescriptor(arg_0));
    }

    private void registerToolChains(ToolChainRegistry registry) {
        String ns = "com.nxp.s32ds.cle.runtime.toolchain.registry.core";
        String ep = "toolChains";
        Extensions.getConfigrationElements((String)ns, (String)ep, (String)"toolChain", (String[])new String[0]).stream().map(ToolChainDescriptorImplementation::new).forEach(arg_0 -> ((ToolChainRegistry)registry).addToolChainDescriptor(arg_0));
        List executables = Extensions.createSimpleExecutableExtensions((String)ns, (String)ep, (String)"contributor", (String)"class", ToolChainContributor.class);
        executables.forEach(executable -> executable.contribute(registry));
    }

    private void registerToolChainValidationRules(ToolChainRegistry registry) {
        String ns = "com.nxp.s32ds.cle.runtime.toolchain.registry.core";
        String ep = "toolchain.condition.rules";
        List restrictionRules = Extensions.getConfigrationElements((String)ns, (String)ep, (String)"conditionRule", (String[])new String[0]);
        for (IConfigurationElement restrictionRule : restrictionRules) {
            String toolChain = ToolChainRegistryCoreActivator.getAttributeByElement(restrictionRule, "toolchainCondition", "toolchain");
            ToolChainConditionRuleImpl validationRule = new ToolChainConditionRuleImpl(toolChain);
            String deviceId = ToolChainRegistryCoreActivator.getAttributeByElement(restrictionRule, "deviceCondition", "deviceId");
            if (!deviceId.isEmpty()) {
                validationRule.setDeviceId(deviceId);
            } else {
                String family = ToolChainRegistryCoreActivator.getAttributeByElement(restrictionRule, "familyCondition", "family");
                validationRule.setFamily(family);
                String coreId = ToolChainRegistryCoreActivator.getAttributeByElement(restrictionRule, "coreIdCondition", "coreId");
                validationRule.setCoreId(coreId);
            }
            registry.addToolchainConditionRule((ToolchainConditionRule)validationRule);
        }
    }

    private static String getAttributeByElement(IConfigurationElement configuration, String element, String attribute) {
        IConfigurationElement[] children = configuration.getChildren(element);
        if (children.length > 0) {
            return children[0].getAttribute(attribute);
        }
        return "";
    }

    public void stop(BundleContext bundleContext) throws Exception {
        super.stop(bundleContext);
        this.toolChainRegistryServiceTracker.close();
        this.toolChainRegistryServiceTracker = null;
        this.toolChainRegistryService = null;
        INSTANCE = null;
        context = null;
    }

    public ToolChainRegistry getToolChainRegistry() {
        return this.toolChainRegistryService;
    }
}

