/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.elements;

import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.expression.Expression;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class BitFieldAssign {
    @NonNull
    protected static final Logger LOGGER = LogManager.getLogger(BitFieldAssign.class);
    @NonNull
    private String bitFieldID;
    @NonNull
    private @NonNull List<@NonNull Expression> conditions = new ArrayList<Expression>();
    @NonNull
    private @NonNull List<@NonNull Expression> valueExpressions = new ArrayList<Expression>();

    public BitFieldAssign(@NonNull String bitFieldID) {
        this.bitFieldID = bitFieldID;
    }

    public void addAssign(@NonNull Expression condition, @NonNull Expression valueExpression) {
        this.valueExpressions.add(valueExpression);
        this.conditions.add(condition);
    }

    public String getBitFieldID() {
        return this.bitFieldID;
    }

    public @NonNull List<@NonNull Expression> getConditions() {
        return this.conditions;
    }

    public @NonNull List<@NonNull Expression> getValueExpressions() {
        return this.valueExpressions;
    }

    public @Nullable Expression getActiveExpression(@NonNull IClocksConfig config) {
        ArrayList<Expression> results = new ArrayList<Expression>();
        int i = 0;
        while (i < this.conditions.size()) {
            if (this.conditions.get(i).resolve(config).getBoolean()) {
                results.add(this.valueExpressions.get(i));
            }
            ++i;
        }
        if (results.isEmpty()) {
            return null;
        }
        if (results.size() > 1) {
            LOGGER.severe("[DATA] Multiple when-conditions in bitfield assigns were evaluated as true for the same bitfield. This means there is an error in data! Bitfield: " + this.bitFieldID);
        }
        return (Expression)((Object)results.get(0));
    }
}

