/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.elements;

import com.nxp.swtools.clocks.data.elements.AClockElement;
import com.nxp.swtools.clocks.data.elements.AClockModelCreationElement;
import com.nxp.swtools.clocks.data.elements.ClockElementData;
import com.nxp.swtools.clocks.data.elements.ElementType;
import com.nxp.swtools.clocks.data.elements.Pin;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.settings.ClockOutputSetting;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.model.ENodeType;
import com.nxp.swtools.clocks.model.Node;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.frequency.Frequency;
import com.nxp.swtools.common.utils.frequency.FrequencyUnit;
import com.nxp.swtools.common.utils.rational.BigRational;
import java.util.List;

public class ClockOutput
extends AClockElement {
    @NonNull
    private String group;
    @Nullable
    private CMU cmu;
    @NonNull
    private @NonNull List<@NonNull Pin> pins;

    public ClockOutput(@NonNull ClockElementData elementData, @NonNull String inputSignal, @Nullable CMU cmu, @NonNull String group, @NonNull List<@NonNull Pin> pins) {
        super(elementData.getRegisters(), elementData.getId(), elementData.getName(), elementData.getDescription(), inputSignal, elementData.getConstraints(), elementData.getConfigElements(), elementData.isPrioritized());
        this.modelDevice = new ConsumerModel(this.id, ENodeType.Consumer);
        this.group = group;
        this.cmu = cmu;
        this.pins = pins;
    }

    @Override
    protected @NonNull ISetting createOutputFrequencySetting() {
        return new ClockOutputSetting(this);
    }

    @Override
    public String getType() {
        return ElementType.CLOCK_OUTPUT.toString();
    }

    public @NonNull String getGroup() {
        return this.group;
    }

    @Override
    public @Nullable Frequency getOutputFrequency(@NonNull IClocksConfig config) {
        BigRational freq;
        Node compNode = this.getComputationNode(config);
        if (compNode != null && (freq = compNode.getInputClock()) != null) {
            return new Frequency(freq, FrequencyUnit.HERTZ);
        }
        return null;
    }

    @Override
    protected void loadFromModel(@NonNull IClocksConfig config) {
    }

    @Override
    protected void saveToModel(@NonNull IClocksConfig config, boolean lockedOnly) {
        Node compNode = this.getComputationNode(config);
        if (compNode != null) {
            ISetting outputSetting = this.getOutputFrequencySetting();
            if (outputSetting != null && !outputSetting.isEnabled(config)) {
                compNode.disable();
            }
            this.saveOutputFrequency(config, compNode, lockedOnly, true);
        }
    }

    @Override
    public @Nullable ISetting getMainSetting() {
        return this.getOutputFrequencySetting();
    }

    public @Nullable CMU getCmuFreq() {
        return this.cmu;
    }

    public @NonNull List<@NonNull Pin> getPins() {
        return this.pins;
    }

    public static class CMU {
        @NonNull
        private String ID;
        @NonNull
        private String name;
        @Nullable
        private String description;
        @NonNull
        private ISetting controlSetting;
        @Nullable
        private String divTypeID;
        @NonNull
        private ISetting enableCMUSetting;
        @Nullable
        private ISetting lowFreqSetting;
        @Nullable
        private ISetting highFreqSetting;

        public CMU(@NonNull String ID, @NonNull String name, @Nullable String description, @NonNull ISetting controlSetting, @Nullable String divTypeID, @NonNull ISetting enableCMUSetting, @Nullable ISetting lowFreqSetting, @Nullable ISetting highFreqSetting) {
            this.ID = ID;
            this.name = name;
            this.description = description;
            this.controlSetting = controlSetting;
            this.divTypeID = divTypeID;
            this.enableCMUSetting = enableCMUSetting;
            this.lowFreqSetting = lowFreqSetting;
            this.highFreqSetting = highFreqSetting;
        }

        public @NonNull String getID() {
            return this.ID;
        }

        public @NonNull String getName() {
            return this.name;
        }

        public @Nullable String getDescription() {
            return this.description;
        }

        public @Nullable ISetting getControlSetting() {
            return this.controlSetting;
        }

        public @Nullable String getDivTypeID() {
            return this.divTypeID;
        }

        public @NonNull ISetting getEnableCMUSetting() {
            return this.enableCMUSetting;
        }

        public void setEnableCMUSetting(@NonNull ISetting enableCMUSetting) {
            this.enableCMUSetting = enableCMUSetting;
        }

        public @Nullable ISetting getLowFreqSetting() {
            return this.lowFreqSetting;
        }

        public void setLowFreqSetting(@Nullable ISetting lowFreqSetting) {
            this.lowFreqSetting = lowFreqSetting;
        }

        public @Nullable ISetting getHighFreqSetting() {
            return this.highFreqSetting;
        }

        public void setHighFreqSetting(@Nullable ISetting highFreqSetting) {
            this.highFreqSetting = highFreqSetting;
        }
    }

    private static class ConsumerModel
    extends AClockModelCreationElement {
        public ConsumerModel(@NonNull String id, @NonNull ENodeType type) {
            super(id, type);
        }
    }
}

