/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.elements;

import com.nxp.swtools.clocks.data.elements.AClockElement;
import com.nxp.swtools.clocks.data.elements.AClockModelCreationElement;
import com.nxp.swtools.clocks.data.elements.ClockElementData;
import com.nxp.swtools.clocks.data.elements.ElementType;
import com.nxp.swtools.clocks.data.elements.IElement;
import com.nxp.swtools.clocks.data.elements.PowerModeSpecificElement;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.model.LockState;
import com.nxp.swtools.clocks.data.model.SettingsConfig;
import com.nxp.swtools.clocks.data.settings.DFSPrescalerSetting;
import com.nxp.swtools.clocks.data.settings.EnableSetting;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.data.settings.SettingValue;
import com.nxp.swtools.clocks.data.valueMaps.ValueMap;
import com.nxp.swtools.clocks.expression.Expression;
import com.nxp.swtools.clocks.model.ClockModel;
import com.nxp.swtools.clocks.model.ENodeType;
import com.nxp.swtools.clocks.model.EScaleType;
import com.nxp.swtools.clocks.model.ModelCreationI;
import com.nxp.swtools.clocks.model.Node;
import com.nxp.swtools.clocks.model.TimingScale;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.NonNullByDefault;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.rational.BigRational;
import com.nxp.swtools.common.utils.text.UtilsText;
import java.math.BigInteger;
import java.util.Map;

@NonNullByDefault
public class DFSPrescaler
extends AClockElement {
    private static final String DEFAULT_SCALE = "2";

    public DFSPrescaler(ClockElementData elementData, ENodeType type, Map<Expression, ValueMap> values) {
        super(elementData.getRegisters(), elementData.getId(), elementData.getName(), elementData.getDescription(), elementData.getInputSignal(), elementData.getConstraints(), elementData.getConfigElements(), elementData.isPrioritized());
        super.setPowerModeSpecific(elementData.isPowerModeSpecific);
        DFSPrescalerSetting prescalerSetting = new DFSPrescalerSetting(this);
        this.addNestedSetting(prescalerSetting);
        this.values = values;
        EnableSetting enableSetting = new EnableSetting(this.id, (IElement)this, elementData.getEnableDisableConditions());
        enableSetting.setAutoDisableCondition(Expression.create(String.valueOf(this.id) + "." + "scale" + "==" + BigInteger.ZERO.toString()));
        this.addNestedSetting(enableSetting);
        this.modelDevice = new DFSPrescalerModel(this.id, type);
    }

    @Override
    public String getType() {
        return ElementType.DFS_PRESCALER.toString();
    }

    @Override
    protected @NonNull PowerModeSpecificElement createPowerModeSpecific() {
        return new PowerModeSpecificElement(() -> new DFSPrescalerSetting(this), () -> this.configElements);
    }

    private void updateTiming(Node compNode, IClocksConfig config) {
        ModelCreationI.ScaleData scaleData = this.createScaleData(config);
        if (this.isScaleUpdateRequired(scaleData, config)) {
            TimingScale timingScale = ClockModel.makeTimingScale((ModelCreationI.ScaleData)scaleData);
            compNode.setTimingScaleValues(timingScale);
        }
    }

    private boolean isScaleUpdateRequired(ModelCreationI.ScaleData scaleData, IClocksConfig config) {
        TimingScale timingScale = ClockModel.makeTimingScale((ModelCreationI.ScaleData)scaleData);
        Node compNode = this.getComputationNode(config);
        return compNode != null ? !compNode.getTimingScaleValues().equals((Object)timingScale) : false;
    }

    private ModelCreationI.ScaleData createCalculatedScaleData(@Nullable IClocksConfig config) {
        ModelCreationI.ScaleData scaleData = new ModelCreationI.ScaleData(EScaleType.Calculated);
        ValueMap activeValueMap = this.getActiveValueMap(config);
        if (activeValueMap != null) {
            scaleData.calculus = activeValueMap.getCalculus();
        }
        return scaleData;
    }

    public ModelCreationI.ScaleData createScaleData(@Nullable IClocksConfig config) {
        ValueMap activeValueMap = this.getActiveValueMap(config);
        ModelCreationI.ScaleData data = null;
        if (activeValueMap != null) {
            data = this.createCalculatedScaleData(config);
        } else {
            LOGGER.severe("ActiveValueMap is null for " + this.id);
            data = new ModelCreationI.ScaleData(EScaleType.SetSmall);
        }
        return data;
    }

    @Override
    protected void saveToModel(IClocksConfig config, boolean lockedOnly) {
        SettingsConfig settingsConfig = config.getSettingsConfig();
        ISetting dfsPrescalerSetting = this.getFrequencyModifierSetting();
        assert (dfsPrescalerSetting != null);
        SettingValue prescalerSettingValue = settingsConfig.getSettingValue(dfsPrescalerSetting);
        Node compNode = this.getComputationNode(config);
        if (compNode != null) {
            compNode.clean();
            boolean isOutputFreqSaved = this.saveOutputFrequency(config, compNode, lockedOnly, false);
            this.updateTiming(compNode, config);
            if (isOutputFreqSaved) {
                return;
            }
            BigRational currentValue = null;
            if (!SettingValue.N_A.equals(prescalerSettingValue)) {
                try {
                    currentValue = BigRational.tryParse((String)UtilsText.safeToString((Object)prescalerSettingValue.getValue()));
                }
                catch (NumberFormatException numberFormatException) {
                    LOGGER.warning("Invalid value encountered for element " + this.name + ", using N_A instead.");
                }
            }
            if (dfsPrescalerSetting.isEnabled(config) && currentValue != null && currentValue.compareTo(BigRational.ZERO) != 0) {
                compNode.setDefaultScale(new BigRational(currentValue));
                BigRational dividerToSet = null;
                LockState lockState = settingsConfig.getLockState(dfsPrescalerSetting);
                if (!lockedOnly || lockState != null) {
                    BigRational bigRational = dividerToSet = lockState == null ? currentValue : BigRational.tryParse((String)UtilsText.safeToString((Object)lockState.getValue().getValue()));
                }
                if (dividerToSet == null) {
                    compNode.setScale(null);
                } else {
                    compNode.setScale(new BigRational(dividerToSet));
                    dfsPrescalerSetting.parseUiValue(dividerToSet.toString(), config);
                }
            } else {
                compNode.disable();
            }
        }
    }

    @Override
    public void loadFromModel(IClocksConfig config) {
        ISetting prescalerSetting = this.getFrequencyModifierSetting();
        assert (prescalerSetting != null);
        Node compNode = this.getComputationNode(config);
        if (compNode != null) {
            BigRational scale = compNode.getScale();
            SettingValue value = null;
            if (scale != null) {
                value = prescalerSetting.parseValue(scale, config);
                if (value == null) {
                    value = SettingValue.N_A;
                }
                config.setSettingValue(prescalerSetting, value, false, false);
            } else {
                LOGGER.warning("Not valid scale loaded for element: " + this.id);
            }
        }
    }

    @Override
    public @Nullable SettingValue getEnableValue(IClocksConfig config) {
        ISetting mainSetting = this.getMainSetting();
        assert (mainSetting != null);
        return mainSetting.parseUiValue(DEFAULT_SCALE, config);
    }

    private class DFSPrescalerModel
    extends AClockModelCreationElement {
        private ModelCreationI.ScaleData scaleData;

        public DFSPrescalerModel(String id, ENodeType type) {
            super(id, type);
            this.scaleData = DFSPrescaler.this.createScaleData(null);
        }

        @Override
        public @Nullable BigRational getDefaultScale() {
            ValueMap activeValueMap = DFSPrescaler.this.getActiveValueMap(null);
            return activeValueMap != null ? new BigRational(UtilsText.safeToString((Object)activeValueMap.getDefaultControlValue())) : new BigRational(DFSPrescaler.DEFAULT_SCALE);
        }

        @Override
        public ModelCreationI.ScaleData getScaleData() {
            return this.scaleData;
        }
    }
}

