/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.elements;

import com.nxp.swtools.clocks.data.elements.IElement;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.settings.EnableSetting;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;

@Root(name="power_mode")
public class PowerMode
implements IElement {
    @NonNull
    private static final Logger LOGGER = LogManager.getLogger(PowerMode.class);
    @Attribute(name="type")
    @Nullable
    private @Attribute(name="type") @Nullable String mTypeStr;
    @NonNull
    private Type mType;
    @Attribute(name="description")
    @NonNull
    private @Attribute(name="description") @NonNull String mDescription;
    @Attribute(name="id")
    @NonNull
    private @Attribute(name="id") @NonNull String mId;
    @Attribute(name="default", required=false)
    private boolean mIsDefault;

    public static @NonNull PowerMode createDefaultRun() {
        return new PowerMode(Type.RUN, "Default run mode", "RUN", true);
    }

    public PowerMode(@Attribute(name="type") @NonNull @Attribute(name="type") String type, @Attribute(name="description") @NonNull @Attribute(name="description") String description, @Attribute(name="id") @NonNull @Attribute(name="id") String id, @Attribute(name="default") @Attribute(name="default") boolean isDefault) {
        this(Type.fromValue(type), description, id, isDefault);
    }

    public PowerMode(@Attribute(name="type") @NonNull @Attribute(name="type") String type, @Attribute(name="description") @NonNull @Attribute(name="description") String description, @Attribute(name="id") @NonNull @Attribute(name="id") String id) {
        this(Type.fromValue(type), description, id, false);
    }

    public PowerMode(@NonNull Type type, @NonNull String description, @NonNull String id, boolean isDefault) {
        this.mDescription = description;
        this.mId = id;
        this.mType = type;
        this.mTypeStr = type.toString();
        this.mIsDefault = isDefault;
    }

    protected static Logger getLogger() {
        return LOGGER;
    }

    public @NonNull Type getType() {
        return this.mType;
    }

    @Override
    public @NonNull String getName() {
        return this.mId;
    }

    @Override
    public @NonNull String getID() {
        return this.mId;
    }

    @Override
    public boolean isEnabled(@NonNull IClocksConfig config) {
        return true;
    }

    public String toString() {
        return this.mId;
    }

    @Override
    public @Nullable EnableSetting getEnableSetting() {
        return null;
    }

    @Override
    public @NonNull String getDescription() {
        return this.mDescription;
    }

    public boolean isDefault() {
        return this.mIsDefault;
    }

    @Root(name="power_modes", strict=false)
    public static class PowerModeFile {
        @ElementList(entry="power_mode", inline=true)
        @NonNull
        private @ElementList(entry="power_mode", inline=true) @NonNull List<@NonNull PowerMode> mAllModes = new ArrayList<PowerMode>();

        public @NonNull List<@NonNull PowerMode> getModes() {
            return this.mAllModes;
        }
    }

    public static enum Type {
        RUN("run"),
        WAIT("wait"),
        STOP("stop"),
        OTHER("other");

        @NonNull
        private final String mValue;

        private Type(String val) {
            this.mValue = val;
        }

        public static @NonNull Type fromValue(@Nullable String str) {
            Type[] typeArray = Type.values();
            int n = typeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Type c = typeArray[n2];
                if (c.mValue.equals(str)) {
                    return c;
                }
                ++n2;
            }
            PowerMode.getLogger().warning("No type for value:'" + str + "'. Using '" + (Object)((Object)OTHER) + "' instead.");
            return OTHER;
        }
    }
}

