/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.elements;

import com.nxp.swtools.clocks.data.IMcu;
import com.nxp.swtools.clocks.data.model.BitFieldElement;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.model.SettingsConfig;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.data.settings.SettingValue;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.utils.registers.BitField;
import java.util.Collection;

public class SettingProvider {
    public static @Nullable ISetting getSettingById(@NonNull String id, @NonNull IMcu mcu) {
        return mcu.getSettings().findSettingWithId(id);
    }

    public static @Nullable ISetting getPowerModeSpecificSettingById(@NonNull String id, @NonNull String powerMode, @NonNull IMcu mcu) {
        return mcu.getSettings().findPowerModeSpecificSettingWithId(id, powerMode);
    }

    public static @Nullable SettingValue getValueBySettingId(@NonNull String id, @NonNull IMcu mcu, @NonNull SettingsConfig settingsConfig) {
        ISetting setting = SettingProvider.getSettingById(id, mcu);
        if (setting != null) {
            return settingsConfig.getSettingValue(setting);
        }
        return null;
    }

    public static @Nullable SettingValue getValueBySettingId(@NonNull String id, @Nullable String powerMode, @NonNull IMcu mcu, @NonNull SettingsConfig settingsConfig) {
        if (powerMode == null) {
            return SettingProvider.getValueBySettingId(id, mcu, settingsConfig);
        }
        ISetting setting = SettingProvider.getPowerModeSpecificSettingById(id, powerMode, mcu);
        if (setting != null) {
            return settingsConfig.getSettingValue(setting);
        }
        return null;
    }

    public static @Nullable SettingValue getDefaultValueBySettingId(@NonNull String id, @NonNull IMcu mcu, @NonNull IClocksConfig clockConfig) {
        ISetting setting = SettingProvider.getSettingById(id, mcu);
        if (setting != null) {
            return setting.getDefaultValue(clockConfig);
        }
        return null;
    }

    public static @NonNull String getBitFieldSettingID(@NonNull String bitFieldID) {
        return String.valueOf(bitFieldID) + "." + "bitField";
    }

    public static @Nullable ISetting getBitFieldSetting(@NonNull BitFieldElement bitField, @NonNull IMcu mcu) {
        return SettingProvider.getSettingById(SettingProvider.getBitFieldSettingID(bitField.getID()), mcu);
    }

    public static @Nullable ISetting getBitFieldSetting(@NonNull String bitFieldID, @NonNull IMcu mcu) {
        BitField bitField = mcu.getBitFieldsCache().getBitField(bitFieldID);
        return bitField != null ? SettingProvider.getSettingById(SettingProvider.getBitFieldSettingID(bitField.getId()), mcu) : null;
    }

    public static void addBitFieldSetting(@NonNull Collection<@NonNull String> settings, @NonNull String bitFieldID, @NonNull IMcu mcu) {
        ISetting settingById = SettingProvider.getBitFieldSetting(bitFieldID, mcu);
        if (settingById != null) {
            settings.add(settingById.getId());
        }
    }
}

