/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.elements;

import com.nxp.swtools.clocks.data.Constraint;
import com.nxp.swtools.clocks.data.IMcu;
import com.nxp.swtools.clocks.data.elements.ConfigElement;
import com.nxp.swtools.clocks.data.elements.EnableDisableCondition;
import com.nxp.swtools.clocks.data.elements.IConfigElement;
import com.nxp.swtools.clocks.data.elements.IConfigElementItem;
import com.nxp.swtools.clocks.data.elements.IElement;
import com.nxp.swtools.clocks.data.elements.PowerMode;
import com.nxp.swtools.clocks.data.elements.PowerModeSpecificElement;
import com.nxp.swtools.clocks.data.elements.SettingProvider;
import com.nxp.swtools.clocks.data.model.ClocksProblem;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.model.Range;
import com.nxp.swtools.clocks.data.settings.EnableSetting;
import com.nxp.swtools.clocks.data.settings.GlobalConfigElementSetting;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.data.settings.LocalConfigElementSetting;
import com.nxp.swtools.clocks.data.settings.OutputFrequencySetting;
import com.nxp.swtools.clocks.data.settings.SettingValue;
import com.nxp.swtools.clocks.expression.Expression;
import com.nxp.swtools.clocks.main.Messages;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.IValue;
import com.nxp.swtools.common.utils.frequency.Frequency;
import com.nxp.swtools.common.utils.frequency.FrequencyCalculator;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.rational.BigRational;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ValueConfigElement
implements IConfigElement {
    public static final int INPUT_LIMIT = 250;
    @NonNull
    private static final Logger LOGGER = LogManager.getLogger(ConfigElement.class);
    @NonNull
    private String id;
    @NonNull
    private String name;
    @NonNull
    private String description;
    @NonNull
    private IConfigElementItem valueItem;
    @NonNull
    private String defaultItem;
    @NonNull
    private ISetting setting;
    @NonNull
    protected final PowerModeSpecificElement powerModeSpecific;
    @NonNull
    private @NonNull List<@NonNull Constraint> constraints;
    @Nullable
    private EnableSetting enableSetting;
    @Nullable
    private Boolean signed;
    @NonNull
    private Expression availability;
    private boolean hidden;
    @NonNull
    private ConfigElemInputType configElemInputType;
    @NonNull
    private static final String FREQUENCY_TYPE_INPUT_STRING = "freq";
    @NonNull
    private static final String INTEGER_TYPE_INPUT_STRING = "integer";

    public ValueConfigElement(@NonNull String id, @NonNull String name, @NonNull String description, @NonNull IConfigElementItem item, @NonNull String defaultItem, boolean global, @NonNull List<@NonNull Constraint> constraints, @NonNull List<@NonNull EnableDisableCondition> enableDisableConditions, @NonNull String signed, @NonNull String configElemInputType, @NonNull String availability, boolean hidden, boolean powerModeSpecific) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.valueItem = item;
        this.defaultItem = defaultItem;
        this.setting = global ? new GlobalConfigElementSetting(this) : new LocalConfigElementSetting(this);
        this.powerModeSpecific = new PowerModeSpecificElement(() -> global ? new GlobalConfigElementSetting(this) : new LocalConfigElementSetting(this), Collections::emptyList);
        this.constraints = new ArrayList<Constraint>(constraints);
        if (!enableDisableConditions.isEmpty()) {
            this.enableSetting = new EnableSetting(id, (IElement)this, enableDisableConditions);
        }
        this.signed = signed.isEmpty() ? null : Boolean.valueOf(signed);
        this.configElemInputType = this.getConfigElemInputTypeByType(configElemInputType);
        this.availability = Expression.create(availability);
        this.hidden = hidden;
        this.setPowerModeSpecific(powerModeSpecific);
    }

    @Override
    public @NonNull String getName() {
        return this.name;
    }

    @Override
    public @NonNull String getID() {
        return this.id;
    }

    @Override
    public @NonNull String getDescription() {
        return this.description;
    }

    @Override
    public boolean isEnabled(@NonNull IClocksConfig config) {
        EnableSetting settingEnable = this.getEnableSetting();
        if (settingEnable != null) {
            config.getSettingsConfig().setSettingValue(settingEnable, settingEnable.createCurrentValue(config));
            return settingEnable.isEnabled(config);
        }
        return true;
    }

    @Override
    public @Nullable EnableSetting getEnableSetting() {
        return this.enableSetting;
    }

    @Override
    public @Nullable Collection<@NonNull IConfigElementItem> getItems() {
        return null;
    }

    @Override
    public @NonNull Collection<@NonNull String> getItemNames() {
        return Arrays.asList(this.valueItem.getName());
    }

    @Override
    public @NonNull String getDefaultItem() {
        return this.defaultItem;
    }

    @Override
    public boolean isWritable() {
        return true;
    }

    @Override
    public @Nullable IConfigElementItem getActiveItem(@NonNull IClocksConfig config) {
        return this.valueItem;
    }

    @Override
    public @NonNull ISetting getSetting() {
        return this.setting;
    }

    @Override
    public @NonNull SettingValue createCurrentValue(@NonNull IClocksConfig config) {
        String exp = this.valueItem.getReverseExpr();
        if (config.isImporting() && exp != null) {
            try {
                Expression revExp = Expression.create(exp);
                IValue valueExpressionResult = revExp.resolve(config);
                BigInteger value = valueExpressionResult.getRational().toBigIntegerRounded(false);
                return new SettingValue(value.toString());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOGGER.log(Level.SEVERE, "Fail parsing expression: " + this.id);
                return new SettingValue(BigRational.ZERO.toString());
            }
            catch (Exception exception) {
                LOGGER.log(Level.SEVERE, "Fail resolving setting: " + this.id);
                return new SettingValue(BigRational.ZERO.toString());
            }
        }
        return config.getSettingsConfig().getSettingValue(this.setting);
    }

    public @Nullable SettingValue parseUiValue(@NonNull String uiValue, @NonNull IClocksConfig clocksConfig) {
        switch (this.configElemInputType) {
            case FREQUENCY: {
                Frequency frequencyValue = this.parseFrequency(uiValue, clocksConfig);
                if (frequencyValue != null) {
                    return OutputFrequencySetting.parseValue(frequencyValue);
                }
                return null;
            }
            case INTEGER: {
                BigRational rationalValue = BigRational.tryParse((String)uiValue);
                if (rationalValue != null) {
                    if (this.signed != null && !this.signed.booleanValue() && rationalValue.compareTo(BigRational.ZERO) < 0) {
                        return null;
                    }
                    return new SettingValue(uiValue);
                }
                return null;
            }
        }
        return new SettingValue(uiValue);
    }

    public @Nullable Frequency parseFrequency(String uiValue, IClocksConfig clocksConfig) {
        Object prevValue = clocksConfig.getSettingsConfig().getSettingValue(this.setting).getValue();
        Frequency prevValueFreq = prevValue instanceof String ? Frequency.parseNonNull((String)((String)prevValue)) : (Frequency)prevValue;
        return uiValue != null ? FrequencyCalculator.fromUiValue((String)uiValue, (Frequency)prevValueFreq) : null;
    }

    @Override
    public @NonNull List<@NonNull Constraint> getElementConstraints(@NonNull IClocksConfig clocksConfig) {
        IConfigElementItem activeItem = this.getActiveItem(clocksConfig);
        if (activeItem != null) {
            return this.getConstraintsOf(activeItem.getID());
        }
        return CollectionsUtils.emptyList();
    }

    @Override
    public @NonNull Collection<@NonNull String> getAllControledSettings(@NonNull IMcu mcu) {
        HashSet<@NonNull String> bitFieldSettings = new HashSet<String>();
        this.valueItem.getUsedBitFields().forEach(x -> SettingProvider.addBitFieldSetting(bitFieldSettings, x, mcu));
        return bitFieldSettings;
    }

    @Override
    public @NonNull Collection<@NonNull String> getDependencies(@NonNull IMcu mcu) {
        HashSet<@NonNull String> dependencies = new HashSet<String>(this.valueItem.getDependencies(mcu));
        dependencies.remove(this.id);
        return dependencies;
    }

    @Override
    public @NonNull Map<@NonNull ISetting, @NonNull SettingValue> getBitFieldsToWrite(@NonNull String item, @NonNull IClocksConfig config) {
        @NonNull HashMap<@NonNull ISetting, @NonNull SettingValue> bitFieldSettings = new HashMap<ISetting, SettingValue>();
        IConfigElementItem configElementItem = this.valueItem;
        Set<Map.Entry<@NonNull String, @NonNull Long>> assignEntries = configElementItem.getBitFieldsToAssignForConfig(config).entrySet();
        for (Map.Entry<String, Long> assignEntry : assignEntries) {
            ISetting bitFieldSetting = SettingProvider.getBitFieldSetting(assignEntry.getKey(), config.getMcu());
            if (bitFieldSetting == null) continue;
            SettingValue settingValue = bitFieldSetting.parseValue(assignEntry.getValue(), config);
            if (settingValue == null) {
                Range range = bitFieldSetting.getRangeOfValues(config);
                if (range != null && range.getMax().longValue() < assignEntry.getValue()) {
                    config.addError(this.id, MessageFormat.format(Messages.get().BitFieldSetting_Overflow, assignEntry.getKey()), ClocksProblem.Type.LOCAL);
                }
                throw new UnsupportedOperationException();
            }
            bitFieldSettings.put(bitFieldSetting, settingValue);
        }
        return bitFieldSettings;
    }

    @Override
    public @NonNull List<@NonNull Constraint> getConstraintsOf(@NonNull String itemId) {
        return (List)this.constraints.stream().filter(x -> x.getElementID().equals(String.valueOf(this.id) + "." + itemId)).collect(CollectorsUtils.toList());
    }

    @Override
    public @NonNull Collection<@NonNull String> getItemsBitFields() {
        return this.valueItem.getUsedBitFields();
    }

    @Override
    public boolean isSharingRegisters(@NonNull IClocksConfig config) {
        return false;
    }

    @Override
    public @NonNull List<@NonNull ISetting> getSharedList() {
        return new ArrayList<ISetting>();
    }

    @Override
    public @NonNull Map<@NonNull String, @NonNull ISetting> createPowerModeSpecificSettings(@NonNull List<@NonNull PowerMode> powerModes) {
        return this.powerModeSpecific.createPowerModeSpecificSettings(powerModes);
    }

    @Override
    public void setPowerModeSpecific(boolean isPowerModeSpecific) {
        this.powerModeSpecific.setPowerModeSpecific(isPowerModeSpecific);
    }

    @Override
    public boolean isPowerModeSpecific() {
        return this.powerModeSpecific.isPowerModeSpecific();
    }

    @Override
    public boolean isAvailable(@NonNull IClocksConfig config) {
        return this.availability.resolve(config).getBoolean();
    }

    public @Nullable Boolean getSign() {
        return this.signed;
    }

    public @NonNull ConfigElemInputType getConfigElemInputType() {
        return this.configElemInputType;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public @NonNull List<@NonNull ISetting> getPowerModeSpecificSettings() {
        return this.powerModeSpecific.getPowerModeSpecificSettings();
    }

    private @NonNull ConfigElemInputType getConfigElemInputTypeByType(@NonNull String inputType) {
        if (FREQUENCY_TYPE_INPUT_STRING.equals(inputType)) {
            return ConfigElemInputType.FREQUENCY;
        }
        if (INTEGER_TYPE_INPUT_STRING.equals(inputType) || inputType.isEmpty() && this.getSign() != null) {
            return ConfigElemInputType.INTEGER;
        }
        return ConfigElemInputType.STRING;
    }

    public static enum ConfigElemInputType {
        FREQUENCY,
        INTEGER,
        STRING;

    }
}

