/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.settings;

import com.nxp.swtools.clocks.data.Constraint;
import com.nxp.swtools.clocks.data.IMcu;
import com.nxp.swtools.clocks.data.elements.IConfigElement;
import com.nxp.swtools.clocks.data.elements.IConfigElementItem;
import com.nxp.swtools.clocks.data.elements.ValueConfigElement;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.settings.AGlobalSetting;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.data.settings.SettingType;
import com.nxp.swtools.clocks.data.settings.SettingValue;
import com.nxp.swtools.clocks.utils.ParenthesesType;
import com.nxp.swtools.clocks.utils.Text;
import com.nxp.swtools.clocks.utils.ToolTipBuilder;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class GlobalConfigElementSetting
extends AGlobalSetting {
    @NonNull
    private IConfigElement configElement;

    public GlobalConfigElementSetting(@NonNull IConfigElement element) {
        super(element);
        this.configElement = element;
    }

    @Override
    public @NonNull String getId() {
        String id = this.configElement.getID();
        if (this.powerMode != null) {
            id = String.valueOf(this.powerMode) + ":" + id;
        }
        return id;
    }

    @Override
    public @NonNull String getName() {
        String lName = this.configElement.getName();
        return this.powerMode != null ? String.valueOf(lName) + " " + Text.wrapWithParentheses(this.powerMode, ParenthesesType.ROUND) : lName;
    }

    @Override
    public @NonNull SettingType getType() {
        return SettingType.GLOBAL_CONFIG_ELEMENT;
    }

    @Override
    public @Nullable List<@NonNull SettingValue> getValues(@NonNull IClocksConfig clocksConfig) {
        Collection<@NonNull IConfigElementItem> items = this.configElement.getItems();
        if (items == null) {
            return null;
        }
        return (List)items.stream().map(x -> new SettingValue(x.getID(), x.getName())).collect(CollectorsUtils.toList());
    }

    @Override
    public @Nullable SettingValue parseUiValue(@NonNull String uiValue, @NonNull IClocksConfig clocksConfig) {
        List<@NonNull SettingValue> values = this.getValues(clocksConfig);
        if (values != null) {
            for (SettingValue settingVal : values) {
                if (!settingVal.getUiValue().equals(uiValue)) continue;
                return settingVal;
            }
        } else if (this.configElement instanceof ValueConfigElement) {
            ValueConfigElement valueConfigElement = (ValueConfigElement)this.configElement;
            return valueConfigElement.parseUiValue(uiValue, clocksConfig);
        }
        return null;
    }

    @Override
    public @NonNull SettingValue createCurrentValue(@NonNull IClocksConfig config) {
        return this.configElement.createCurrentValue(config);
    }

    @Override
    public boolean isWritable() {
        return this.configElement.isWritable();
    }

    @Override
    public boolean canWrite(@NonNull IClocksConfig config, @NonNull Collection<@NonNull String> resolvedSettingIds) throws UnsupportedOperationException {
        if (this.isWritable()) {
            return resolvedSettingIds.containsAll(this.configElement.getDependencies(config.getMcu()));
        }
        return super.canWrite(config, resolvedSettingIds);
    }

    @Override
    public @Nullable SettingValue getDefaultValue(IClocksConfig clockConfig) {
        Optional<IConfigElementItem> item;
        String defaultItem = this.configElement.getDefaultItem();
        Collection<@NonNull IConfigElementItem> items = this.configElement.getItems();
        if (items != null && (item = items.stream().filter(it -> it.getID().equals(defaultItem)).findFirst()).isPresent()) {
            return new SettingValue(item.get().getID(), item.get().getName());
        }
        return new SettingValue(defaultItem, defaultItem);
    }

    @Override
    public @NonNull Collection<@NonNull String> getDependencies(@NonNull IMcu mcu) {
        Collection<@NonNull String> dependencies = this.configElement.getDependencies(mcu);
        dependencies.addAll(this.getInfluencedSettings(mcu));
        return dependencies;
    }

    @Override
    public @NonNull Collection<@NonNull String> getUsedBitFields() {
        return this.configElement.getItemsBitFields();
    }

    @Override
    public @NonNull Collection<@NonNull String> getInfluencedSettings(@NonNull IMcu mcu) {
        return this.configElement.getAllControledSettings(mcu);
    }

    @Override
    public boolean canRead(@NonNull IClocksConfig config, @NonNull Collection<@NonNull String> resolvedSettingIds) {
        return resolvedSettingIds.containsAll(config.getMcu().getSettingDependencies().getPredecessors(this.getId()));
    }

    @Override
    public @NonNull Map<@NonNull ISetting, @NonNull SettingValue> getBitFieldsToWrite(@NonNull IClocksConfig config, @NonNull SettingValue value) throws UnsupportedOperationException {
        return this.configElement.getBitFieldsToWrite(UtilsText.safeToString((Object)value.getValue()), config);
    }

    @Override
    public boolean isUserLockable() {
        return false;
    }

    @Override
    public boolean isLockedByDefault() {
        return true;
    }

    @Override
    public @Nullable SettingValue parseValue(@NonNull Object value, @NonNull IClocksConfig clocksConfig) {
        List<@NonNull SettingValue> values = this.getValues(clocksConfig);
        if (values != null) {
            for (SettingValue settingVal : values) {
                if (!settingVal.getValue().equals(value)) continue;
                return settingVal;
            }
        }
        LOGGER.warning("Didn't find coresponding setting value, creating one.");
        return new SettingValue(value);
    }

    @Override
    public boolean isValid(@NonNull SettingValue settingValue, @NonNull IClocksConfig clocksConfig) {
        return !settingValue.isN_A() && clocksConfig.getProblemsOfElement(this.element.getID(), 2).isEmpty();
    }

    @Override
    public boolean isVisible(@Nullable IClocksConfig config) {
        if (config == null) {
            return !this.configElement.isHidden();
        }
        return !this.configElement.isHidden() && this.configElement.isAvailable(config);
    }

    @Override
    public boolean settingShouldBeSaved(@NonNull IClocksConfig currentConfig) {
        IClocksConfig defaultConfig = currentConfig.getMcu().getDefaultConfig();
        boolean differs = this.isUserLockable() && (currentConfig.isLocked(this) || defaultConfig.isLocked(this)) ? this.isLockDifferent(currentConfig, defaultConfig) : this.isValueDifferent(currentConfig, defaultConfig);
        return differs || this.isUserEnableable() && this.isUserEnableDifferent(currentConfig, defaultConfig);
    }

    @Override
    public @Nullable String getToolTipText(@NonNull IClocksConfig clocksConfig) {
        return ToolTipBuilder.create(this.configElement, clocksConfig);
    }

    @Override
    public boolean hasConflicts(@NonNull SettingValue value, @NonNull IClocksConfig clocksConfig) {
        String stringValue = UtilsText.safeToString((Object)value.getValue());
        List<@NonNull Constraint> constraints = this.configElement.getConstraintsOf(stringValue);
        for (Constraint constraint : constraints) {
            if (constraint.isValid(clocksConfig) || constraint.getLevel() != Constraint.Level.ERROR) continue;
            return true;
        }
        return false;
    }

    @Override
    public @Nullable String getToolTipText(@NonNull SettingValue value, @NonNull IClocksConfig clocksConfig) {
        String description = null;
        Collection<@NonNull IConfigElementItem> items = this.configElement.getItems();
        if (items == null) {
            description = this.configElement.getDescription();
        } else {
            assert (items != null);
            for (IConfigElementItem item : items) {
                if (!item.getID().equals(value.getValue())) continue;
                description = item.getDescription();
                break;
            }
        }
        return description;
    }
}

