/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.valueMaps;

import com.nxp.swtools.clocks.data.LongValues;
import com.nxp.swtools.clocks.data.model.BitFieldElement;
import com.nxp.swtools.clocks.data.model.Range;
import com.nxp.swtools.clocks.data.settings.SettingValue;
import com.nxp.swtools.clocks.data.valueMaps.AValueMapInternal;
import com.nxp.swtools.clocks.expression.Expression;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

final class EntryValueMap
extends AValueMapInternal {
    @NonNull
    @NonNull Map<@NonNull LongValues, ValueEntry> entries;
    @NonNull
    @NonNull Map<@NonNull String, ValueEntry> uiEntries;
    @NonNull
    private ValueEntry defaultEntry;

    EntryValueMap(@NonNull Expression expression, @NonNull BitFieldElement @NonNull [] bitFields, @NonNull Map<@NonNull LongValues, @NonNull ValueEntry> entries, @NonNull Map<@NonNull String, @NonNull ValueEntry> uiEntries, int fractionalBits) {
        super(expression, bitFields, fractionalBits);
        this.entries = entries;
        this.uiEntries = uiEntries;
        this.defaultEntry = this.findDefaultEntry();
    }

    @Override
    public Collection<@NonNull String> getUiValues() {
        return CollectionsUtils.unmodifiableSet((Set)CollectionsUtils.safeKeySet(this.uiEntries));
    }

    @Override
    public List<@NonNull String> getSortedUiValues() {
        ArrayList<@NonNull String> uiValuesList = new ArrayList<String>(this.getUiValues());
        if (!AValueMapInternal.sortIntegerList(uiValuesList) && !AValueMapInternal.sortDecimalList(uiValuesList)) {
            AValueMapInternal.sortStringList(uiValuesList);
        }
        return uiValuesList;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<LongValues, ValueEntry> valueEntry : this.entries.entrySet()) {
            LongValues values = valueEntry.getKey();
            String control = valueEntry.getValue().controlValue.toString();
            String uiValue = valueEntry.getValue().uiValue;
            sb.append("(").append(values).append(", ").append(control).append(", ").append(uiValue).append(")\n");
        }
        return sb.toString();
    }

    @Override
    public @NonNull Collection<@NonNull Object> getControlValues() {
        ArrayList<@NonNull Object> validValues = new ArrayList<Object>();
        for (ValueEntry entry : this.entries.values()) {
            validValues.add(entry.controlValue);
        }
        return validValues;
    }

    @Override
    public void replaceControlValue(@NonNull Object old, @NonNull Object replacement) {
        for (ValueEntry entry : this.entries.values()) {
            if (!entry.controlValue.equals(old)) continue;
            entry.controlValue = replacement;
        }
    }

    @Override
    public @NonNull String getDefaultUiValue() {
        return this.defaultEntry.uiValue;
    }

    @Override
    public @NonNull LongValues getDefaultBfValues() {
        return this.defaultEntry.bitFieldValues;
    }

    private @NonNull ValueEntry findDefaultEntry() {
        LongValues.Builder builder = new LongValues.Builder();
        BitFieldElement[] bitFieldElementArray = this.bitFields;
        int n = this.bitFields.length;
        int n2 = 0;
        while (n2 < n) {
            BitFieldElement bitField = bitFieldElementArray[n2];
            Long value = bitField.getBitField().getResetValue().longValue();
            assert (value != null);
            builder.addValue(value);
            ++n2;
        }
        ValueEntry result = null;
        LongValues values = builder.build();
        if (this.entries.containsKey(values)) {
            result = this.entries.get(values);
        } else {
            Iterator<Map.Entry<LongValues, ValueEntry>> defaultEntryIterator = this.entries.entrySet().iterator();
            if (defaultEntryIterator.hasNext()) {
                result = defaultEntryIterator.next().getValue();
                LOGGER.info(MessageFormat.format("No default value found for bit-fields: {0} of the expression {1}.  {2} will be used as default value.", values, this.expression.toString(), result));
            } else {
                result = new ValueEntry(new LongValues(0L), SettingValue.N_A.getUiValue(), new Integer(0));
                LOGGER.severe("No value found. Default value will be 0");
            }
        }
        assert (result != null);
        return result;
    }

    @Override
    public @NonNull Object getDefaultControlValue() {
        return this.defaultEntry.controlValue;
    }

    @Override
    public @Nullable Object getControlValueByUiValue(@NonNull String value) {
        if (this.uiEntries.containsKey(value)) {
            return Objects.requireNonNull(this.uiEntries.get((Object)value)).controlValue;
        }
        return null;
    }

    @Override
    public @Nullable LongValues getBfFromUiValue(@NonNull String value) {
        if (this.uiEntries.containsKey(value)) {
            return Objects.requireNonNull(this.uiEntries.get((Object)value)).bitFieldValues;
        }
        return null;
    }

    @Override
    public LongValues getBfFromControlValue(@NonNull Object value) {
        for (ValueEntry entry : this.entries.values()) {
            if (!entry.controlValue.equals(value)) continue;
            return entry.bitFieldValues;
        }
        return null;
    }

    @Override
    public @Nullable String getUiValueByBfValue(@NonNull LongValues values) {
        if (this.entries.containsKey(values)) {
            return Objects.requireNonNull(this.entries.get((Object)values)).uiValue;
        }
        return null;
    }

    @Override
    public @Nullable Object getControlValueByBfValue(@NonNull LongValues values) {
        if (this.entries.containsKey(values)) {
            return Objects.requireNonNull(this.entries.get((Object)values)).controlValue;
        }
        return null;
    }

    @Override
    public @Nullable String getUiValueByControlValue(@NonNull Object value) {
        LongValues bitFieldValue = this.getBfFromControlValue(value);
        if (bitFieldValue != null) {
            return this.getUiValueByBfValue(bitFieldValue);
        }
        return null;
    }

    @Override
    public @Nullable Range getRange() {
        return null;
    }

    @Override
    public @NonNull BigInteger getSize() {
        return BigInteger.valueOf(this.entries.size());
    }

    protected static class ValueEntry {
        @NonNull
        LongValues bitFieldValues;
        @NonNull
        String uiValue;
        @NonNull
        Object controlValue;

        ValueEntry(@NonNull LongValues bitFieldValues, @NonNull String uiValue, @NonNull Object controlValue) {
            this.bitFieldValues = bitFieldValues;
            this.uiValue = uiValue;
            this.controlValue = controlValue;
        }

        public String toString() {
            return "(" + this.bitFieldValues + ", " + this.uiValue + ", " + this.controlValue + ")";
        }
    }
}

