/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.resources;

import com.nxp.swtools.clocks.data.IMcuDescriptor;
import com.nxp.swtools.clocks.resources.ProcessorFilterForClocksTool;
import com.nxp.swtools.common.utils.NonNullByDefault;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.configuration.PEConfiguration;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.kex.selector.McuIdentification;
import com.nxp.swtools.utils.resources.DataDirectoryUtils;
import java.io.File;
import java.util.logging.Logger;
import org.eclipse.core.runtime.Platform;

@NonNullByDefault
public class DataDirectory {
    private static final Logger LOGGER = LogManager.getLogger(DataDirectory.class);

    public static String getClocksJavaScriptDir(IMcuDescriptor mcuDescriptor) {
        return String.valueOf(DataDirectory.getDataDir()) + File.separator + ProcessorFilterForClocksTool.getDbFileClockScripts(DataDirectory.convertMcuDesctiptorToMcuIdentification(mcuDescriptor));
    }

    public static String getPeripheralSignalsFile(IMcuDescriptor mcuDescriptor) {
        return String.valueOf(DataDirectory.getDataDir()) + File.separator + ProcessorFilterForClocksTool.getDbFileClockModuls(DataDirectory.convertMcuDesctiptorToMcuIdentification(mcuDescriptor));
    }

    public static String getMcuRelFile(IMcuDescriptor mcuDescriptor) {
        return ProcessorFilterForClocksTool.getDbFileClockModel(DataDirectory.convertMcuDesctiptorToMcuIdentification(mcuDescriptor));
    }

    public static String getClocksDataDir(IMcuDescriptor mcuDescriptor) {
        File f = new File(String.valueOf(DataDirectory.getDataDir()) + File.separator + DataDirectory.getMcuRelFile(mcuDescriptor));
        String parent = f.getParent();
        if (parent == null) {
            LOGGER.warning("File '" + f + "' does not have a parent.");
            parent = "";
        }
        return parent;
    }

    protected static IMcuIdentification convertMcuDesctiptorToMcuIdentification(IMcuDescriptor mcuDescriptor) {
        return new McuIdentification(mcuDescriptor.getID(), mcuDescriptor.getPartNumber(), mcuDescriptor.getSDKVersion(), "", "");
    }

    public static String getFontsDirectory() {
        return String.valueOf(Platform.isRunning() ? String.valueOf(PEConfiguration.getSystemDirectory()) + File.separator : "") + "resources" + File.separator + "fonts";
    }

    public static String getDataDir() {
        return DataDirectoryUtils.getDataDir();
    }
}

