/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.ui;

import com.nxp.swtools.clocks.platform.IPlatformSpecific;
import com.nxp.swtools.clocks.platform.PlatformSpecificFactory;
import com.nxp.swtools.clocks.platform.Rap;
import com.nxp.swtools.common.utils.NonNull;
import java.util.Random;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class BenchmarkWindow {
    @NonNull
    final IPlatformSpecific platformSpecific = PlatformSpecificFactory.getPlatformSpecific();
    @NonNull
    Point size = new Point(1, 1);

    public BenchmarkWindow(@NonNull Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        Canvas canvas = new Canvas(parent, 0x20040000);
        this.addPaintListener(canvas);
        this.addResizeListener(canvas);
        this.platformSpecific.setAutoRefresh(33);
        canvas.redraw();
    }

    private void addResizeListener(final @NonNull Canvas canvas) {
        canvas.addListener(11, new Listener(){

            public void handleEvent(Event arg0) {
                Point newSize = canvas.getSize();
                if (newSize != null) {
                    BenchmarkWindow.this.size = newSize;
                }
            }
        });
    }

    private void addPaintListener(final @NonNull Canvas canvas) {
        canvas.addPaintListener(new PaintListener(){
            Random random = new Random();
            long lastFpsDraw = -1L;
            String text = "FPS: 0";
            long redraws;
            int pps = 300;
            double lastPos = -1.0;
            long lastDraw;
            volatile boolean redrawing = false;

            public void paintControl(PaintEvent arg0) {
                if (this.redrawing) {
                    return;
                }
                this.redrawing = true;
                long drawStart = System.nanoTime();
                if (drawStart - this.lastFpsDraw >= 300000000L) {
                    if (this.lastFpsDraw >= 0L) {
                        this.text = "FPS: " + (double)this.redraws * (1.0E9 / (double)(drawStart - this.lastFpsDraw));
                    }
                    this.lastFpsDraw = drawStart;
                    this.redraws = 0L;
                }
                arg0.gc.fillRectangle(0, 0, BenchmarkWindow.this.size.x, BenchmarkWindow.this.size.y);
                int i = 0;
                while (i < 100) {
                    int w = this.random.nextInt(100);
                    int h = this.random.nextInt(100);
                    arg0.gc.drawRectangle(this.random.nextInt(BenchmarkWindow.this.size.x - w), this.random.nextInt(BenchmarkWindow.this.size.y - h), w, h);
                    ++i;
                }
                double currPos = 0.0;
                if (this.lastPos >= 0.0) {
                    currPos = this.lastPos + (double)this.pps * (1.0 / (1.0E9 / (double)(drawStart - this.lastDraw)));
                }
                int currPosInt = (int)(currPos %= (double)BenchmarkWindow.this.size.x);
                arg0.gc.setLineWidth(2);
                int antiAlias = arg0.gc.getAntialias();
                arg0.gc.setAntialias(1);
                arg0.gc.drawOval(currPosInt, BenchmarkWindow.this.size.y / 2 - 15, 30, 30);
                if (currPosInt + 30 >= BenchmarkWindow.this.size.x) {
                    arg0.gc.drawOval(currPosInt - BenchmarkWindow.this.size.x, BenchmarkWindow.this.size.y / 2 - 15, 30, 30);
                }
                arg0.gc.setAntialias(antiAlias);
                arg0.gc.setLineWidth(1);
                this.lastPos = currPos;
                this.lastDraw = drawStart;
                arg0.gc.drawText(this.text, 0, 0);
                ++this.redraws;
                this.redrawing = false;
                this.invalidateCanvas();
            }

            void invalidateCanvas() {
                if (Rap.isActive()) {
                    Thread t = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            if (redrawing) {
                                return;
                            }
                            canvas.getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (redrawing) {
                                        return;
                                    }
                                    canvas.redraw();
                                }
                            });
                        }
                    });
                    t.start();
                } else {
                    if (this.redrawing) {
                        return;
                    }
                    canvas.redraw();
                }
            }
        });
    }
}

