/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.ui.diagramsymbols;

import com.nxp.swtools.clocks.ui.diagram.DiagramStyleProvider;
import com.nxp.swtools.clocks.ui.diagram.Style;
import com.nxp.swtools.clocks.ui.diagramsymbols.GraphicalElement;
import com.nxp.swtools.common.utils.NonNull;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.PaintEvent;

public class Polygon
extends GraphicalElement {
    @NonNull
    @NonNull List<@NonNull Point2D> mCorners;

    public Polygon(@NonNull List<@NonNull Point2D> cornersDS) {
        this.mCorners = cornersDS;
        this.calculateBB();
    }

    @Override
    public void draw(AffineTransform transform, PaintEvent e, DiagramStyleProvider styleProvider) {
        @NonNull Point2D[] cornersCS = new Point2D[this.mCorners.size()];
        transform.transform(this.mCorners.toArray(new Point2D[this.mCorners.size()]), 0, cornersCS, 0, this.mCorners.size());
        int[] unrolledCornersCS = Polygon.unroll(cornersCS);
        Style style = styleProvider.getStyle(this, this.mDrawState);
        if (!style.Fill.isTransparent()) {
            style.Fill.set(e);
            e.gc.fillPolygon(unrolledCornersCS);
            style.Fill.unset(e);
        }
        style.LineStyle.set(e);
        int origLineCap = e.gc.getLineCap();
        e.gc.setLineCap(2);
        e.gc.drawPolygon(unrolledCornersCS);
        e.gc.setLineCap(origLineCap);
        style.LineStyle.unset(e);
    }

    @Override
    protected GraphicalElement makeCopy() {
        ArrayList<@NonNull Point2D> corners = new ArrayList<Point2D>();
        for (Point2D p : this.mCorners) {
            Point2D.Double tmp = new Point2D.Double(p.getX(), p.getY());
            corners.add(tmp);
        }
        return new Polygon(corners);
    }

    @Override
    public boolean isHitBy(Point2D p) {
        if (this.mBoundingBoxDS.isHitBy(p)) {
            double x = p.getX();
            double y = p.getY();
            boolean inside = false;
            int j = this.mCorners.size() - 1;
            int i = 0;
            while (i < this.mCorners.size()) {
                if (this.mCorners.get(i).getY() > y != this.mCorners.get(j).getY() > y && x < (this.mCorners.get(j).getX() - this.mCorners.get(i).getX()) * (y - this.mCorners.get(i).getY()) / (this.mCorners.get(j).getY() - this.mCorners.get(i).getY()) + this.mCorners.get(i).getX()) {
                    inside = !inside;
                }
                j = i++;
            }
            return inside;
        }
        return false;
    }

    @Override
    public void applyTransform(AffineTransform transformDS) {
        for (Point2D point : this.mCorners) {
            transformDS.transform(point, point);
        }
        this.calculateBB();
    }

    protected void calculateBB() {
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double maxX = Double.MIN_VALUE;
        double maxY = Double.MIN_VALUE;
        for (Point2D point : this.mCorners) {
            minX = Math.min(minX, point.getX());
            minY = Math.min(minY, point.getY());
            maxX = Math.max(maxX, point.getX());
            maxY = Math.max(maxY, point.getY());
        }
        this.mBoundingBoxDS.setTopLeftCorner(minX, minY);
        this.mBoundingBoxDS.setBottomRightCorner(maxX, maxY);
    }

    @Override
    public @NonNull List<@NonNull Point2D> getHullPoints() {
        return this.mCorners;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[" + this.mCorners.toString() + "]";
    }
}

