/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.verification;

import com.nxp.swtools.clocks.data.IMcu;
import com.nxp.swtools.clocks.data.elements.IElement;
import com.nxp.swtools.clocks.data.settings.BitFieldSetting;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.common.utils.NonNullByDefault;
import com.nxp.swtools.common.utils.logging.LogManager;
import java.util.HashSet;
import java.util.logging.Logger;

@NonNullByDefault
public class NameVerificator {
    public static final int RECOMENDED_LENGTH = 50;
    public static final int MAX_ALLOWED_LENGTH = 60;
    private static final Logger LOGGER = LogManager.getLogger(NameVerificator.class);
    private static final String ERROR_MESSAGE = "Name \"%s\" of %s has more than %d characters";

    private NameVerificator() {
    }

    public static void verifyMcuNames(IMcu mcu) {
        HashSet<IElement> elements = new HashSet<IElement>();
        elements.addAll(mcu.getAllElements().values());
        elements.addAll(mcu.getAllGlobalConfigElements());
        elements.addAll(mcu.getAllPins().values());
        LOGGER.info("\"----------- Name validation started ----------\"");
        for (IElement element : elements) {
            NameVerificator.verifyName(element.getName(), element.getID());
        }
        for (ISetting setting : mcu.getSettings().getAllSettings()) {
            if (setting instanceof BitFieldSetting) continue;
            NameVerificator.verifyName(setting.getName(), setting.getId());
        }
        LOGGER.info("\"----------- Name validation finished ----------\"");
    }

    private static void verifyName(String name, String id) {
        int length = name.trim().length();
        if (length > 50) {
            if (length < 60) {
                LOGGER.warning(String.format(ERROR_MESSAGE, name, id, 50));
            } else {
                LOGGER.severe(String.format(ERROR_MESSAGE, name, id, 60));
            }
        }
    }
}

