/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.sdkmanifest.descriptors;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.sdkmanifest.consts.SdkConsts;
import com.nxp.swtools.sdkmanifest.descriptors.CompilerDefineSymbol;
import com.nxp.swtools.sdkmanifest.descriptors.CoreBootRole;
import com.nxp.swtools.sdkmanifest.descriptors.SdkDeviceDescriptor;
import com.nxp.swtools.sdkmanifest.descriptors.SdkDevicesDescriptor;
import com.nxp.swtools.sdkmanifest.descriptors.SdkIncludePath;
import com.nxp.swtools.sdkmanifest.descriptors.SdkSourceFile;
import com.nxp.swtools.sdkmanifest.descriptors.SdkTagContentVersion;
import com.nxp.swtools.sdkmanifest.descriptors.SdkToolchainsSettingsDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SdkComponentDescriptor {
    @NonNull
    private final String id;
    @NonNull
    private final String name;
    @NonNull
    private final String fullName;
    @NonNull
    private final String brief;
    @NonNull
    private final String type;
    @Nullable
    private final Collection<@NonNull String> devices;
    @NonNull
    private final @NonNull Collection<@NonNull SdkSourceFile> sources;
    @Nullable
    private SdkToolchainsSettingsDescriptor toolchainsSettings;
    @NonNull
    private final SdkTagContentVersion version;
    @NonNull
    private final @NonNull Set<@NonNull String> dependencySet;
    @NonNull
    @NonNull Collection<@NonNull CompilerDefineSymbol> defines;
    @NonNull
    final @NonNull List<@NonNull SdkIncludePath> includePaths;
    @Nullable
    final Set<@NonNull CoreBootRole> reqCoreBootRoles;
    @Nullable
    final String category;
    @Nullable
    final Set<@NonNull String> toolchains;
    @Nullable
    final Set<@NonNull String> compilers;
    @Nullable
    final Set<@NonNull String> deviceCores;
    @Nullable
    SdkDevicesDescriptor devicesDescr;

    public SdkComponentDescriptor(@NonNull String id, @NonNull String name, @NonNull String fullName, @NonNull String brief, @NonNull String type, @Nullable String category, @Nullable Collection<@NonNull String> devices, @NonNull Collection<@NonNull SdkSourceFile> sources, @Nullable SdkToolchainsSettingsDescriptor toolsSettings, @NonNull SdkTagContentVersion version, @NonNull Set<@NonNull String> dependencySet, @NonNull Collection<@NonNull CompilerDefineSymbol> defines, @Nullable List<@NonNull SdkIncludePath> includePaths, @Nullable Set<@NonNull CoreBootRole> coreBootRoles, @Nullable Set<@NonNull String> toolchains, @Nullable Set<@NonNull String> compilers, @Nullable Set<@NonNull String> deviceCores) {
        if (devices != null) assert (!devices.isEmpty());
        this.id = id;
        this.name = name;
        this.fullName = fullName;
        this.brief = brief;
        this.type = type;
        this.category = category;
        this.devices = devices != null ? CollectionsUtils.unmodifiableCollection(devices) : null;
        this.sources = CollectionsUtils.unmodifiableCollection(new ArrayList<SdkSourceFile>(sources));
        this.toolchainsSettings = toolsSettings;
        this.version = version;
        this.dependencySet = CollectionsUtils.unmodifiableSet(dependencySet);
        this.defines = defines;
        this.includePaths = includePaths == null ? Collections.emptyList() : CollectionsUtils.unmodifiableList(includePaths);
        this.reqCoreBootRoles = coreBootRoles;
        this.toolchains = toolchains;
        this.compilers = compilers;
        this.deviceCores = deviceCores;
    }

    public @Nullable Collection<@NonNull String> getDevices() {
        return this.devices;
    }

    public @NonNull Set<@NonNull String> getDependencySet() {
        return this.dependencySet;
    }

    public @NonNull Collection<@NonNull CompilerDefineSymbol> getDefines() {
        return this.defines;
    }

    public @NonNull List<@NonNull SdkIncludePath> getIncludePaths() {
        return this.includePaths;
    }

    @Nullable Set<@NonNull CoreBootRole> getReqCoreBootRoles() {
        return this.reqCoreBootRoles;
    }

    public final @Nullable Set<@NonNull String> getToolchains() {
        return this.toolchains;
    }

    public final @Nullable Set<@NonNull String> getCompilers() {
        return this.compilers;
    }

    public final @Nullable Set<@NonNull String> getDeviceCores() {
        return this.deviceCores;
    }

    public @NonNull Collection<@NonNull SdkSourceFile> getSources(@NonNull SdkDeviceDescriptor device) {
        Collection<String> curDevices = this.devices;
        if (curDevices == null || curDevices.contains(device.getRef())) {
            return this.sources;
        }
        return new ArrayList<SdkSourceFile>();
    }

    public @NonNull Collection<String> getAllSourcePaths() {
        ArrayList<String> result = new ArrayList<String>();
        for (SdkSourceFile source : this.sources) {
            result.add(source.getPath());
        }
        return result;
    }

    public @NonNull Collection<String> getAllSourceFileMasks() {
        ArrayList<String> result = new ArrayList<String>();
        for (SdkSourceFile source : this.sources) {
            result.add(source.getFileMask());
        }
        return result;
    }

    public @NonNull Collection<String> getAllSourceTypes() {
        ArrayList<String> result = new ArrayList<String>();
        for (SdkSourceFile source : this.sources) {
            result.add(source.getType());
        }
        return result;
    }

    public @NonNull Collection<String> getAllSourceVariants() {
        ArrayList<String> result = new ArrayList<String>();
        boolean shouldBeEmpty = true;
        for (SdkSourceFile source : this.sources) {
            String variant = source.getVariant();
            if (!UtilsText.isEmpty((String)variant)) {
                shouldBeEmpty = false;
            }
            result.add(variant);
        }
        if (shouldBeEmpty) {
            return new ArrayList<String>();
        }
        return result;
    }

    public @NonNull Collection<String> getAllSourceCompilers() {
        ArrayList<String> result = new ArrayList<String>();
        boolean shouldBeEmpty = true;
        for (SdkSourceFile source : this.sources) {
            String compiler = source.getCompilerId();
            if (!UtilsText.isEmpty((String)compiler)) {
                shouldBeEmpty = false;
            }
            result.add(compiler);
        }
        if (shouldBeEmpty) {
            return new ArrayList<String>();
        }
        return result;
    }

    public @Nullable SdkToolchainsSettingsDescriptor getSdkToolchainsSettingsDescriptor() {
        return this.toolchainsSettings;
    }

    public @Nullable SdkToolchainsSettingsDescriptor.SdkToolchainSettingDescriptor getSdkToolchainSettingsDescriptor(String toolchainName) {
        if (this.toolchainsSettings != null) {
            return this.toolchainsSettings.getSdkToolchainSettingsDescrByName(toolchainName);
        }
        return null;
    }

    public @NonNull Collection<@NonNull SdkSourceFile> getSources() {
        return this.sources;
    }

    public @NonNull String getId() {
        return this.id;
    }

    void setDevicesDescriptor(@NonNull SdkDevicesDescriptor devicesDescr) {
        this.devicesDescr = devicesDescr;
    }

    public @NonNull String getProcessorIndependentId() {
        Collection<@NonNull String> deviceIDs = this.getDevices();
        if (deviceIDs != null) {
            int lastDot;
            SdkDevicesDescriptor curDevicesDescr = this.devicesDescr;
            assert (curDevicesDescr != null);
            HashSet<String> deviceNames = new HashSet<String>();
            for (String devId : deviceIDs) {
                SdkDeviceDescriptor device = curDevicesDescr.getSdkDeviceDescriptorById(devId);
                if (device == null) continue;
                deviceNames.add(device.getName());
            }
            if (!deviceNames.isEmpty() && (lastDot = this.id.lastIndexOf(46)) > 0) {
                String idSuffix = this.id.substring(lastDot + 1);
                if (!deviceNames.contains(idSuffix)) {
                    String[] stringArray = idSuffix.split("-");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String devId = stringArray[n2];
                        if (!deviceNames.contains(devId)) {
                            assert (false);
                            return this.id;
                        }
                        ++n2;
                    }
                }
                return this.id.substring(0, this.id.length() - 1 - idSuffix.length());
            }
        }
        return this.id;
    }

    public @NonNull String getName() {
        return this.name;
    }

    public @NonNull String getFullName() {
        return this.fullName;
    }

    public @NonNull String getNameForUI() {
        if (this.fullName.isEmpty() || this.getType().equals(SdkConsts.SDK_DRIVER_COMPNT_TYPE) || this.getType().equals(SdkConsts.SDK_UTILITIES_COMPNT_TYPE)) {
            return this.getName();
        }
        return this.fullName;
    }

    public @NonNull String getBrief() {
        return this.brief;
    }

    public @NonNull String getType() {
        return this.type;
    }

    public @Nullable String getCategory() {
        return this.category;
    }

    public String toString() {
        StringBuilder result = new StringBuilder(this.name);
        result.append(':');
        result.append(this.type);
        if (this.devices != null) {
            result.append(" for devices ");
            result.append(CollectionsUtils.formatList(this.devices, (String)", ", null));
        }
        return UtilsText.safeToString((Object)result);
    }

    public @NonNull SdkTagContentVersion getVersion() {
        return this.version;
    }
}

