/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.sdkmanifest.descriptors;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import java.io.File;
import java.util.logging.Logger;

class SdkSourceBase {
    @NonNull
    protected static final Logger LOGGER = LogManager.getLogger(SdkSourceBase.class);
    @NonNull
    private final String path;
    @NonNull
    private final String fileMask;

    public SdkSourceBase(@NonNull String path, @NonNull String fileMask) {
        this.path = path;
        this.fileMask = fileMask;
    }

    public @NonNull String getPath() {
        return this.path;
    }

    public @NonNull String getOSSpecificPath() {
        return UtilsText.safeString((String)this.path.replace(File.separatorChar == '/' ? (char)'\\' : '/', File.separatorChar));
    }

    public @NonNull String getEclipsePath() {
        return UtilsFile.toEclipsePath((String)this.path);
    }

    public @NonNull String getFileMask() {
        return this.fileMask;
    }

    public String toString() {
        return String.valueOf(this.getEclipsePath()) + UtilsText.ECLIPSE_PATH_SEPARATOR + this.fileMask;
    }

    public static enum SourceType {
        PATH,
        MASK;

    }
}

