/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.sdkmanifest.descriptors;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.sdkmanifest.consts.SdkConsts;
import java.util.List;
import java.util.Objects;

public class SdkToolchain
implements Comparable<SdkToolchain> {
    @NonNull
    final String id;
    @NonNull
    final @NonNull List<@NonNull String> compilersIds;
    @NonNull
    final String fullName;
    @NonNull
    final String vendor;
    @NonNull
    final String vendor_url;

    public @NonNull String getId() {
        return this.id;
    }

    public @NonNull List<@NonNull String> getCompilersIds() {
        return this.compilersIds;
    }

    public @NonNull String getFullName() {
        return this.fullName;
    }

    SdkToolchain(@NonNull String id, @NonNull List<@NonNull String> compilersIds, @NonNull String fullName, @NonNull String vendor, @NonNull String vendor_url) {
        this.id = id;
        this.compilersIds = compilersIds;
        this.fullName = fullName;
        this.vendor = vendor;
        this.vendor_url = vendor_url;
    }

    public String toString() {
        return String.valueOf(this.id) + '/' + this.compilersIds;
    }

    @Override
    public int compareTo(SdkToolchain tool2) {
        int tool2Pos;
        if (tool2 == null) {
            return 1;
        }
        int myPos = SdkConsts.TOOLCHAIN_IDS_ORDERED.indexOf(this.getId());
        if (myPos == -1) {
            myPos = Integer.MAX_VALUE;
        }
        if ((tool2Pos = SdkConsts.TOOLCHAIN_IDS_ORDERED.indexOf(tool2.getId())) == -1) {
            tool2Pos = Integer.MAX_VALUE;
        }
        return Integer.compare(myPos, tool2Pos);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SdkToolchain)) {
            return false;
        }
        SdkToolchain objTool = (SdkToolchain)obj;
        return this.id.equals(objTool.id) && this.compilersIds.equals(objTool.compilersIds) && this.fullName.equals(objTool.fullName) && this.vendor.equals(objTool.vendor);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.compilersIds, this.fullName, this.vendor);
    }
}

