/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.sdkmanifest.loader;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.provider.sdk.ISdkFileProvider;
import com.nxp.swtools.provider.sdk.SdkFileProvider;
import com.nxp.swtools.sdkmanifest.Messages;
import com.nxp.swtools.sdkmanifest.descriptors.SdkBoardsDescriptor;
import com.nxp.swtools.sdkmanifest.descriptors.SdkComponentsDescriptor;
import com.nxp.swtools.sdkmanifest.descriptors.SdkDevicesDescriptor;
import com.nxp.swtools.sdkmanifest.descriptors.SdkManifestDescriptor;
import com.nxp.swtools.sdkmanifest.descriptors.SdkToolchainsSettingsDescriptor;
import com.nxp.swtools.sdkmanifest.loader.ManifestLoaderUtils;
import com.nxp.swtools.sdkmanifest.loader.MultipleManifestLoader;
import java.io.File;
import java.io.InputStream;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.Version;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ManifestLoader {
    @NonNull
    protected static final Logger LOGGER = LogManager.getLogger(ManifestLoader.class);

    static @Nullable String getSdk13RepositoryFromDeviceName(@NonNull String version, @NonNull String repositoryName, @NonNull String repositoryId, @NonNull Set<String> fullDeviceNames, boolean repoName) {
        if (version.startsWith("1.3.")) {
            String repo = "";
            String indentChar = "";
            if (repoName) {
                repo = repositoryName;
                indentChar = " ";
            } else {
                repo = repositoryId;
                indentChar = "_";
            }
            if (fullDeviceNames.size() < 64) {
                StringBuilder repoNameSuffix = new StringBuilder();
                for (String name : fullDeviceNames) {
                    repoNameSuffix.append(indentChar);
                    repoNameSuffix.append(name);
                }
                return String.valueOf(repo) + repoNameSuffix.toString();
            }
        }
        return null;
    }

    public static @NonNull SdkManifestDescriptor loadManifestDocument(@NonNull Document manifestDoc, @NonNull ISdkFileProvider sdkFileProvider, @NonNull String sdkSourceFilesAbsolutePath) {
        SdkManifestDescriptor.Builder manifestDescriptorBuilder = new SdkManifestDescriptor.Builder();
        String version = null;
        String sdkVersionNumber = null;
        Element root = manifestDoc.getDocumentElement();
        assert (root != null);
        if (root.hasAttribute("format_version")) {
            manifestDescriptorBuilder.setManifestFormatVersion(UtilsText.safeString((String)root.getAttribute("format_version")));
        } else {
            LOGGER.log(Level.SEVERE, "Attribute not found in manifest: format_version");
        }
        manifestDescriptorBuilder.setSdkConfigurationHash(UtilsText.safeString((String)root.getAttribute("configuration")));
        Element ksdkElement = ManifestLoaderUtils.getChildElementByName(root, "ksdk");
        if (ksdkElement != null && !(version = ksdkElement.getAttribute("version")).isEmpty()) {
            manifestDescriptorBuilder.setSdkBuildVersionValue(version);
            if (manifestDescriptorBuilder.isManifestFormateVersionLowerThat3()) {
                Element apiElement = ManifestLoaderUtils.getChildElementByName(root, "api");
                if (apiElement != null && apiElement.hasAttribute("version")) {
                    sdkVersionNumber = apiElement.getAttribute("version");
                    manifestDescriptorBuilder.setSdkVersionNumber(sdkVersionNumber);
                }
            } else {
                sdkVersionNumber = UtilsText.safeString((String)root.getAttribute("api_version"));
                if (!sdkVersionNumber.isEmpty()) {
                    manifestDescriptorBuilder.setSdkVersionNumber(sdkVersionNumber);
                }
            }
        }
        SdkDevicesDescriptor.Builder devicesDescriptorBuilder = new SdkDevicesDescriptor.Builder();
        SdkComponentsDescriptor.Builder componentsDescriptorBuilder = new SdkComponentsDescriptor.Builder();
        SdkBoardsDescriptor.Builder boardsDescriptorBuilder = new SdkBoardsDescriptor.Builder(manifestDescriptorBuilder.getManifestFormatVersion());
        SdkToolchainsSettingsDescriptor.Builder toolchainsDescriptorBuilder = new SdkToolchainsSettingsDescriptor.Builder();
        manifestDescriptorBuilder.loadElements(manifestDoc, sdkFileProvider, manifestDescriptorBuilder, devicesDescriptorBuilder, componentsDescriptorBuilder, boardsDescriptorBuilder, toolchainsDescriptorBuilder);
        SdkDevicesDescriptor sdkDevicesDescriptor = devicesDescriptorBuilder.build();
        manifestDescriptorBuilder.setSdkRootDirectory(sdkSourceFilesAbsolutePath);
        manifestDescriptorBuilder.setSdkBoardsDescriptor(boardsDescriptorBuilder.build());
        manifestDescriptorBuilder.setSdkToolchainsDescriptor(toolchainsDescriptorBuilder.build());
        manifestDescriptorBuilder.setSdkDevicesDescriptor(sdkDevicesDescriptor);
        manifestDescriptorBuilder.setSdkComponentsDescriptor(componentsDescriptorBuilder.build(sdkDevicesDescriptor));
        return manifestDescriptorBuilder.build();
    }

    public static @NonNull SdkManifestDescriptor manifestMergeAndLoad(@Nullable String sdkSourceFilesAbsolutePath, @NonNull String processor, @NonNull String boardIdNameFullName) {
        Document doc = MultipleManifestLoader.getMergedManifestDocument(sdkSourceFilesAbsolutePath, processor, boardIdNameFullName);
        if (doc == null) {
            return new SdkManifestDescriptor.Builder().build();
        }
        assert (sdkSourceFilesAbsolutePath != null);
        return ManifestLoader.loadManifestDocument(doc, (ISdkFileProvider)new SdkFileProvider(sdkSourceFilesAbsolutePath), sdkSourceFilesAbsolutePath);
    }

    static @NonNull Object checkManifestDocIfValid(@Nullable Document doc, boolean allForJUnitTest) {
        if (doc == null) {
            return "SDK manifest file is not valid XML file ";
        }
        Element rootElem = doc.getDocumentElement();
        if (!"manifest".equals(rootElem.getNodeName()) && !"ksdk:manifest".equals(rootElem.getNodeName())) {
            return "SDK manifest file has an unexpected root element.";
        }
        String formatVersionStr = rootElem.getAttribute("format_version");
        assert (formatVersionStr != null);
        if (formatVersionStr.isEmpty()) {
            return "SDK 1.x is not supported by this tool (or missing format_version attribute)";
        }
        if (formatVersionStr.startsWith("1.") && !allForJUnitTest) {
            return "SDK 1.x is not supported by this tool ";
        }
        double formatVersionDouble = MultipleManifestLoader.getManifestFormatVersion(doc);
        if (formatVersionDouble < MultipleManifestLoader.getMinFormatVersion()) {
            return UtilsText.format((String)Messages.get().LDR_SDK_MNFST_VERSION_NOT_SUPPORTED, (Object[])new Object[]{formatVersionStr});
        }
        if (!(formatVersionStr.startsWith("2.") || formatVersionStr.startsWith("3.") || formatVersionStr.startsWith("1."))) {
            if (!ManifestLoaderUtils.is3xManifestVersionSupported(formatVersionStr)) {
                return UtilsText.safeString((String)Messages.get().MNFST_UNSUPPORTED_FORMAT);
            }
            return UtilsText.format((String)Messages.get().LDR_SDK_MNFST_VERSION_NOT_SUPPORTED, (Object[])new Object[]{formatVersionStr});
        }
        Element ksdkElement = ManifestLoaderUtils.getChildElementByName(rootElem, "ksdk");
        if (ksdkElement == null) {
            return UtilsText.format((String)"Invalid SDK manifest, `{0}` tag not found.", (Object[])new Object[]{"ksdk"});
        }
        String version = ksdkElement.getAttribute("version");
        if (!version.startsWith("2.") && !formatVersionStr.startsWith("1.")) {
            return UtilsText.format((String)Messages.get().LDR_SDK_NOT_SUPPORTED, (Object[])new Object[]{UtilsText.safeString((String)version)});
        }
        if (formatVersionStr.startsWith("1.")) {
            return doc;
        }
        return doc;
    }

    static @NonNull Object loadManifestDocIfValid(@NonNull File file, boolean allForJUnitTest) {
        AtomicInteger verMajor = new AtomicInteger(0);
        AtomicInteger verMinor = new AtomicInteger(0);
        if (!(file.getName().endsWith("manifest.xml") || ManifestLoaderUtils.is3xManifestFileName(file.getName(), verMajor, verMinor) && ManifestLoaderUtils.is3xManifestVersionSupported(verMajor.get(), verMinor.get()))) {
            return UtilsText.safeString((String)Messages.get().MNFST_UNSUPPORTED_FORMAT);
        }
        if (!file.isFile() || !file.canRead()) {
            return "SDK manifest file not found or not accessible.";
        }
        if (file.length() > 10000000L) {
            return "SDK manifest file too big.";
        }
        return ManifestLoader.checkManifestDocIfValid(ManifestLoaderUtils.loadManifestDocument(file), allForJUnitTest);
    }

    public static Object loadManifestDocIfValid(@NonNull File file) {
        return ManifestLoader.loadManifestDocIfValid(file, false);
    }

    public static Object loadManifestDocIfValidForJUnitTest(@NonNull File file) {
        return ManifestLoader.loadManifestDocIfValid(file, true);
    }

    public static Object loadManifestDocIfValid(@NonNull InputStream iStrm) {
        return ManifestLoader.checkManifestDocIfValid(ManifestLoaderUtils.loadManifestDocument(iStrm), false);
    }

    public static @NonNull Version decodeManifestFormatVersion(@Nullable String manifestFormatVersionAttr) {
        Version version;
        try {
            version = Version.parseVersion((String)manifestFormatVersionAttr);
        }
        catch (IllegalArgumentException e) {
            int minor;
            LOGGER.log(Level.CONFIG, "Fallback to legacy parsing of the manifest formate version", e);
            int major = ManifestLoader.decodeManifestMajorFormatVersion(manifestFormatVersionAttr);
            version = major > 0 ? new Version(major, (minor = ManifestLoader.decodeManifestMinorFormatVersion(manifestFormatVersionAttr)) != -1 ? minor : 0, 0) : Version.emptyVersion;
        }
        return version;
    }

    public static int decodeManifestMajorFormatVersion(@Nullable String manifestFormatVersionAttr) {
        if (manifestFormatVersionAttr == null) {
            return 0;
        }
        int pos = manifestFormatVersionAttr.indexOf(46);
        if (pos <= 0) {
            return 0;
        }
        return Integer.valueOf(manifestFormatVersionAttr.substring(0, pos));
    }

    public static int decodeManifestMinorFormatVersion(@Nullable String manifestFormatVersionAttr) {
        if (manifestFormatVersionAttr == null) {
            return -1;
        }
        int pos = manifestFormatVersionAttr.indexOf(46);
        if (pos <= 0) {
            return -1;
        }
        return Integer.valueOf(manifestFormatVersionAttr.substring(pos + 1));
    }
}

