/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.ui;

import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class SWTUtils {
    public static ScrolledComposite createScrolledComposite(Composite parent) {
        ScrolledComposite sc = new ScrolledComposite(parent, 768);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        return sc;
    }

    public static Composite createGridCellComposite(Composite parent, int horizontalSpan, int columns) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().numColumns(columns).margins(0, -1).applyTo(composite);
        GridDataFactory.swtDefaults().span(horizontalSpan, 1).grab(true, false).align(4, 0x1000000).applyTo((Control)composite);
        return composite;
    }

    public static Composite createGridCellCompositeWithVerticalMargin(Composite parent, int horizontalSpan, int columns, int verticalMargin) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().numColumns(columns).margins(-1, verticalMargin).applyTo(composite);
        GridDataFactory.swtDefaults().span(horizontalSpan, 1).grab(true, false).align(4, 0x1000000).applyTo((Control)composite);
        return composite;
    }

    public static Composite createGridCellCompositeWithVerticalAndHorizontalMargin(Composite parent, int horizontalSpan, int columns, int verticalMargin, int horizontalMargin) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().numColumns(columns).margins(horizontalMargin, verticalMargin).applyTo(composite);
        GridDataFactory.swtDefaults().span(horizontalSpan, 1).grab(true, false).align(4, 0x1000000).applyTo((Control)composite);
        return composite;
    }

    public static Group createGroup(Composite parent, int columns, String groupName) {
        Group group = new Group(parent, 0);
        GridLayoutFactory.swtDefaults().numColumns(columns).applyTo((Composite)group);
        GridDataFactory.swtDefaults().grab(true, false).align(4, 4).applyTo((Control)group);
        group.setText(groupName);
        return group;
    }

    public static Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
        return label;
    }

    public static Label createLabelWithHorizontalSpan(Composite parent, String text, int horizontalSpan) {
        Label label = SWTUtils.createLabel(parent, text);
        GridDataFactory.swtDefaults().span(horizontalSpan, 1).align(4, 0x1000000).applyTo((Control)label);
        return label;
    }

    public static Label createLabelWithVerticalAlignment(Composite parent, String text, int verticalAlignment) {
        Label label = SWTUtils.createLabel(parent, text);
        GridDataFactory.swtDefaults().align(1, verticalAlignment).applyTo((Control)label);
        return label;
    }

    public static Label createLabelWithHorizontalIndent(Composite parent, String text, int horizontalIndent) {
        Label label = SWTUtils.createLabel(parent, text);
        GridDataFactory.swtDefaults().indent(horizontalIndent, 0).applyTo((Control)label);
        return label;
    }

    public static Label createFixedWidthLabel(Composite parent, String text, int widthHint) {
        Label label = SWTUtils.createLabel(parent, text);
        GridDataFactory.swtDefaults().hint(widthHint, -1).applyTo((Control)label);
        return label;
    }

    public static Button createButton(Composite parent, String text, int style) {
        Button button = new Button(parent, style);
        button.setText(text);
        return button;
    }

    public static Button createButtonWithHorizontalSpan(Composite parent, String text, int style, int horizontalSpan) {
        Button button = SWTUtils.createButton(parent, text, style);
        GridDataFactory.swtDefaults().span(horizontalSpan, 1).applyTo((Control)button);
        return button;
    }

    public static Combo createFixedWidthComboWithHorizontalSpan(Composite parent, int style, int widthHint, int horizontalSpan) {
        Combo combo = new Combo(parent, style);
        GridDataFactory.swtDefaults().hint(widthHint, -1).span(horizontalSpan, 1).applyTo((Control)combo);
        return combo;
    }

    public static Combo createComboWithHorizontalSpan(Composite parent, int style, int horizontalSpan) {
        Combo combo = new Combo(parent, style);
        GridDataFactory.swtDefaults().span(horizontalSpan, 1).applyTo((Control)combo);
        GridData gridData = new GridData(4, 4, true, false);
        combo.setLayoutData((Object)gridData);
        return combo;
    }

    public static Text createWideText(Composite parent, int style, boolean grabExcessHorizontalSpace, int horizontalSpan) {
        Text text = new Text(parent, style);
        GridDataFactory.swtDefaults().grab(grabExcessHorizontalSpace, false).align(4, 0x1000000).span(horizontalSpan, 1).applyTo((Control)text);
        return text;
    }

    public static Text createWideTextWithHorizontalIndent(Composite parent, int style, boolean grabExcessHorizontalSpace, int horizontalSpan, int horizontalIndent) {
        Text text = new Text(parent, style);
        GridDataFactory.swtDefaults().grab(grabExcessHorizontalSpace, false).align(4, 0x1000000).span(horizontalSpan, 1).indent(horizontalIndent, -1).applyTo((Control)text);
        return text;
    }

    public static Text createWideTextWithHeightHint(Composite parent, int style, boolean grabExcessHorizontalSpace, int horizontalSpan, int heightHint) {
        Text text = new Text(parent, style);
        GridDataFactory.swtDefaults().grab(grabExcessHorizontalSpace, false).align(4, 0x1000000).span(horizontalSpan, 1).hint(-1, heightHint).applyTo((Control)text);
        return text;
    }

    public static Text createTextWithHorizontalIndentAndWidthHint(Composite parent, int style, int horizontalIndent, int widthHint) {
        Text text = new Text(parent, style);
        GridDataFactory.swtDefaults().indent(horizontalIndent, 0).hint(widthHint, -1).applyTo((Control)text);
        return text;
    }

    public static Text createTextWithWidthHint(Composite parent, int style, int widthHint, int horizontalSpan) {
        Text text = new Text(parent, style);
        GridDataFactory.swtDefaults().hint(widthHint, -1).span(horizontalSpan, 1).applyTo((Control)text);
        return text;
    }

    public static ControlDecoration createControlDecoration(Label parent, String text, String imageName, int style) {
        ControlDecoration controlDecoration = new ControlDecoration((Control)parent, style);
        controlDecoration.setDescriptionText(text);
        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration(imageName);
        if (fieldDecoration != null) {
            controlDecoration.setImage(fieldDecoration.getImage());
        }
        return controlDecoration;
    }
}

