/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.controller;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.Expression;
import com.nxp.swtools.common.utils.expression.IFunction;
import com.nxp.swtools.common.utils.expression.IValue;
import com.nxp.swtools.common.utils.lang.CollectionMap;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.rational.BigRational;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.periphs.controller.APeriphController;
import com.nxp.swtools.periphs.controller.Controller;
import com.nxp.swtools.periphs.model.data.AvailableComponents;
import com.nxp.swtools.periphs.model.data.Components;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsIgnoredComponentMigrationOffer;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsProfile;
import com.nxp.swtools.provider.toolchainproject.ISdkComponentInProject;
import com.nxp.swtools.provider.toolchainproject.IToolchainProjectWithSdk;
import com.nxp.swtools.resourcetables.model.config.AStructuredSettingConfig;
import com.nxp.swtools.resourcetables.model.config.ArrayConfig;
import com.nxp.swtools.resourcetables.model.config.ChildContext;
import com.nxp.swtools.resourcetables.model.config.ChildProviderHelper;
import com.nxp.swtools.resourcetables.model.config.IChild;
import com.nxp.swtools.resourcetables.model.config.IChildProvidable;
import com.nxp.swtools.resourcetables.model.config.IComponentInstanceConfig;
import com.nxp.swtools.resourcetables.model.config.IFunctionalGroup;
import com.nxp.swtools.resourcetables.model.config.ISettingConfig;
import com.nxp.swtools.resourcetables.model.config.IStructuredSettingConfig;
import com.nxp.swtools.resourcetables.model.config.ScalarConfig;
import com.nxp.swtools.resourcetables.model.config.SetConfig;
import com.nxp.swtools.resourcetables.model.config.StructConfig;
import com.nxp.swtools.resourcetables.model.data.ConfigurationComponentTypeId;
import com.nxp.swtools.resourcetables.model.data.Migrate;
import com.nxp.swtools.resourcetables.model.data.Migration;
import com.nxp.swtools.resourcetables.model.data.MigrationComponent;
import com.nxp.swtools.resourcetables.model.data.Migrations;
import com.nxp.swtools.resourcetables.model.data.Mode;
import com.nxp.swtools.resourcetables.model.data.SWComponent;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.osgi.framework.Version;

public class MigrationHelper {
    private static final String MESSAGE_MIGRATION_OF_THIS_SETTING_WILL_NOT_CONTINUE = "Migration of this setting will not continue.";
    private static final String IMPLICIT_MIGRATION_FUNCTION_SIZE = "(toSetting, fromSetting) -> fromSetting.size()";
    public static final String IMPLICIT_CONVERSION_FUNCTION = "(toSetting, fromSetting) -> fromSetting.getValue()";
    public static final String IMPLICIT_SCALAR_CONVERSION_FUNCTION = "(toSetting, fromSetting) -> fromSetting.getUserEnteredValue()";
    private static final String DOLLAR_THIS = "$this";
    private static final CollectionsUtils.Pair<String, String> IMPLICIT_CONVERSION_PAIR = new CollectionsUtils.Pair((Object)"$this", (Object)"(toSetting, fromSetting) -> fromSetting.getValue()");
    public static final Pattern TEMPLATE_MATCH_REGEX = Pattern.compile("\\[(\\$?[a-zA-Z_][a-zA-Z0-9_]*)\\]");
    private static final Logger LOGGER = LogManager.getLogger(MigrationHelper.class);

    public static @Nullable IComponentInstanceConfig tryToCreateNewInstance(ConfigurationComponentTypeId typeId, IComponentInstanceConfig oldInstance, APeriphController controller, Object caller) {
        IFunctionalGroup functionalGroup = oldInstance.getChildContext().getFunctionalGroup();
        if (functionalGroup != null) {
            IComponentInstanceConfig newInstance;
            boolean migrationToNewerVersion;
            String instanceComponentId = oldInstance.getComponent().getId();
            String typeIdComponentId = typeId.getConfigurationComponent().getId();
            List automaticMigrations = typeId.getConfigurationComponent().getAutomaticMigrations();
            boolean bl = migrationToNewerVersion = instanceComponentId.equals(typeIdComponentId) || automaticMigrations.contains(oldInstance.getComponentTypeId());
            if (migrationToNewerVersion) {
                controller.getProfile().makeComponentTemporary(instanceComponentId);
            }
            if ((newInstance = controller.createComponentInstance(typeId.getTypeId(), oldInstance.getPeripheral(), functionalGroup.getName(), caller)) == null) {
                return null;
            }
            functionalGroup.moveInstance(newInstance.getName(), oldInstance.getName());
            if (migrationToNewerVersion && controller instanceof Controller) {
                Controller peripheralsController = (Controller)controller;
                String oldInstanceName = oldInstance.getUiName();
                peripheralsController.removeComponentInstances(functionalGroup, Arrays.asList(oldInstanceName), false, caller);
                peripheralsController.removeComponents(Arrays.asList("&&temp&&"), caller);
                newInstance.setUUID(oldInstance.getUUID());
                peripheralsController.setInstanceToCustomNameMode(newInstance, oldInstance.isCustomNameEnabled(), caller);
                peripheralsController.setComment(newInstance, oldInstance.getComment(), caller);
                if (oldInstance.isCustomNameEnabled()) {
                    peripheralsController.renameComponentInstance(newInstance, oldInstanceName, caller, true);
                }
            }
            return newInstance;
        }
        return null;
    }

    public static @Nullable IComponentInstanceConfig migrate(IComponentInstanceConfig instance, ConfigurationComponentTypeId newTypeId, APeriphController controller, Object caller) {
        IComponentInstanceConfig newInstance = MigrationHelper.tryToCreateNewInstance(newTypeId, instance, controller, caller);
        if (newInstance == null) {
            LOGGER.log(Level.SEVERE, () -> MessageFormat.format("[TOOL] [{0}] Automatic migration failed on creating instance of new component", instance.getComponentTypeId()));
            return null;
        }
        MigrationHelper.migrateMode(newInstance, instance, controller, caller);
        MigrationHelper.migrateSettingsValues(newInstance, instance, controller, caller);
        return newInstance;
    }

    public static List<CollectionsUtils.Pair<IComponentInstanceConfig, ConfigurationComponentTypeId>> getComponentsToBeMigratedAutomatically(List<IComponentInstanceConfig> instances, AvailableComponents components) {
        ArrayList<CollectionsUtils.Pair<IComponentInstanceConfig, ConfigurationComponentTypeId>> result = new ArrayList<CollectionsUtils.Pair<IComponentInstanceConfig, ConfigurationComponentTypeId>>();
        for (ConfigurationComponentTypeId typeId : components.getConfigCompTypeIds()) {
            if (!typeId.getConfigurationComponent().hasAutomaticMigration()) continue;
            List componentsList = typeId.getConfigurationComponent().getAutomaticMigrations();
            for (IComponentInstanceConfig instance : instances) {
                String instanceTypeId = instance.getComponentTypeId();
                if (!componentsList.contains(instanceTypeId)) continue;
                result.add((CollectionsUtils.Pair<IComponentInstanceConfig, ConfigurationComponentTypeId>)new CollectionsUtils.Pair((Object)instance, (Object)typeId));
            }
        }
        return result;
    }

    public static boolean shouldComponentBeMigratedAutomatically(ConfigurationComponentTypeId typeId) {
        return typeId.getConfigurationComponent().hasAutomaticMigration();
    }

    public static void migrateSettingsValues(IComponentInstanceConfig toInstance, IComponentInstanceConfig fromInstance, APeriphController controller, Object caller) {
        List<ISettingConfig> finalListOfSettings = MigrationHelper.getSettings(toInstance);
        for (ISettingConfig settingConfig : finalListOfSettings) {
            List migrations = (List)settingConfig.getModelData().getMigrations().stream().filter(migration -> MigrationHelper.isMigrationAvailable(toInstance, migration)).collect(CollectorsUtils.toList());
            if (migrations.isEmpty()) {
                MigrationHelper.migrateSettingImplicitly(fromInstance, toInstance, controller, caller, (IChild)settingConfig);
            }
            for (Migration migration2 : migrations) {
                String fromSettingExpressionString = migration2.getFromSetting();
                Expression fromSettingExpression = Expression.tryCreate((String)fromSettingExpressionString);
                if (fromSettingExpression == null) {
                    LOGGER.log(Level.SEVERE, "[DATA] Expression cannot be created from: {0}", fromSettingExpressionString);
                    continue;
                }
                Object value = null;
                try {
                    value = fromSettingExpression.resolve(fromInstance.getExpressionContext()).getValue();
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "[DATA] Problem occurred with to_setting expression: {0}", e.getLocalizedMessage());
                }
                if (!(value instanceof IChild)) {
                    LOGGER.log(Level.SEVERE, "[DATA] Value of expression is not a setting: {0}", value);
                    continue;
                }
                String fromSetting = ((IChild)value).getId();
                for (Migrate migrate : migration2.getMigrates()) {
                    String applyToTemplate = migrate.getToSetting();
                    String conversionFunctionTemplate = migrate.getConversionFunction();
                    CollectionMap<String, String> replacementsForTemplates = MigrationHelper.getReplacementsForTemplates(Arrays.asList(applyToTemplate, conversionFunctionTemplate), settingConfig);
                    List<CollectionsUtils.Pair<String, String>> settingsToCopy = MigrationHelper.replaceTemplateByValue(applyToTemplate, conversionFunctionTemplate, replacementsForTemplates);
                    for (CollectionsUtils.Pair<String, String> replacement : settingsToCopy) {
                        if (UtilsText.safeString((String)((String)replacement.getFirst())).contains("[")) continue;
                        MigrationHelper.migrateOneSetting(replacement, fromSetting, fromInstance, toInstance, (IChild)settingConfig, controller, caller);
                    }
                }
            }
        }
        controller.handleSettingChange(2, caller, "Migration of settings values", true, true);
    }

    public static void migrateMode(IComponentInstanceConfig toInstance, IComponentInstanceConfig fromInstance, APeriphController controller, Object caller) {
        Mode currentMode = fromInstance.getMode();
        String modeName = currentMode.getUIName(fromInstance.getExpressionContext());
        boolean modeWithSameNameIsInNewComponent = toInstance.getComponent().getScenarios().stream().map(x -> x.getUIName(toInstance.getExpressionContext())).anyMatch(x -> x.equals(modeName));
        if (modeWithSameNameIsInNewComponent) {
            controller.changeMode(toInstance.getType(), toInstance.getUiName(), modeName, caller);
        } else {
            Migrations newComponentMigrations = toInstance.getComponent().getMigrations();
            if (newComponentMigrations == null) {
                return;
            }
            for (Mode newMode : toInstance.getComponent().getScenarios()) {
                String fromMode;
                MigrationComponent componentMigration;
                Migration migration = newMode.getMigration();
                if (migration == null || (componentMigration = (MigrationComponent)CollectionsUtils.nullableOptionalGet(newComponentMigrations.getMigrationComponents().stream().filter(migrationDefinition -> migrationDefinition.getId().equals(migration.getFrom())).findAny())) == null || !fromInstance.getComponent().getId().equals(componentMigration.getComponentType()) || (fromMode = migration.getFromMode()) == null || !fromMode.equals(currentMode.getId())) continue;
                controller.changeMode(toInstance.getType(), toInstance.getUiName(), newMode.getUIName(toInstance.getExpressionContext()), caller);
            }
        }
    }

    public static void migrateSettingImplicitly(IComponentInstanceConfig fromInstance, IComponentInstanceConfig toInstance, APeriphController controller, Object caller, IChild settingConfig) {
        ScalarConfig scalarConfig;
        if (settingConfig instanceof ScalarConfig && ((scalarConfig = (ScalarConfig)settingConfig).getType() == ScalarConfig.Type.INFO || scalarConfig.getType() == ScalarConfig.Type.VARIABLE)) {
            return;
        }
        String settingIdFrom = settingConfig.getId();
        IChild settingInOldComponent = ChildProviderHelper.getChildRelative((IChildProvidable)fromInstance, (String)settingIdFrom);
        if (settingInOldComponent != null) {
            if (!settingConfig.getClass().equals(settingInOldComponent.getClass())) {
                LOGGER.log(Level.SEVERE, "[DATA] Cannot implicitly migrate settings if they have different types and same ID!");
                return;
            }
            if (settingConfig instanceof ArrayConfig) {
                MigrationHelper.migrateOneSetting((CollectionsUtils.Pair<String, String>)new CollectionsUtils.Pair((Object)DOLLAR_THIS, (Object)IMPLICIT_MIGRATION_FUNCTION_SIZE), settingIdFrom, fromInstance, toInstance, settingConfig, controller, caller);
            } else if (settingConfig instanceof SetConfig) {
                SetConfig setConfig = (SetConfig)settingConfig;
                for (SetConfig.SetPresence setPresence : setConfig.getChildren()) {
                    MigrationHelper.migrateSettingImplicitly(fromInstance, toInstance, controller, caller, (IChild)setPresence);
                }
            } else if (settingConfig instanceof ScalarConfig) {
                MigrationHelper.migrateOneSetting((CollectionsUtils.Pair<String, String>)new CollectionsUtils.Pair((Object)DOLLAR_THIS, (Object)IMPLICIT_SCALAR_CONVERSION_FUNCTION), settingIdFrom, fromInstance, toInstance, settingConfig, controller, caller);
            } else if (!(settingConfig instanceof StructConfig)) {
                MigrationHelper.migrateOneSetting(IMPLICIT_CONVERSION_PAIR, settingIdFrom, fromInstance, toInstance, settingConfig, controller, caller);
            }
            if (settingConfig instanceof AStructuredSettingConfig) {
                AStructuredSettingConfig structConfig = (AStructuredSettingConfig)settingConfig;
                for (ISettingConfig settingInNewStructure : structConfig.getChildren()) {
                    MigrationHelper.migrateSettingImplicitly(fromInstance, toInstance, controller, caller, (IChild)settingInNewStructure);
                }
            }
        }
    }

    public static boolean isMigrationAvailable(IComponentInstanceConfig target, Migration migration) {
        boolean supported = false;
        Migrations migrations = target.getComponent().getMigrations();
        if (migrations == null) {
            return false;
        }
        List migrationComponents = migrations.getMigrationComponents();
        for (MigrationComponent migrationComponent : migrationComponents) {
            if (!migrationComponent.getId().equals(migration.getFrom())) continue;
            supported = true;
        }
        return supported;
    }

    public static void migrateOneSetting(CollectionsUtils.Pair<String, String> pair, String fromSettingId, IComponentInstanceConfig fromInstance, IComponentInstanceConfig toInstance, IChild setting, APeriphController controller, Object caller) {
        ScalarConfig scalarConfig;
        String expressionString = UtilsText.safeString((String)((String)pair.getFirst()));
        Expression settingExpression = Expression.tryCreate((String)expressionString);
        if (settingExpression == null) {
            LOGGER.log(Level.SEVERE, "[DATA] Expression cannot be created from: {0}", expressionString);
            return;
        }
        Object value = null;
        try {
            value = settingExpression.resolve(setting.getExpressionContext()).getValue();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "[DATA] Problem occurred with to_setting expression: {0}", e);
            return;
        }
        if (!(value instanceof IChild)) {
            LOGGER.log(Level.SEVERE, "[DATA] Value of expression is not a setting: {0}", value);
            return;
        }
        String settingId = ((IChild)value).getId();
        String conversionFunction = UtilsText.safeString((String)((String)pair.getSecond()));
        IChild fromSetting = ChildProviderHelper.getChild((ChildContext)fromInstance.getChildContext(), (String)fromSettingId);
        if (fromSetting == null) {
            LOGGER.log(Level.SEVERE, "[DATA] Cannot find node with id: {0}!", fromSettingId);
            return;
        }
        Expression expression = Expression.tryCreate((String)conversionFunction);
        if (expression == null) {
            LOGGER.log(Level.SEVERE, "[DATA] Expression cannot be parsed! Expression text: {0}", conversionFunction);
            return;
        }
        IValue resolvedExpression = expression.resolve(fromSetting.getExpressionContext());
        if (resolvedExpression.getType() != IValue.Type.FUNCTION) {
            LOGGER.log(Level.SEVERE, "[DATA] Conversion function is not lambda function!");
            return;
        }
        IFunction functionReference = resolvedExpression.getFunctionReference();
        IChild targetSetting = ChildProviderHelper.getChild((ChildContext)toInstance.getChildContext(), (String)settingId);
        if (targetSetting == null) {
            LOGGER.log(Level.SEVERE, "[DATA] Target with id: {0} does not exist!", settingId);
            return;
        }
        if (targetSetting instanceof ScalarConfig && ((scalarConfig = (ScalarConfig)targetSetting).getType() == ScalarConfig.Type.INFO || scalarConfig.getType() == ScalarConfig.Type.VARIABLE)) {
            LOGGER.log(Level.SEVERE, "[DATA] Target with id: {0} is info or variable which are not settable!", settingId);
            return;
        }
        IValue result = functionReference.invokeOn(fromSetting.getExpressionContext(), new Object[]{targetSetting, fromSetting});
        MigrationHelper.setValue(targetSetting, result.getValue(), controller, caller);
    }

    public static void setValue(IChild setting, Object value, APeriphController controller, Object caller) {
        if (setting instanceof ScalarConfig) {
            MigrationHelper.setValueScalar(setting, value, controller, caller);
        }
        if (setting instanceof ArrayConfig) {
            MigrationHelper.setValueArray(setting, value, controller, caller);
        }
        if (setting instanceof StructConfig) {
            MigrationHelper.setValueStruct(setting, value, controller, caller);
        }
        if (setting instanceof SetConfig) {
            MigrationHelper.setValueSetConfig(setting, value, controller, caller);
        }
        if (setting instanceof SetConfig.SetPresence) {
            MigrationHelper.setValueSetPresence(setting, value, controller, caller);
        }
    }

    private static void setValueSetConfig(IChild setting, Object value, APeriphController controller, Object caller) {
        SetConfig otherSetConfig = null;
        if (value instanceof SetConfig) {
            otherSetConfig = (SetConfig)value;
        }
        if (otherSetConfig == null) {
            LOGGER.log(Level.SEVERE, "[DATA] Trying to set set config with value which is not another set config. Migration of this setting will not continue.");
            return;
        }
        SetConfig thisSetConfig = (SetConfig)setting;
        ArrayList thisSetConfigChildren = new ArrayList(thisSetConfig.getChildren());
        for (SetConfig.SetPresence thisSetConfigChild : thisSetConfigChildren) {
            IChild otherSetConfigChild = ChildProviderHelper.getChild((ChildContext)otherSetConfig.getChildContext(), (String)thisSetConfigChild.getName());
            if (otherSetConfigChild == null) continue;
            MigrationHelper.setValue((IChild)thisSetConfigChild, otherSetConfigChild, controller, caller);
        }
    }

    private static void setValueStruct(IChild setting, Object value, APeriphController controller, Object caller) {
        StructConfig otherStruct = null;
        if (value instanceof StructConfig) {
            otherStruct = (StructConfig)value;
        }
        if (otherStruct == null) {
            LOGGER.log(Level.SEVERE, "[DATA] Trying to set structure with value which is not another structure. Migration of this setting will not continue.");
            return;
        }
        StructConfig thisStruct = (StructConfig)setting;
        ArrayList thisStructChildren = new ArrayList(thisStruct.getChildren());
        for (ISettingConfig thisStructChild : thisStructChildren) {
            IChild otherStructChild = ChildProviderHelper.getChild((ChildContext)otherStruct.getChildContext(), (String)thisStructChild.getName());
            if (otherStructChild == null) continue;
            MigrationHelper.setValue((IChild)thisStructChild, otherStructChild, controller, caller);
        }
    }

    private static void setValueArray(IChild setting, Object value, APeriphController controller, Object caller) {
        ArrayConfig thisArray = (ArrayConfig)setting;
        String realValue = null;
        if (value instanceof ArrayConfig) {
            ArrayConfig otherArray = (ArrayConfig)value;
            List otherArrayChildren = otherArray.getChildren();
            for (ISettingConfig otherChild : otherArrayChildren) {
                controller.addItem(thisArray, false, caller);
                int lastIndex = thisArray.getChildren().size() - 1;
                IChild lastChild = thisArray.getChildById(String.valueOf(lastIndex));
                if (lastChild == null) {
                    LOGGER.log(Level.SEVERE, "[TOOL] Could not get last item in array when migrating from another array");
                    return;
                }
                MigrationHelper.setValue(lastChild, otherChild, controller, caller);
            }
            return;
        }
        if (value instanceof String) {
            realValue = (String)value;
        }
        if (value instanceof Long) {
            realValue = ((Long)value).toString();
        }
        if (value instanceof BigInteger) {
            realValue = ((BigInteger)value).toString();
        }
        if (realValue == null) {
            LOGGER.log(Level.SEVERE, "[DATA] Trying to set array size with value which is not another array, integer or string. {0}", MESSAGE_MIGRATION_OF_THIS_SETTING_WILL_NOT_CONTINUE);
            return;
        }
        int newSize = Integer.parseInt(realValue);
        int diff = Math.abs(newSize - thisArray.getChildren().size());
        int i = 0;
        while (i < diff) {
            if (newSize > thisArray.getChildren().size()) {
                controller.addItem(thisArray, false, caller);
            } else {
                ISettingConfig lastChild = (ISettingConfig)thisArray.getChildren().get(thisArray.getChildren().size() - 1);
                controller.removeItem(thisArray, lastChild, false, caller);
            }
            ++i;
        }
    }

    private static void setValueSetPresence(IChild setting, Object value, APeriphController controller, Object caller) {
        String realValue = null;
        if (value instanceof SetConfig.SetPresence) {
            realValue = ((SetConfig.SetPresence)value).getValueName();
        }
        if (value instanceof String) {
            realValue = (String)value;
        }
        if (value instanceof Boolean) {
            realValue = ((Boolean)value).toString();
        }
        if (realValue == null) {
            LOGGER.log(Level.SEVERE, "[DATA] Trying to set set setting with value which is not another set setting, boolean or string. Migration of this setting will not continue.");
            return;
        }
        controller.setSetPresence((SetConfig.SetPresence)setting, Boolean.parseBoolean(realValue), false, caller);
    }

    private static void setValueScalar(IChild setting, Object value, APeriphController controller, Object caller) {
        ScalarConfig scalarConfig = (ScalarConfig)setting;
        if (scalarConfig.getType() == ScalarConfig.Type.INFO || scalarConfig.getType() == ScalarConfig.Type.VARIABLE) {
            return;
        }
        String realValue = null;
        if (value instanceof ScalarConfig) {
            realValue = ((ScalarConfig)value).getStringValue();
        }
        if (value instanceof String) {
            realValue = (String)value;
        }
        if (value instanceof BigInteger) {
            realValue = ((BigInteger)value).toString();
        }
        if (value instanceof Long) {
            realValue = ((Long)value).toString();
        }
        if (value instanceof Boolean) {
            realValue = ((Boolean)value).toString();
        }
        if (value instanceof BigRational) {
            realValue = ((BigRational)value).toString();
        }
        if (realValue == null) {
            LOGGER.log(Level.SEVERE, "[DATA] Trying to set scalar setting with value which is not another scalar setting or valid value. {0}", MESSAGE_MIGRATION_OF_THIS_SETTING_WILL_NOT_CONTINUE);
            return;
        }
        controller.setValue(scalarConfig, realValue, false, caller);
    }

    public static List<ISettingConfig> getSettings(IComponentInstanceConfig instance) {
        ArrayList<ISettingConfig> finalListOfSettings = new ArrayList<ISettingConfig>();
        ArrayList childrenOfConfigSets = new ArrayList();
        instance.getChildren().forEach(cs -> {
            boolean bl = childrenOfConfigSets.addAll(cs.getChildren());
        });
        Iterator iterator = childrenOfConfigSets.iterator();
        ISettingConfig node = iterator.hasNext() ? (ISettingConfig)iterator.next() : null;
        while (node != null) {
            finalListOfSettings.add(node);
            if (node instanceof AStructuredSettingConfig) {
                AStructuredSettingConfig structuredSettingConfig = (AStructuredSettingConfig)node;
                List childrenOfStructuredSetting = ChildProviderHelper.getAllSettings((IStructuredSettingConfig)structuredSettingConfig);
                finalListOfSettings.addAll(childrenOfStructuredSetting);
            }
            ISettingConfig iSettingConfig = node = iterator.hasNext() ? (ISettingConfig)iterator.next() : null;
        }
        return finalListOfSettings;
    }

    public static List<CollectionsUtils.Pair<String, String>> replaceTemplateByValue(String applyTo, String conversionFunction, CollectionMap<String, String> templatesMapping) {
        LinkedList<String> applyToReplacements = new LinkedList<String>();
        LinkedList<String> conversionFunctionReplacements = new LinkedList<String>();
        applyToReplacements.add(applyTo);
        conversionFunctionReplacements.add(conversionFunction);
        Matcher matcher = TEMPLATE_MATCH_REGEX.matcher(applyTo);
        while (matcher.find()) {
            MatchResult matchResult = matcher.toMatchResult();
            String templateId = UtilsText.safeString((String)matchResult.group(1));
            Collection replacements = templatesMapping.get((Object)templateId);
            if (replacements == null) continue;
            String teplateIdWithMarkers = "[" + templateId + "]";
            LinkedList previousApplyToReplacements = new LinkedList(applyToReplacements);
            LinkedList previousConversionFunctionReplacements = new LinkedList(conversionFunctionReplacements);
            applyToReplacements.clear();
            conversionFunctionReplacements.clear();
            for (String replacement : replacements) {
                for (String previousResultItem : previousApplyToReplacements) {
                    applyToReplacements.add(previousResultItem.replace(teplateIdWithMarkers, replacement));
                }
                for (String previousResultItem : previousConversionFunctionReplacements) {
                    conversionFunctionReplacements.add(previousResultItem.replace(teplateIdWithMarkers, replacement));
                }
            }
        }
        LinkedList<CollectionsUtils.Pair<String, String>> result = new LinkedList<CollectionsUtils.Pair<String, String>>();
        int index = 0;
        while (index < applyToReplacements.size()) {
            result.add((CollectionsUtils.Pair<String, String>)new CollectionsUtils.Pair((Object)((String)applyToReplacements.get(index)), (Object)((String)conversionFunctionReplacements.get(index))));
            ++index;
        }
        return result;
    }

    public static CollectionMap<String, String> getReplacementsForTemplates(List<String> stringsWithTemplates, ISettingConfig config) {
        CollectionMap result = new CollectionMap(HashMap.class, HashSet.class);
        for (String stringWithTemplates : stringsWithTemplates) {
            Matcher matcher = TEMPLATE_MATCH_REGEX.matcher(stringWithTemplates);
            while (matcher.find()) {
                MatchResult matchResult = matcher.toMatchResult();
                String id = UtilsText.safeString((String)matchResult.group(1));
                if (config instanceof AStructuredSettingConfig) {
                    IChild foundSetting = ChildProviderHelper.getSuccessor((IStructuredSettingConfig)((AStructuredSettingConfig)config), (String)id);
                    if (foundSetting instanceof AStructuredSettingConfig) {
                        List children = ((AStructuredSettingConfig)foundSetting).getChildren();
                        if (!children.isEmpty()) {
                            children.forEach(x -> {
                                boolean bl = result.add((Object)id, (Object)x.getName());
                            });
                        } else {
                            LOGGER.log(Level.INFO, "[DATA] Array {0} is empty and will be ignored", id);
                        }
                    } else {
                        String message = "[DATA] Migration macro [{0}] in setting {1} cannot be replaced by real values because the setting cannot be found";
                        LOGGER.log(Level.SEVERE, () -> MessageFormat.format(message, id, config.getId()));
                    }
                }
                if (!(config instanceof SetConfig)) continue;
                if (id.equals(DOLLAR_THIS)) {
                    List children = ((SetConfig)config).getChildren();
                    if (!children.isEmpty()) {
                        children.forEach(x -> {
                            boolean bl = result.add((Object)id, (Object)x.getName());
                        });
                        continue;
                    }
                    LOGGER.log(Level.INFO, "[DATA] Set {0} is empty and will be ignored", id);
                    continue;
                }
                LOGGER.severe("[DATA] Set cannot provide any other child than set items");
            }
        }
        return result;
    }

    public static List<ConfigurationComponentTypeId> getComponentsThatReplacesThis(String typeId, APeriphController controller) {
        return controller.getMcu().getAvailableComponents().getReplacementsForTypeId(typeId);
    }

    public static boolean migrateFromCmd(Controller controller) {
        IToolchainProjectWithSdk toolchainProject = SharedConfigurationFactory.getSharedConfigurationSingleton().getToolchainProject();
        if (toolchainProject == null || !toolchainProject.wasProjectDetected()) {
            return false;
        }
        Map<ConfigurationComponentTypeId, List<ConfigurationComponentTypeId>> listOfComponentUpgrades = MigrationHelper.getListOfComponentUpgrades(controller, false);
        Optional transactionResult = controller.runTransaction(() -> {
            boolean result = false;
            for (Map.Entry entry : listOfComponentUpgrades.entrySet()) {
                ConfigurationComponentTypeId currentComponentTypeId = (ConfigurationComponentTypeId)entry.getKey();
                List replacements = (List)entry.getValue();
                if (replacements.isEmpty()) continue;
                ConfigurationComponentTypeId newTypeId = (ConfigurationComponentTypeId)replacements.get(0);
                List instances = controller.getProfile().getAllInstances(currentComponentTypeId.getType());
                for (IComponentInstanceConfig instance : instances) {
                    IComponentInstanceConfig migratedInstance = MigrationHelper.migrate(instance, newTypeId, controller, MigrationHelper.class);
                    if (migratedInstance == null) continue;
                    result = true;
                }
            }
            return result;
        });
        if (transactionResult.isPresent()) {
            return (Boolean)transactionResult.get();
        }
        return false;
    }

    public static Map<ConfigurationComponentTypeId, List<ConfigurationComponentTypeId>> getListOfComponentUpgrades(APeriphController controller, boolean returnRejected) {
        Set<String> ignoredComponents = MigrationHelper.getIgnoredComponents(controller);
        Collection components = controller.getProfile().getActiveComponents().getConfigCompTypeIds();
        Stream<Object> componentsStream = controller.getComponents().stream();
        if (!returnRejected) {
            componentsStream = componentsStream.filter(x -> !ignoredComponents.contains(x.getType()));
        }
        List availableComponents = (List)componentsStream.collect(CollectorsUtils.toList());
        IToolchainProjectWithSdk toolchainProject = SharedConfigurationFactory.getSharedConfigurationSingleton().getToolchainProject();
        if (toolchainProject == null || !toolchainProject.wasProjectDetected()) {
            return MigrationHelper.getUpgradesWithoutToolchainProject(components, availableComponents);
        }
        return MigrationHelper.getUpgradesWithToolchainProject(components, availableComponents, toolchainProject);
    }

    private static Map<ConfigurationComponentTypeId, List<ConfigurationComponentTypeId>> getUpgradesWithToolchainProject(Collection<ConfigurationComponentTypeId> components, List<ConfigurationComponentTypeId> availableComponents, IToolchainProjectWithSdk toolchainProject) {
        HashMap<ConfigurationComponentTypeId, List<ConfigurationComponentTypeId>> map = new HashMap<ConfigurationComponentTypeId, List<ConfigurationComponentTypeId>>();
        for (ConfigurationComponentTypeId component : components) {
            ConfigurationComponentTypeId betterMatchingComponent;
            Version sdkComponentVersion;
            SWComponent swComponent;
            ISdkComponentInProject sdkComponent;
            List componentReferences = component.getComponentReferences();
            if (componentReferences.isEmpty() || (sdkComponent = toolchainProject.getSdkComponent((swComponent = (SWComponent)componentReferences.get(0)).getName())) == null || (sdkComponentVersion = sdkComponent.getVersion()) == null || (betterMatchingComponent = (ConfigurationComponentTypeId)CollectionsUtils.nullableOptionalGet(availableComponents.stream().filter(comp -> !comp.getConfigurationComponent().getComponents().isEmpty()).filter(comp -> ((SWComponent)comp.getConfigurationComponent().getComponents().get(0)).getName().equals(sdkComponent.getID())).filter(comp -> Components.computeMatchScore((Version)((SWComponent)comp.getConfigurationComponent().getComponents().get(0)).getVersion(), (Version)sdkComponentVersion, (String)((SWComponent)comp.getConfigurationComponent().getComponents().get(0)).getMatchString(), (Version)((SWComponent)comp.getConfigurationComponent().getComponents().get(0)).getUntilVersion()) != null).sorted((c1, c2) -> {
                Version c1Version = ((SWComponent)c1.getConfigurationComponent().getComponents().get(0)).getVersion();
                if (c1Version == null) {
                    return 1;
                }
                Version c2Version = ((SWComponent)c2.getConfigurationComponent().getComponents().get(0)).getVersion();
                if (c2Version == null) {
                    return -1;
                }
                return c2Version.compareTo(c1Version);
            }).findFirst())) == null || betterMatchingComponent.equals((Object)component)) continue;
            map.put(component, Arrays.asList(betterMatchingComponent));
        }
        return map;
    }

    private static Map<ConfigurationComponentTypeId, List<ConfigurationComponentTypeId>> getUpgradesWithoutToolchainProject(Collection<ConfigurationComponentTypeId> components, List<ConfigurationComponentTypeId> availableComponents) {
        HashMap<ConfigurationComponentTypeId, List<ConfigurationComponentTypeId>> map = new HashMap<ConfigurationComponentTypeId, List<ConfigurationComponentTypeId>>();
        for (ConfigurationComponentTypeId component : components) {
            List replacementsList = (List)availableComponents.stream().filter(x -> x.getConfigurationComponent().getId().equals(component.getType())).sorted(new Comparator<ConfigurationComponentTypeId>(){

                @Override
                public int compare(ConfigurationComponentTypeId o1, ConfigurationComponentTypeId o2) {
                    Version version1 = ((SWComponent)o1.getConfigurationComponent().getComponents().get(0)).getVersion();
                    Version version2 = ((SWComponent)o2.getConfigurationComponent().getComponents().get(0)).getVersion();
                    if (version1 == null) {
                        return 1;
                    }
                    if (version2 == null) {
                        return -1;
                    }
                    return version2.compareTo(version1);
                }
            }).collect(CollectorsUtils.toList());
            replacementsList.remove(component);
            if (replacementsList.isEmpty()) continue;
            map.put(component, replacementsList);
        }
        return map;
    }

    public static Set<String> getIgnoredComponents(APeriphController controller) {
        StoragePeriphsIgnoredComponentMigrationOffer ignoredMigrationComponents = controller.getProfile().getStoragePeripheralsTool().getPeriphsProfile().getIgnoredMigrationComponents();
        if (ignoredMigrationComponents == null) {
            return Collections.emptySet();
        }
        return ignoredMigrationComponents.getIgnoredMigrationComponents();
    }

    public static void addIgnoredComponents(APeriphController controller, Collection<String> newIgnoredComponents) {
        StoragePeriphsProfile periphsProfile = controller.getProfile().getStoragePeripheralsTool().getPeriphsProfile();
        StoragePeriphsIgnoredComponentMigrationOffer ignoredMigrationComponents = periphsProfile.getIgnoredMigrationComponents();
        if (ignoredMigrationComponents == null) {
            periphsProfile.createIgnoredMigrationComponents();
            ignoredMigrationComponents = periphsProfile.getIgnoredMigrationComponents();
            if (ignoredMigrationComponents == null) {
                LOGGER.log(Level.SEVERE, "[TOOL] Failed to create new list of ignored migrations");
                return;
            }
        }
        HashSet<@NonNull String> ignoredComponents = new HashSet<String>();
        ignoredComponents.addAll(newIgnoredComponents);
        ignoredMigrationComponents.setIgnoredMigrationComponents(ignoredComponents);
    }
}

