/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.controller.dependencies;

import com.nxp.swtools.periphs.controller.Controller;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.dependencies.DependencyQueryAnnotation;
import com.nxp.swtools.provider.configuration.dependencies.DependencyQueryResult;
import com.nxp.swtools.provider.configuration.dependencies.DependencyResourceAnotation;
import com.nxp.swtools.provider.configuration.dependencies.IDependencyQuery;
import com.nxp.swtools.provider.configuration.dependencies.IDependencyQueryResult;
import com.nxp.swtools.provider.configuration.storage.IDependenciesConfiguration;
import com.nxp.swtools.provider.configuration.storage.INamedTool;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsFuncGroup;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsTool;
import com.nxp.swtools.resourcetables.model.config.DependencyResponseConfig;
import com.nxp.swtools.resourcetables.model.config.IComponentInstanceConfig;
import com.nxp.swtools.resourcetables.model.config.IFunctionalGroup;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@DependencyQueryAnnotation(resources={@DependencyResourceAnotation(resourceType="Peripheral", features={"initialized"}), @DependencyResourceAnotation(resourceType="PeripheralSetting", features={"value"})})
public class PeripheralsToolQuery
implements IDependencyQuery {
    public Collection<IDependencyQueryResult> query(ISharedConfiguration configuration, String resourceType, String resourceId, String featureName) {
        ArrayList<IDependencyQueryResult> result = new ArrayList<IDependencyQueryResult>();
        StoragePeriphsTool periphsTool = configuration.getTools().getPeripherals();
        if (periphsTool == null || Controller.getInstance().getToolError() != null) {
            return result;
        }
        if (!periphsTool.isEnabled()) {
            return result;
        }
        if ("Peripheral".equalsIgnoreCase(resourceType) && "initialized".equalsIgnoreCase(featureName)) {
            result.addAll(PeripheralsToolQuery.getPeripheralQueryResult(periphsTool, resourceId));
        }
        if ("PeripheralSetting".equalsIgnoreCase(resourceType) && "value".equalsIgnoreCase(featureName)) {
            result.addAll(PeripheralsToolQuery.getPeripheralSettingValueQueryResult(periphsTool, resourceId));
        }
        return result;
    }

    private static Collection<IDependencyQueryResult> getPeripheralQueryResult(StoragePeriphsTool periphsTool, String resourceId) {
        return PeripheralsToolQuery.queryAllConfigs((config, storageConfig) -> {
            Boolean val = Boolean.FALSE;
            for (IComponentInstanceConfig inst : config.getInstances().values()) {
                if (!inst.isEnabled() || !inst.isPeripheralUsed(resourceId)) continue;
                val = Boolean.TRUE;
                break;
            }
            if (!val.booleanValue() && Controller.getInstance().getComponentsOfPeripheral(resourceId).isEmpty()) {
                val = null;
            }
            return Stream.of(new DependencyQueryResult((Object)val, (INamedTool)periphsTool, (IDependenciesConfiguration)storageConfig));
        });
    }

    private static Collection<IDependencyQueryResult> getPeripheralSettingValueQueryResult(StoragePeriphsTool periphsTool, String resourceId) {
        ArrayList<IDependencyQueryResult> result = new ArrayList<IDependencyQueryResult>();
        for (IFunctionalGroup group : Controller.getInstance().getProfile().getFunctionalGroups()) {
            List<DependencyResponseConfig> responses = Controller.getInstance().getDependencyResponses(group.getName());
            List<IDependencyQueryResult> groupResult = null;
            StoragePeriphsFuncGroup storageConfig = group.getStorageFuncGroup();
            for (DependencyResponseConfig response : responses) {
                HashSet value;
                String responseId = response.getResourceId();
                if (!resourceId.equals(responseId) || !response.getWhen()) continue;
                Serializable newValue = value = response.getValue();
                if (value instanceof List) {
                    newValue = new HashSet((List)((Object)value));
                } else if (value instanceof Long) {
                    newValue = ((Long)((Object)value)).intValue();
                }
                groupResult = Arrays.asList(new DependencyQueryResult(newValue, (INamedTool)periphsTool, (IDependenciesConfiguration)storageConfig));
            }
            if (groupResult == null) {
                groupResult = Arrays.asList(new DependencyQueryResult(null, (INamedTool)periphsTool, (IDependenciesConfiguration)storageConfig));
            }
            result.addAll(groupResult);
        }
        return result;
    }

    private static List<IDependencyQueryResult> queryAllConfigs(BiFunction<IFunctionalGroup, StoragePeriphsFuncGroup, Stream<IDependencyQueryResult>> usingQuery) {
        ArrayList<IDependencyQueryResult> result = new ArrayList<IDependencyQueryResult>();
        Controller.getInstance().getProfile().getFunctionalGroups().forEach(config -> {
            StoragePeriphsFuncGroup storageConfig = config.getStorageFuncGroup();
            result.addAll(((Stream)usingQuery.apply((IFunctionalGroup)config, storageConfig)).collect(Collectors.toList()));
        });
        return result;
    }
}

