/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.controller.scripting;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.periphs.controller.InitializationPrioritiesHelper;
import com.nxp.swtools.periphs.model.config.PeriphsProfile;
import com.nxp.swtools.periphs.model.data.InitializationPriorities;
import com.nxp.swtools.resourcetables.model.config.IChild;
import com.nxp.swtools.resourcetables.model.config.IComponentInstanceConfig;
import com.nxp.swtools.resourcetables.model.config.IFunctionalGroup;
import com.nxp.swtools.resourcetables.model.config.ISettingConfig;
import com.nxp.swtools.utils.scripting.api.IScriptFunctionalGroup;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class PeripheralsScriptFunctionalGroup
implements IScriptFunctionalGroup {
    private static final Logger LOGGER = LogManager.getLogger(PeripheralsScriptFunctionalGroup.class);
    private final IFunctionalGroup functionalGroup;

    public PeripheralsScriptFunctionalGroup(IFunctionalGroup functionalGroup) {
        this.functionalGroup = functionalGroup;
    }

    public String getName() {
        return this.functionalGroup.getName();
    }

    private List<IComponentInstanceConfig> getComponentInstancesList() {
        LinkedList<IComponentInstanceConfig> result = new LinkedList<IComponentInstanceConfig>();
        InitializationPriorities initializationPriorities = ((PeriphsProfile)this.functionalGroup.getChildContext().getRoot()).getMcu().getInitializationPriorities();
        Collection<Object> componentInstanceConfigs = initializationPriorities != null ? InitializationPrioritiesHelper.sortInstancesByPriorityGroups(this.functionalGroup.getInstances().values(), initializationPriorities) : this.functionalGroup.getInstances().values();
        for (IComponentInstanceConfig componentInstanceConfig : componentInstanceConfigs) {
            if (!componentInstanceConfig.isEnabled()) continue;
            result.add(componentInstanceConfig);
        }
        return result;
    }

    public IComponentInstanceConfig[] getComponentInstances() {
        List<IComponentInstanceConfig> componentInstanceConfigs = this.getComponentInstancesList();
        return componentInstanceConfigs.toArray(new IComponentInstanceConfig[componentInstanceConfigs.size()]);
    }

    public IComponentInstanceConfig[] getComponentInstances(String type) {
        List<IComponentInstanceConfig> componentInstanceConfigs = this.getComponentInstancesList();
        componentInstanceConfigs.removeIf(x -> !x.getComponent().getId().equals(type));
        return componentInstanceConfigs.toArray(new IComponentInstanceConfig[componentInstanceConfigs.size()]);
    }

    public String[] getComponentInstancesNames() {
        List<IComponentInstanceConfig> componentInstanceConfigs = this.getComponentInstancesList();
        List<String> names = componentInstanceConfigs.stream().map(IChild::getName).collect(Collectors.toList());
        return names.toArray(new String[names.size()]);
    }

    public String[] getComponentInstancesNames(String type) {
        List<IComponentInstanceConfig> componentInstanceConfigs = this.getComponentInstancesList();
        List<String> names = componentInstanceConfigs.stream().filter(y -> y.getComponent().getId().equals(type)).map(IChild::getName).collect(Collectors.toList());
        return names.toArray(new String[names.size()]);
    }

    public @Nullable IComponentInstanceConfig getComponentInstanceConfig(String type, String instanceName) {
        IComponentInstanceConfig componentInstance = this.functionalGroup.getComponentInstance(type, instanceName);
        if (componentInstance != null) {
            return componentInstance.isEnabled() ? componentInstance : null;
        }
        return null;
    }

    public @Nullable ISettingConfig getSetting(IComponentInstanceConfig componentInstanceConfig, String setting) {
        IChild child = componentInstanceConfig.getChildById(setting);
        if (child instanceof ISettingConfig) {
            return (ISettingConfig)child;
        }
        return null;
    }

    public @Nullable ISettingConfig getSetting(IComponentInstanceConfig componentInstanceConfig, String configSet, String setting) {
        return this.getSetting(componentInstanceConfig, String.valueOf(configSet) + "." + setting);
    }

    public @Nullable ISettingConfig getSetting(String type, String instanceName, String setting) {
        IComponentInstanceConfig componentInstanceConfig = this.functionalGroup.getComponentInstance(type, instanceName);
        if (componentInstanceConfig != null) {
            ISettingConfig settingConfig = this.getSetting(componentInstanceConfig, setting);
            return settingConfig;
        }
        return null;
    }

    public @Nullable ISettingConfig getSetting(String type, String instanceName, String configSet, String setting) {
        return this.getSetting(type, instanceName, String.valueOf(configSet) + "." + setting);
    }

    public boolean isSettingAvailable(IComponentInstanceConfig componentInstanceConfig, String setting) {
        ISettingConfig settingConfig = this.getSetting(componentInstanceConfig, setting);
        if (settingConfig != null) {
            return settingConfig.isAvailable();
        }
        LOGGER.warning("[DATA] Setting with name: " + setting + " is not a valid setting.");
        return false;
    }

    public boolean isSettingAvailable(IComponentInstanceConfig componentInstanceConfig, String configSet, String setting) {
        return this.isSettingAvailable(componentInstanceConfig, String.valueOf(configSet) + "." + setting);
    }

    public boolean isSettingAvailable(String type, String instanceName, String configSet, String setting) {
        return this.isSettingAvailable(type, instanceName, String.valueOf(configSet) + "." + setting);
    }

    public boolean isSettingAvailable(String type, String instanceName, String setting) {
        IComponentInstanceConfig componentInstanceConfig = this.functionalGroup.getComponentInstance(type, instanceName);
        if (componentInstanceConfig != null) {
            return this.isSettingAvailable(componentInstanceConfig, setting);
        }
        return false;
    }

    public boolean isSettingEnabled(String type, String instanceName, String setting) {
        ISettingConfig child = this.getSetting(type, instanceName, setting);
        if (child != null) {
            return child.isEnabled();
        }
        return false;
    }

    public boolean isCalledFromDefaultInit() {
        return this.functionalGroup.isCalledFromDefaultInit();
    }

    public String getCore() {
        return this.functionalGroup.getCore();
    }

    public String getIdPrefix() {
        return this.functionalGroup.getIdPrefix();
    }

    public boolean isPeripheralAvailable(String peripheralName) {
        return this.functionalGroup.getMcu().isPeripheralAvailableForCore(this.functionalGroup.getCore(), peripheralName);
    }

    public String getDescription() {
        return this.functionalGroup.getDescription();
    }

    public IFunctionalGroup getInternalFunctionalGroup() {
        return this.functionalGroup;
    }
}

