/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.sdk.core.utils.register;

import com.nxp.s32ds.cle.ide.internal.sdk.core.IdeSdkCoreActivator;
import com.nxp.s32ds.cle.ide.sdk.core.utils.register.SdkResourcesRegistrationHelper;
import com.nxp.s32ds.cle.runtime.sdk.internal.registry.core.resource.ResourceSdkDescriptorImplementation;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.resource.ResourceSdkCore;
import com.nxp.s32ds.cle.runtime.sdk.registry.resource.ResourceSdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.resource.ResourceSdkKind;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Element;

class SdkFolderResourceRegistrationHelper {
    private SdkFolderResourceRegistrationHelper() {
    }

    static void createFolderResources(Element folderElement, String sdkId, String toolChainId, List<ResourceSdkDescriptor> resourceDescriptors) {
        if (!ResourceSdkKind.of((String)folderElement.getNodeName()).isAction()) {
            ResourceSdkDescriptorImplementation resourceDescriptor = new ResourceSdkDescriptorImplementation(folderElement, sdkId, toolChainId);
            resourceDescriptors.add((ResourceSdkDescriptor)resourceDescriptor);
            SdkFolderResourceRegistrationHelper.createFileResources(folderElement, (ResourceSdkDescriptor)resourceDescriptor, resourceDescriptors);
        }
    }

    private static ResourceSdkDescriptor createFileResource(Path filePath, Element folderElement, ResourceSdkDescriptor folderResource) {
        String childFileElementName = SdkFolderResourceRegistrationHelper.getFileResourceElementName(folderResource.getKind());
        Element childFileElement = folderElement.getOwnerDocument().createElement(childFileElementName);
        SdkResourcesRegistrationHelper.getAttributes(filePath, folderResource).entrySet().forEach(e -> childFileElement.setAttribute((String)e.getKey(), (String)e.getValue()));
        return new ResourceSdkDescriptorImplementation(childFileElement, folderResource.getSdkId(), folderResource.getToolChainId());
    }

    private static String getFileResourceElementName(ResourceSdkKind kind) {
        if (!kind.isFolderKind()) {
            return ResourceSdkKind.UNRECOGNIZED_RESOURCE.getXmlElementName();
        }
        switch (kind.getBaseKind()) {
            case HEADER_FOLDER: {
                return ResourceSdkKind.HEADER_FILE.getXmlElementName();
            }
            case RESOURCE_FOLDER: {
                return ResourceSdkKind.RESOURCE_FILE.getXmlElementName();
            }
            case SOURCE_FOLDER: {
                return ResourceSdkKind.SOURCE_FILE.getXmlElementName();
            }
        }
        return ResourceSdkKind.UNRECOGNIZED_RESOURCE.getXmlElementName();
    }

    private static PathMatcher getFilesPathMatcher(ResourceSdkKind kind) {
        if (!kind.isFolderKind()) {
            return path -> false;
        }
        switch (kind.getBaseKind()) {
            case HEADER_FOLDER: {
                return ResourceSdkCore.headerFilesMatcher;
            }
            case RESOURCE_FOLDER: {
                return ResourceSdkCore.resourceFilesMatcher;
            }
            case SOURCE_FOLDER: {
                return ResourceSdkCore.sourceFilesMatcher;
            }
        }
        return path -> false;
    }

    private static boolean isFileValid(Path path, ResourceSdkDescriptor folderResource, List<ResourceSdkDescriptor> descriptors) {
        return descriptors.stream().noneMatch(resource -> Paths.get(resource.getPath(), new String[0]).equals(path)) && SdkFolderResourceRegistrationHelper.getFilesPathMatcher(folderResource.getKind()).matches(path.getFileName());
    }

    private static List<Path> getChildPaths(Path fromPath, boolean isDirectory) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Stream<Path> fileListStream = Files.list(fromPath);){
                return fileListStream.filter(path -> isDirectory == path.toFile().isDirectory()).collect(Collectors.toList());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ioe) {
            IdeSdkCoreActivator.getInstance().logError(NLS.bind((String)"Unable to handle path {0} due to error", (Object)fromPath), ioe);
            return Collections.emptyList();
        }
    }

    private static void createFileResources(Element folderElement, ResourceSdkDescriptor resourceAction, List<ResourceSdkDescriptor> resourceDescriptors) {
        Path fromPath = Paths.get(resourceAction.getPath(), new String[0]);
        if (!SdkResourcesRegistrationHelper.validateResourcePath(fromPath, resourceAction.getSdkId(), false).isOK()) {
            return;
        }
        SdkFolderResourceRegistrationHelper.getChildPaths(fromPath, false).stream().filter(path -> SdkFolderResourceRegistrationHelper.isFileValid(path, resourceAction, resourceDescriptors)).forEach(path -> {
            boolean bl = resourceDescriptors.add(SdkFolderResourceRegistrationHelper.createFileResource(path, folderElement, resourceAction));
        });
    }
}

