/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration;

import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.provider.configuration.ConfigChangeReason;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.impl.SharedConfiguration;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.simpleframework.xml.convert.AnnotationStrategy;
import org.simpleframework.xml.core.Persister;
import org.simpleframework.xml.strategy.Strategy;
import org.simpleframework.xml.stream.Format;

public class SharedConfigurationFactory {
    @NonNull
    private static final Logger LOGGER = LogManager.getLogger(SharedConfigurationFactory.class);
    @NonNull
    public static final String MEX_EXT_WITHOUT_DOT = "mex";
    @NonNull
    public static final String MEX_EXT = ".mex";
    @NonNull
    public static final @NonNull String @NonNull [] SUPPORTED_SUFFIX_VERSIONS = new String[]{".1.1", ""};

    public static @NonNull ISharedConfiguration createSharedConfiguration() {
        return new SharedConfiguration();
    }

    public static @NonNull ISharedConfiguration getSharedConfigurationSingleton() {
        ISharedConfiguration sharedConfig;
        try {
            sharedConfig = (ISharedConfiguration)SWTFactoryProxy.INSTANCE.getSingletonInstance(SharedConfiguration.class);
        }
        catch (IllegalAccessException | InstantiationException e) {
            sharedConfig = SharedConfigurationFactory.createSharedConfiguration();
            LOGGER.log(Level.SEVERE, "getSharedConfigurationSingleton", e);
        }
        assert (sharedConfig != null);
        return sharedConfig;
    }

    public static @NonNull ISharedConfiguration loadSharedConfigurationFromXml(@NonNull InputStream xmlStream) throws Exception {
        ISharedConfiguration configuration = SharedConfigurationFactory.createSharedConfiguration();
        AnnotationStrategy strategy = new AnnotationStrategy();
        Persister serializer = new Persister((Strategy)strategy);
        serializer.read((Object)configuration, xmlStream);
        return configuration;
    }

    public static void loadSharedConfigurationFromXml(@NonNull ISharedConfiguration configuration, @NonNull InputStream xmlStream) throws Exception {
        if (!(configuration instanceof SharedConfiguration)) {
            throw new IllegalArgumentException();
        }
        SharedConfiguration config = (SharedConfiguration)configuration;
        ISharedConfiguration loadedConfig = SharedConfigurationFactory.loadSharedConfigurationFromXml(xmlStream);
        assert (loadedConfig instanceof SharedConfiguration);
        config.copyFrom(loadedConfig, ConfigChangeReason.LOAD_CONFIG);
    }

    public static @NonNull ISharedConfiguration createShallowCopy(@NonNull ISharedConfiguration configuration) {
        SharedConfiguration sharedConfiguration = new SharedConfiguration();
        sharedConfiguration.copyFrom(configuration, ConfigChangeReason.UNKNOWN);
        return sharedConfiguration;
    }

    public static void saveSharedConfigurationToXml(@NonNull ISharedConfiguration configuration, @NonNull OutputStream out) throws Exception {
        Format format = new Format("<?xml version=\"1.0\" encoding= \"UTF-8\" ?>");
        AnnotationStrategy strategy = new AnnotationStrategy();
        Persister serializer = new Persister((Strategy)strategy, format);
        serializer.write((Object)configuration, out);
    }

    public static @NonNull String toXmlString(@NonNull Object persistentObj) throws Exception {
        StringWriter writer = new StringWriter(256);
        Format format = new Format("<?xml version=\"1.0\" encoding= \"UTF-8\" ?>");
        AnnotationStrategy strategy = new AnnotationStrategy();
        Persister serializer = new Persister((Strategy)strategy, format);
        serializer.write(persistentObj, (Writer)writer);
        StringBuffer buffer = writer.getBuffer();
        assert (buffer != null);
        return UtilsText.safeToString((Object)buffer);
    }

    public static <T> T fromXmlString(String source, Class<? extends T> persistentObjType) throws Exception {
        Persister serializer = new Persister((Strategy)new AnnotationStrategy());
        return (T)serializer.read(persistentObjType, source);
    }

    public static @NonNull String saveSharedConfigurationToString(@NonNull ISharedConfiguration configuration) throws Exception {
        return SharedConfigurationFactory.toXmlString(configuration);
    }

    @Deprecated
    public static void applyNewConfig(@NonNull ISharedConfiguration sourceConfig, @NonNull ISharedConfiguration targetConfig) {
        if (!(targetConfig instanceof SharedConfiguration)) {
            throw new IllegalArgumentException();
        }
        ((SharedConfiguration)targetConfig).copyFrom(sourceConfig, ConfigChangeReason.UNKNOWN);
    }

    public static void applyNewConfig(@NonNull ISharedConfiguration sourceConfig, @NonNull ISharedConfiguration targetConfig, @NonNull ConfigChangeReason reason) {
        if (!(targetConfig instanceof SharedConfiguration)) {
            throw new IllegalArgumentException();
        }
        ((SharedConfiguration)targetConfig).copyFrom(sourceConfig, reason);
    }

    public static void clearStorageTools(@NonNull ISharedConfiguration config, @NonNull ConfigChangeReason reason) {
        if (!(config instanceof SharedConfiguration)) {
            throw new IllegalArgumentException();
        }
        ((SharedConfiguration)config).clearTools(reason);
    }

    /*
     * Loose catch block
     */
    public static @Nullable ISharedConfiguration cloneSharedConfig(@NonNull ISharedConfiguration config) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                ISharedConfiguration iSharedConfiguration;
                ByteArrayInputStream in;
                Throwable throwable2;
                block21: {
                    ISharedConfiguration newConfig;
                    SharedConfigurationFactory.saveSharedConfigurationToXml(config, out);
                    byte[] buff = out.toByteArray();
                    throwable2 = null;
                    Object var6_10 = null;
                    in = new ByteArrayInputStream(buff);
                    iSharedConfiguration = newConfig = SharedConfigurationFactory.loadSharedConfigurationFromXml(in);
                    if (in == null) break block21;
                    in.close();
                }
                return iSharedConfiguration;
                {
                    catch (Throwable throwable3) {
                        try {
                            if (in != null) {
                                in.close();
                            }
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (throwable2 == null) {
                                throwable2 = throwable4;
                            } else if (throwable2 != throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            throw throwable2;
                        }
                    }
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "cloneSharedConfig", e);
            return null;
        }
    }

    public static boolean clearSharedConfig(@NonNull ISharedConfiguration config) {
        ISharedConfiguration newConfig = SharedConfigurationFactory.createSharedConfiguration();
        config.setLocationPath(null);
        SharedConfigurationFactory.applyNewConfig(newConfig, config, ConfigChangeReason.CLEAR_CONFIG);
        return true;
    }
}

