/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.sources.impl;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.provider.configuration.sources.ISourceFile;
import com.nxp.swtools.provider.configuration.sources.ISourceFileContributorProvider;
import com.nxp.swtools.provider.configuration.sources.ISourceFileGenerationStatus;
import com.nxp.swtools.provider.configuration.sources.ISourceFileProvider;
import com.nxp.swtools.provider.configuration.sources.ISourceFileProviderWrapper;
import com.nxp.swtools.provider.configuration.sources.SourceFileProviderFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SourceFileProviderWrapper
implements ISourceFileProviderWrapper {
    private Collection<ISourceFileProvider> sourceProviders;
    private Collection<ISourceFileContributorProvider> derivedSourceProviders;
    private static final Logger LOGGER = LogManager.getLogger(SourceFileProviderWrapper.class);

    public SourceFileProviderWrapper(Collection<ISourceFileProvider> sourceProviders, Collection<ISourceFileContributorProvider> derivedSourceProviders) {
        this.sourceProviders = sourceProviders;
        this.derivedSourceProviders = derivedSourceProviders;
    }

    @Override
    public ISourceFileProviderWrapper.ISourceGenerateResult generate(String coreId, boolean generateDerived) {
        ISourceFileGenerationStatus overallStatus = SourceFileProviderFactory.buildGenerationOKStatus();
        ArrayList<ISourceFile> generatedFiles = new ArrayList<ISourceFile>();
        for (ISourceFileProvider provider : this.sourceProviders) {
            ArrayList<ISourceFile> files;
            ISourceFileGenerationStatus result = provider.getGeneratedFiles(coreId, files = new ArrayList<ISourceFile>());
            if (ISourceFileGenerationStatus.GenerationStatus.FATAL == result.getStatus()) {
                return new SourceGenerateResult(result);
            }
            if (overallStatus.getStatus().ordinal() < result.getStatus().ordinal()) {
                overallStatus = result;
            }
            generatedFiles.addAll(files);
        }
        Collection<ISourceFile> generatedFilesNonModif = Collections.unmodifiableCollection(generatedFiles);
        assert (generatedFilesNonModif != null);
        ArrayList<ISourceFile> derivedSources = new ArrayList<ISourceFile>();
        if (generateDerived) {
            for (ISourceFileContributorProvider provider : this.derivedSourceProviders) {
                try {
                    ArrayList<ISourceFile> files = new ArrayList<ISourceFile>();
                    ISourceFileGenerationStatus result = provider.getGeneratedFiles(coreId, files, generatedFilesNonModif);
                    if (ISourceFileGenerationStatus.GenerationStatus.FATAL == result.getStatus()) {
                        return new SourceGenerateResult(result);
                    }
                    derivedSources.addAll(files);
                    if (overallStatus.getStatus().ordinal() >= result.getStatus().ordinal()) continue;
                    overallStatus = result;
                }
                catch (AbstractMethodError e) {
                    LOGGER.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
        return new SourceGenerateResult(overallStatus, generatedFiles, derivedSources);
    }

    public static class SourceGenerateResult
    implements ISourceFileProviderWrapper.ISourceGenerateResult {
        private final ISourceFileGenerationStatus status;
        private final Collection<ISourceFile> generatedFiles;
        private final Collection<ISourceFile> derivedFiles;

        public SourceGenerateResult(ISourceFileGenerationStatus status, Collection<ISourceFile> generatedFiles, Collection<ISourceFile> derivedFiles) {
            this.status = status;
            this.generatedFiles = CollectionsUtils.unmodifiableCollection(generatedFiles);
            this.derivedFiles = CollectionsUtils.unmodifiableCollection(derivedFiles);
        }

        public SourceGenerateResult(ISourceFileGenerationStatus status) {
            this(status, CollectionsUtils.emptyList(), CollectionsUtils.emptyList());
        }

        @Override
        public ISourceFileGenerationStatus.GenerationStatus getStatus() {
            return this.status.getStatus();
        }

        @Override
        public String getMessage() {
            return this.status.getMessage();
        }

        @Override
        public Collection<ISourceFile> getToolsGeneratedFiles() {
            return this.generatedFiles;
        }

        @Override
        public Collection<ISourceFile> getGeneratedDerivedFiles() {
            return this.derivedFiles;
        }

        @Override
        public Collection<ISourceFile> getAllGeneratedFiles() {
            ArrayList<ISourceFile> result = new ArrayList<ISourceFile>(this.generatedFiles);
            result.addAll(this.derivedFiles);
            return result;
        }

        @Override
        public @Nullable ISourceFile findSourceByName(@NonNull String relFilePath) {
            String osFilePath = UtilsFile.convertToOSPathFormat((String)relFilePath);
            if (!osFilePath.startsWith(File.separator)) {
                osFilePath = String.valueOf(File.separator) + osFilePath;
            }
            String osFilePathFinal = osFilePath;
            return (ISourceFile)CollectionsUtils.findFirst(this.getAllGeneratedFiles().stream(), s -> UtilsFile.convertToOSPathFormat((String)s.getRelFileName()).equals(osFilePathFinal));
        }

        @Override
        public boolean isDerivedSource(String filePath) {
            ISourceFile source = this.findSourceByName(filePath);
            return this.derivedFiles.contains(source);
        }

        @Override
        public boolean hasBlockingIssue() {
            return this.status.getStatus().equals((Object)ISourceFileGenerationStatus.GenerationStatus.FATAL);
        }
    }
}

