/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.storage;

import com.nxp.swtools.common.utils.NonNull;
import java.util.Objects;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Commit;

@Root(name="core", strict=false)
public class ProcessorCore {
    static final long serialVersionUID = 1L;
    @NonNull
    public static final String KWD_CORE = "core";
    @NonNull
    public static final String KWD_CORES = "cores";
    @Attribute
    @NonNull
    String name = "";
    @NonNull
    public static final String KWD_NAME = "name";
    @Attribute(name="id")
    @NonNull
    @Attribute(name="id") @NonNull String id = "";
    @NonNull
    public static final String KWD_ID = "id";
    @Attribute(required=false)
    @NonNull
    @Attribute(required=false) @NonNull String description = "";
    @NonNull
    public static final String KWD_DESCRIPTION = "description";
    @Attribute(name="master", required=false)
    Boolean masterInfos = null;
    boolean master = false;
    @Attribute(name="master_default", required=false)
    Boolean masterDefaultInfos = null;
    boolean masterDefault = true;
    @NonNull
    public static final String KWD_ENABLED = "enabled";
    @NonNull
    public static final ProcessorCore EMPTY_CORE = new ProcessorCore();
    @NonNull
    public static final ProcessorCore CORE_NOT_SELECTED = new ProcessorCore("not_selected", "Not Selected", "No core selected in the configuration", false, true);

    public ProcessorCore() {
    }

    public ProcessorCore(@NonNull String id, @NonNull String name, @NonNull String description, boolean master, boolean masterByDefault) {
        this();
        this.setID(id);
        this.setName(name);
        this.setDescription(description);
        this.setMaster(master);
        this.setMasterDefault(masterByDefault);
    }

    @Commit
    public void commit() {
        if (this.masterInfos != null || this.masterDefaultInfos != null) {
            this.master = false;
            this.masterDefault = false;
        }
        if (this.masterInfos != null) {
            this.master = this.masterInfos;
            this.masterInfos = null;
        }
        if (this.masterDefaultInfos != null) {
            this.masterDefault = this.masterDefaultInfos;
            this.masterDefaultInfos = null;
        }
    }

    public @NonNull String getName() {
        return this.name;
    }

    final void setName(@NonNull String name) {
        this.name = name;
    }

    public @NonNull String getID() {
        return this.id;
    }

    final void setID(@NonNull String id) {
        this.id = id;
    }

    public @NonNull String getDescription() {
        return this.description;
    }

    final void setDescription(@NonNull String description) {
        this.description = description;
    }

    public boolean isMaster() {
        return this.master;
    }

    final void setMaster(boolean master) {
        this.master = master;
    }

    public boolean isMasterDefault() {
        return this.masterDefault;
    }

    final void setMasterDefault(boolean masterDefault) {
        this.masterDefault = masterDefault;
    }

    public String toString() {
        return "ProcessorCore [name=" + this.name + ", ID=" + this.id + "]";
    }

    public int hashCode() {
        return Objects.hash(this.id, this.description, this.master, this.masterDefault, this.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProcessorCore other = (ProcessorCore)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.description, other.description) && this.master == other.master && this.masterDefault == other.masterDefault && Objects.equals(this.name, other.name);
    }

    public boolean softEquals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProcessorCore other = (ProcessorCore)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.name, other.name);
    }
}

