/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.storage.clock;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.provider.configuration.dependencies.IDependency;
import com.nxp.swtools.provider.configuration.storage.StorageTool;
import com.nxp.swtools.provider.configuration.storage.StorageToolBaseConfiguration;
import com.nxp.swtools.provider.configuration.storage.clock.StorageClocksConfiguration;
import com.nxp.swtools.provider.configuration.storage.clock.StorageClocksProfile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;

@Root(name="clocks", strict=false)
public class StorageClocksTool
extends StorageTool {
    @NonNull
    public static final String CLOCKS_TOOL_VERSION = StorageClocksTool.findVersion("Clocks");
    @NonNull
    @Element(name="clocks_profile")
    private @NonNull @Element(name="clocks_profile") StorageClocksProfile clocksProfile = new StorageClocksProfile();
    @NonNull
    @ElementList(name="clock_configurations", entry="clock_configuration")
    private @NonNull @ElementList(name="clock_configurations", entry="clock_configuration") ArrayList<@NonNull StorageClocksConfiguration> configurations = new ArrayList();

    public StorageClocksTool() {
        super("Clocks", CLOCKS_TOOL_VERSION);
    }

    @Override
    public @NonNull String getName() {
        return "Clocks";
    }

    public @NonNull StorageClocksProfile getClocksProfile() {
        return this.clocksProfile;
    }

    public void setClocksProfile(@NonNull StorageClocksProfile clocksProfile) {
        this.clocksProfile = clocksProfile;
    }

    public @NonNull ArrayList<@NonNull StorageClocksConfiguration> getConfigurations() {
        return this.configurations;
    }

    public void setConfigurations(@NonNull List<@NonNull StorageClocksConfiguration> configurations) {
        this.configurations = new ArrayList<StorageClocksConfiguration>(configurations);
    }

    @Override
    public List<? extends @NonNull StorageToolBaseConfiguration> getFunctionalGroups() {
        return this.configurations;
    }

    @Override
    public @NonNull Collection<@NonNull IDependency> getDependencies() {
        ArrayList<@NonNull IDependency> result = new ArrayList<IDependency>();
        for (StorageToolBaseConfiguration storageToolBaseConfiguration : this.configurations) {
            result.addAll(storageToolBaseConfiguration.getDependencies());
        }
        List<@NonNull IDependency> list = this.getGlobalDependencies();
        if (list != null) {
            result.addAll(list);
        }
        return CollectionsUtils.unmodifiableCollection(result);
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public boolean equals(@Nullable StorageTool other, StorageTool.CompareMode mode) {
        if (other == this) {
            return true;
        }
        if (!super.equals(other, mode)) {
            return false;
        }
        if (!(other instanceof StorageClocksTool)) {
            return false;
        }
        StorageClocksTool objTool = (StorageClocksTool)other;
        if (!this.clocksProfile.equals(objTool.clocksProfile)) {
            return false;
        }
        return this.configurations.equals(objTool.configurations);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = result * 31 + this.clocksProfile.hashCode();
        result = result * 31 + this.configurations.hashCode();
        return result;
    }
}

