/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.storage.pbl;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.configuration.SwToolsProduct;
import com.nxp.swtools.configuration.SwToolsProductConfiguration;
import com.nxp.swtools.provider.configuration.storage.StorageTool;
import com.nxp.swtools.provider.configuration.storage.StorageToolBaseConfiguration;
import com.nxp.swtools.provider.configuration.storage.pbl.StoragePBLProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;

@Root(name="pbl", strict=false)
public class StoragePBLTool
extends StorageTool {
    public static final String PBL_TOOL_VERSION;
    private Map<String, StoragePBLProperty> propertiesMap = new HashMap<String, StoragePBLProperty>();
    @ElementList(name="pbl_configuration", entry="property")
    private List<StoragePBLProperty> properties = new ArrayList<StoragePBLProperty>();

    static {
        SwToolsProduct pbl = SwToolsProductConfiguration.getRegisteredProduct((String)"PBL");
        PBL_TOOL_VERSION = pbl != null ? pbl.getVersion() : "";
    }

    public StoragePBLTool() {
        super("PBL", PBL_TOOL_VERSION);
    }

    @Override
    public @Nullable List<? extends @NonNull StorageToolBaseConfiguration> getFunctionalGroups() {
        return null;
    }

    public void addProperty(StoragePBLProperty property) {
        if (this.propertiesMap.isEmpty() && !this.properties.isEmpty()) {
            for (StoragePBLProperty loadedProperty : this.properties) {
                this.propertiesMap.put(loadedProperty.getPropertyID(), loadedProperty);
            }
        }
        this.propertiesMap.put(property.getPropertyID(), property);
        this.properties = new ArrayList<StoragePBLProperty>(this.propertiesMap.values());
    }

    public List<StoragePBLProperty> getProperties() {
        return this.properties;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        return super.equals(obj);
    }

    @Override
    public boolean equals(@Nullable StorageTool other, @NonNull StorageTool.CompareMode mode) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!super.equals(other, mode)) {
            return false;
        }
        if (!(other instanceof StoragePBLTool)) {
            return false;
        }
        StoragePBLTool pblOther = (StoragePBLTool)other;
        return this.properties.equals(pblOther.properties);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.properties.hashCode();
        return result;
    }
}

