/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.storage.pins;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.text.UtilsText;
import java.util.Objects;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Validate;

@Root(strict=false)
public class StoragePinLabel {
    static final long serialVersionUID = 1L;
    @NonNull
    @Attribute(name="pin_num", required=true)
    public @NonNull @Attribute(name="pin_num", required=true) String pinNum;
    @NonNull
    @Attribute(name="pin_signal", required=true)
    public @NonNull @Attribute(name="pin_signal", required=true) String pinSignal;
    @NonNull
    @Attribute(name="label", required=true)
    public @NonNull @Attribute(name="label", required=true) String label;
    @Nullable
    @Attribute(name="identifier", required=false)
    public @Nullable @Attribute(name="identifier", required=false) String labelIdentifier;
    @Nullable
    @Attribute(name="comment", required=false)
    private @Nullable @Attribute(name="comment", required=false) String pinComment;
    @Nullable
    private String comment;
    public boolean definedInBoardOrKit = false;
    public boolean definedInKit = false;
    public boolean definedByUser = false;

    StoragePinLabel() {
        this.pinNum = "";
        this.pinSignal = "";
        this.label = "";
    }

    public StoragePinLabel(@NonNull String pinNum, @NonNull String pinSignal, @NonNull String label, @Nullable String labelIdentifier, @Nullable String comment) {
        this.pinNum = pinNum;
        this.pinSignal = pinSignal;
        this.label = label;
        this.labelIdentifier = labelIdentifier;
        this.setComment(comment);
    }

    public String toString() {
        return "StoragePinLabel [pinNum=" + this.pinNum + ", pinSignal=" + this.pinSignal + ", label=" + this.label + ", labelIdentifier=" + this.labelIdentifier + ", comment=" + this.pinComment + ", definedInBoardOrKit=" + this.definedInBoardOrKit + ", definedInKit=" + this.definedInKit + "]";
    }

    @Validate
    public void validate() {
        String pinCommentTmp = this.pinComment;
        if (pinCommentTmp != null) {
            pinCommentTmp = UtilsText.html2Text((String)pinCommentTmp);
            assert (pinCommentTmp != null);
            pinCommentTmp = pinCommentTmp.replace("<br/>", UtilsText.platformEOL);
        }
        this.comment = pinCommentTmp;
    }

    public @Nullable String getComment() {
        return this.comment;
    }

    public void setComment(@Nullable String comment) {
        this.comment = comment;
        String pinCommentTmp = comment;
        if (pinCommentTmp != null) {
            pinCommentTmp = UtilsText.convertLineEndings((String)pinCommentTmp, (String)"<br/>");
            pinCommentTmp = UtilsText.text2Html((String)pinCommentTmp);
        }
        this.pinComment = pinCommentTmp;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StoragePinLabel other = (StoragePinLabel)obj;
        if (this.definedByUser != other.definedByUser) {
            return false;
        }
        if (this.definedInBoardOrKit != other.definedInBoardOrKit) {
            return false;
        }
        if (this.definedInKit != other.definedInKit) {
            return false;
        }
        if (!this.label.equals(other.label)) {
            return false;
        }
        if (!Objects.equals(this.labelIdentifier, other.labelIdentifier)) {
            return false;
        }
        if (!Objects.equals(this.pinComment, other.pinComment)) {
            return false;
        }
        if (!this.pinNum.equals(other.pinNum)) {
            return false;
        }
        return this.pinSignal.equals(other.pinSignal);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.definedByUser ? 1231 : 1237);
        result = 31 * result + (this.definedInBoardOrKit ? 1231 : 1237);
        result = 31 * result + (this.definedInKit ? 1231 : 1237);
        result = 31 * result + this.label.hashCode();
        result = 31 * result + (this.labelIdentifier != null ? this.labelIdentifier.hashCode() : 0);
        result = 31 * result + (this.pinComment != null ? this.pinComment.hashCode() : 0);
        result = 31 * result + this.pinNum.hashCode();
        result = 31 * result + this.pinSignal.hashCode();
        return result;
    }
}

