/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.storage.pins;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.provider.configuration.storage.StorageBaseProfile;
import com.nxp.swtools.provider.configuration.storage.StorageValue;
import com.nxp.swtools.provider.configuration.storage.pins.StorageConnectedBoard;
import com.nxp.swtools.provider.configuration.storage.pins.StorageExpansionBoard;
import com.nxp.swtools.provider.configuration.storage.pins.StorageExpansionHeader;
import com.nxp.swtools.provider.configuration.storage.pins.StorageExternalUserSignals;
import com.nxp.swtools.provider.configuration.storage.pins.StoragePinLabel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Order;
import org.simpleframework.xml.Root;

@Root(name="pins_profile", strict=false)
@Order(elements={"processor_version", "pin_labels", "expansion_headers", "expansion_boards", "connected_expansion_boards", "external_user_signals", "power_domains"})
public class StoragePinsProfile
extends StorageBaseProfile {
    @ElementList(name="pin_labels", entry="pin_label", required=false)
    @Nullable
    protected @ElementList(name="pin_labels", entry="pin_label", required=false) @Nullable ArrayList<StoragePinLabel> pinLabels = null;
    @ElementList(name="expansion_headers", entry="expansion_header", required=false)
    @Nullable
    protected @ElementList(name="expansion_headers", entry="expansion_header", required=false) @Nullable ArrayList<@NonNull StorageExpansionHeader> expansionHeaders = null;
    @ElementList(name="expansion_boards", entry="expansion_board", required=false)
    @Nullable
    protected @ElementList(name="expansion_boards", entry="expansion_board", required=false) @Nullable ArrayList<@NonNull StorageExpansionBoard> expansionBoards = null;
    @Nullable
    protected ArrayList<@NonNull StorageConnectedBoard> connectedExpansionBoards = null;
    @Element(name="external_user_signals", required=false)
    @Nullable
    protected @Element(name="external_user_signals", required=false) @Nullable StorageExternalUserSignals externalUserSignals = null;
    @ElementList(name="power_domains", entry="power_domain", required=false)
    @Nullable
    protected @ElementList(name="power_domains", entry="power_domain", required=false) @Nullable ArrayList<StorageValue> powerDomains = null;

    @ElementList(name="connected_expansion_boards", entry="connected_board", required=false)
    protected @ElementList(name="connected_expansion_boards", entry="connected_board", required=false) @Nullable ArrayList<@NonNull StorageConnectedBoard> getSortedConnectedExpansionBoards() {
        ArrayList<@NonNull StorageConnectedBoard> connectedExpansionBoardsLoc = this.connectedExpansionBoards;
        if (connectedExpansionBoardsLoc != null) {
            Collections.sort(connectedExpansionBoardsLoc);
        }
        return connectedExpansionBoardsLoc;
    }

    @ElementList(name="connected_expansion_boards", entry="connected_board", required=false)
    protected void setSortedConnectedExpansionBoards(@Nullable ArrayList<@NonNull StorageConnectedBoard> connectedExpansionBoards) {
        if (connectedExpansionBoards != null) {
            Collections.sort(connectedExpansionBoards);
        }
        this.connectedExpansionBoards = connectedExpansionBoards;
    }

    public void setPowerDomains(@Nullable List<StorageValue> powerDomainItems) {
        this.powerDomains = powerDomainItems == null ? null : new ArrayList<StorageValue>(powerDomainItems);
    }

    public @Nullable List<StorageValue> getPowerDomains() {
        return this.powerDomains;
    }

    public void setPinLabels(@Nullable List<StoragePinLabel> pinLabelsList) {
        this.pinLabels = pinLabelsList == null ? null : new ArrayList<StoragePinLabel>(pinLabelsList);
    }

    public @Nullable List<StoragePinLabel> getPinLabels() {
        return this.pinLabels;
    }

    public void setExpansionHeaders(@Nullable List<@NonNull StorageExpansionHeader> expansionHeadersList) {
        this.expansionHeaders = expansionHeadersList == null ? null : new ArrayList<StorageExpansionHeader>(expansionHeadersList);
    }

    public @NonNull List<@NonNull StorageExpansionHeader> getExpansionHeaders() {
        if (this.expansionHeaders == null) {
            return Collections.emptyList();
        }
        assert (this.expansionHeaders != null);
        return this.expansionHeaders;
    }

    public void setExpansionBoards(@Nullable List<@NonNull StorageExpansionBoard> expansionBoardsList) {
        this.expansionBoards = expansionBoardsList == null ? null : new ArrayList<StorageExpansionBoard>(expansionBoardsList);
    }

    public @Nullable List<@NonNull StorageExpansionBoard> getExpansionBoards() {
        return this.expansionBoards;
    }

    public void setConnectedExpansionBoards(@Nullable List<@NonNull StorageConnectedBoard> connectedExpansionBoardList) {
        this.connectedExpansionBoards = connectedExpansionBoardList == null ? null : new ArrayList<StorageConnectedBoard>(connectedExpansionBoardList);
    }

    public @Nullable List<@NonNull StorageConnectedBoard> getConnectedExpansionBoards() {
        return this.connectedExpansionBoards;
    }

    public void setExternalUserSignals(@Nullable StorageExternalUserSignals externalUserSignals) {
        this.externalUserSignals = externalUserSignals;
    }

    public @Nullable StorageExternalUserSignals getExternalUserSignals() {
        return this.externalUserSignals;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.processorVersion.hashCode();
        result = 31 * result + Objects.hashCode(this.powerDomains);
        result = 31 * result + Objects.hashCode(this.pinLabels);
        result = 31 * result + Objects.hashCode(this.expansionHeaders);
        result = 31 * result + Objects.hashCode(this.expansionBoards);
        result = 31 * result + Objects.hashCode(this.connectedExpansionBoards);
        result = 31 * result + Objects.hashCode(this.externalUserSignals);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (!(obj instanceof StoragePinsProfile)) {
            return false;
        }
        StoragePinsProfile other = (StoragePinsProfile)obj;
        if (!this.processorVersion.equals(other.getProcessorVersion())) {
            return false;
        }
        if (!Objects.equals(this.powerDomains, other.getPowerDomains())) {
            return false;
        }
        if (!Objects.equals(this.pinLabels, other.getPinLabels())) {
            return false;
        }
        if (!Objects.equals(this.expansionHeaders, other.expansionHeaders)) {
            return false;
        }
        if (!Objects.equals(this.expansionBoards, other.expansionBoards)) {
            return false;
        }
        if (!Objects.equals(this.connectedExpansionBoards, other.connectedExpansionBoards)) {
            return false;
        }
        return Objects.equals(this.externalUserSignals, other.externalUserSignals);
    }
}

