/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.storage.quadspi;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.provider.configuration.storage.bootimage.StorageBootStructSetting;
import com.nxp.swtools.provider.configuration.storage.quadspi.StorageQuadSPIGeneralSettings;
import com.nxp.swtools.provider.configuration.storage.quadspi.StorageQuadSPIRegister;
import com.nxp.swtools.provider.configuration.storage.quadspi.StorageQuadSPISequences;
import java.util.ArrayList;
import java.util.Objects;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;

@Root(name="quadspi_records", strict=false)
public class StorageQuadSPIRecords {
    @Element(name="general_settings", required=false)
    private StorageQuadSPIGeneralSettings generalSettings = new StorageQuadSPIGeneralSettings();
    @ElementList(name="quadspi_registers", entry="quadspi_register", empty=false, required=false, inline=true)
    private ArrayList<StorageQuadSPIRegister> registers = new ArrayList();
    @Element(name="data_sequences", required=false)
    private StorageQuadSPISequences dataSequences = new StorageQuadSPISequences();

    public StorageQuadSPIGeneralSettings getGeneralSettings() {
        return this.generalSettings;
    }

    public void setGeneralSettings(StorageQuadSPIGeneralSettings generalSettings) {
        this.generalSettings = generalSettings;
    }

    public ArrayList<StorageQuadSPIRegister> getRegistersList() {
        return this.registers;
    }

    public void setRegisters(ArrayList<StorageQuadSPIRegister> registers) {
        this.registers = registers;
    }

    public @Nullable StorageQuadSPIRegister getRegisterByName(String regName) {
        for (StorageQuadSPIRegister register : this.registers) {
            if (!register.getName().equals(regName)) continue;
            return register;
        }
        return null;
    }

    public StorageQuadSPISequences getDataSequences() {
        return this.dataSequences;
    }

    public void setDataSequences(StorageQuadSPISequences dataSequences) {
        this.dataSequences = dataSequences;
    }

    public @Nullable StorageBootStructSetting getStorageStructSettingByName(String structName) {
        StorageBootStructSetting stStructSetting = this.generalSettings.getStructSettingByName(structName);
        if (stStructSetting == null) {
            stStructSetting = this.dataSequences.getStructSettingByName(structName);
        }
        return stStructSetting;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StorageQuadSPIRecords other = (StorageQuadSPIRecords)obj;
        return Objects.equals(this.generalSettings, other.generalSettings) && Objects.equals(this.registers, other.registers) && Objects.equals(this.dataSequences, other.dataSequences);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = result * 31 + this.generalSettings.hashCode();
        result = result * 31 + Objects.hashCode(this.registers);
        result = result * 31 + this.dataSequences.hashCode();
        return result;
    }
}

