/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.storage.tee;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.provider.configuration.storage.tee.AStorageTeeRwxAccessRule;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Order;
import org.simpleframework.xml.Root;

@Root(strict=false)
@Order(attributes={"id", "name", "locked"})
public abstract class AStorageTeeAccessTemplateConfig<T extends AStorageTeeRwxAccessRule> {
    public static final String NS_USER_MODE_ID = "ns_user";
    public static final String NS_PRIV_MODE_ID = "ns_priv";
    public static final String S_USER_MODE_ID = "s_user";
    public static final String S_PRIV_MODE_ID = "s_priv";
    @Attribute(name="id", required=true)
    private String id = "";
    @Attribute(name="name", required=false)
    @Nullable
    private @Attribute(name="name", required=false) @Nullable String name;
    @Attribute(name="locked", required=false)
    @Nullable
    private @Attribute(name="locked", required=false) @Nullable Boolean locked;
    @Attribute(name="editable", required=false)
    @Nullable
    private @Attribute(name="editable", required=false) @Nullable Boolean editable;
    @Attribute(name="bitfield", required=false)
    @Nullable
    private @Attribute(name="bitfield", required=false) @Nullable String bitfieldName;
    private List<T> access = new ArrayList<T>();

    public @Nullable T getAccess(String securityLevel, @Nullable T defaultValue) {
        @Nullable AStorageTeeRwxAccessRule resultAccess = (AStorageTeeRwxAccessRule)CollectionsUtils.findAny(this.access, a -> securityLevel.equals(a.getSecurityLevelString()));
        if (resultAccess == null) {
            resultAccess = (AStorageTeeRwxAccessRule)CollectionsUtils.findAny(this.access, a -> a.getSecurityLevelString() == null);
        }
        if (resultAccess == null) {
            resultAccess = defaultValue;
        }
        return (T)resultAccess;
    }

    public @Nullable T getAccessForRegion(String securityLevel, @Nullable T defaultValue, boolean region) {
        @Nullable AStorageTeeRwxAccessRule resultAccess = (AStorageTeeRwxAccessRule)CollectionsUtils.findAny(this.access, a -> Boolean.toString(region).equals(a.getRegionString()) && securityLevel.equals(a.getSecurityLevelString()));
        if (resultAccess == null) {
            resultAccess = (AStorageTeeRwxAccessRule)CollectionsUtils.findAny(this.access, a -> a.getSecurityLevelString() == null);
        }
        if (resultAccess == null) {
            resultAccess = defaultValue;
        }
        return (T)resultAccess;
    }

    public void setAccess(T rwxAccess) {
        this.access.removeIf(a -> Objects.equals(rwxAccess.getSecurityLevelString(), a.getSecurityLevelString()));
        this.access.add(rwxAccess);
    }

    public String getId() {
        return this.id;
    }

    public @Nullable String getName() {
        return this.name;
    }

    public List<T> getAccess() {
        return this.access;
    }

    public @Nullable Boolean getLocked() {
        return this.locked;
    }

    public @Nullable Boolean getEditable() {
        return this.editable;
    }

    public @Nullable String getBitfieldName() {
        return this.bitfieldName;
    }

    public boolean hasLock() {
        return this.locked != null;
    }

    public boolean isLocked() {
        return this.locked != null && this.locked != false;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(@Nullable String name) {
        this.name = name;
    }

    public void setAccess(List<T> access) {
        this.access = access;
    }

    public void setLock(boolean lock) {
        this.locked = lock;
    }

    public void setLocked(@Nullable Boolean locked) {
        this.locked = locked;
    }

    public void setEditable(@Nullable Boolean editable) {
        this.editable = editable;
    }

    public void setBitfield(@Nullable String bitfield) {
        this.bitfieldName = bitfield;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.locked, this.access);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AStorageTeeAccessTemplateConfig other = (AStorageTeeAccessTemplateConfig)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.name, other.name) && Objects.equals(this.locked, other.locked) && Objects.equals(this.access, other.access);
    }

    public String toString() {
        return String.format("%s [id=%s, name=%s, locked=%s, access=%s]", this.getClass().getSimpleName(), this.id, this.name, this.locked, this.access);
    }
}

