/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.storage.tee;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.yaml.IYamlStorable;
import com.nxp.swtools.common.utils.yaml.YamlStorableHelper;
import com.nxp.swtools.common.utils.yaml.YamlStorableList;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeeAhbMasterConfig;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeeAhbMasterSlaveConfig;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeeAhbPeripheralConfig;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeeRelativeMemoryRegionConfig;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeeSecurityPeripheralBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Order;
import org.simpleframework.xml.Root;

@Root(name="ahb", strict=false)
@Order(elements={"relative_region", "masters", "peripherals", "interrupts", "pins_masks"})
public class StorageTeeAhb
extends StorageTeeSecurityPeripheralBase {
    public static final String AHB_ID = "ahb";
    private static final String MASTER_ID = "master";
    public static final String MASTERS_ID = "masters";
    public static final String PERIPHERALS_ID = "peripherals";
    private static final String PERIPHERAL_ID = "peripheral";
    private static final String SECURITY_LEVEL_ID = "security";
    private static final String REGIONS_ID = "regions";
    @ElementList(inline=true, required=false, type=StorageTeeRelativeMemoryRegionConfig.class)
    private List<StorageTeeRelativeMemoryRegionConfig> relativeRegions = new ArrayList<StorageTeeRelativeMemoryRegionConfig>();
    @ElementList(inline=false, required=true, type=StorageTeeAhbMasterConfig.class, name="masters", entry="master")
    private ArrayList<StorageTeeAhbMasterConfig> masters = new ArrayList();
    @ElementList(inline=false, required=false, type=StorageTeeAhbPeripheralConfig.class, name="peripherals", entry="peripheral")
    private ArrayList<StorageTeeAhbPeripheralConfig> peripherals = new ArrayList();

    public List<StorageTeeRelativeMemoryRegionConfig> getRelativeRegions() {
        return this.relativeRegions;
    }

    public void setRelativeRegions(List<StorageTeeRelativeMemoryRegionConfig> relativeRegions) {
        this.relativeRegions = relativeRegions;
    }

    public List<StorageTeeAhbMasterConfig> getMasterConfigs() {
        return this.masters;
    }

    public void setMasterConfigs(List<StorageTeeAhbMasterConfig> masters) {
        this.masters = new ArrayList<StorageTeeAhbMasterConfig>(masters);
    }

    public List<StorageTeeAhbPeripheralConfig> getPeripheralsConfigs() {
        return this.peripherals;
    }

    public void setSlaveConfigs(List<StorageTeeAhbPeripheralConfig> peripherals) {
        this.peripherals = new ArrayList<StorageTeeAhbPeripheralConfig>(peripherals);
    }

    @Override
    public void fillYamlStorable(IYamlStorable yaml) {
        YamlStorableList yamlStorable = new YamlStorableList(AHB_ID, Boolean.FALSE);
        super.fillYamlStorable((IYamlStorable)yamlStorable);
        yaml.addYamlChild((IYamlStorable)yamlStorable);
        YamlStorableList relativeRegionsYaml = new YamlStorableList(REGIONS_ID, Boolean.TRUE);
        relativeRegionsYaml.setForceSequence(true);
        this.relativeRegions.forEach(each -> each.fillYamlStorable((IYamlStorable)relativeRegionsYaml));
        yamlStorable.addYamlChild((IYamlStorable)relativeRegionsYaml);
        YamlStorableList mastersYaml = new YamlStorableList(MASTERS_ID, Boolean.TRUE);
        this.masters.forEach(each -> each.fillYamlStorable((IYamlStorable)mastersYaml));
        yamlStorable.addYamlChild(YamlStorableHelper.convertToShortForm((IYamlStorable)mastersYaml, (String)SECURITY_LEVEL_ID));
        YamlStorableList peripheralsYaml = new YamlStorableList(PERIPHERALS_ID, Boolean.TRUE);
        this.peripherals.forEach(each -> each.fillYamlStorable((IYamlStorable)peripheralsYaml));
        yamlStorable.addYamlChild(YamlStorableHelper.convertToShortForm((IYamlStorable)peripheralsYaml, (String)SECURITY_LEVEL_ID));
    }

    @Override
    public boolean updateFromYamlStorable(IYamlStorable yaml) {
        if (!yaml.getYamlId().equals(AHB_ID) || !super.updateFromYamlStorable(yaml)) {
            return false;
        }
        ArrayList<StorageTeeRelativeMemoryRegionConfig> relativeRegionsLoc = new ArrayList<StorageTeeRelativeMemoryRegionConfig>();
        ArrayList<StorageTeeAhbMasterSlaveConfig> mastersLoc = new ArrayList<StorageTeeAhbMasterConfig>();
        ArrayList<StorageTeeAhbMasterSlaveConfig> peripheralsLoc = new ArrayList<StorageTeeAhbPeripheralConfig>();
        Collection children = YamlStorableHelper.getChildrenAndSkipMapLayer((IYamlStorable)yaml);
        for (IYamlStorable childYaml : children) {
            StorageTeeAhbMasterSlaveConfig config;
            Iterator iterator;
            String yamlId = childYaml.getYamlId();
            if (!(childYaml instanceof YamlStorableList)) continue;
            if (yamlId.equals(REGIONS_ID)) {
                ArrayList<StorageTeeRelativeMemoryRegionConfig> regionsFromYaml = new ArrayList<StorageTeeRelativeMemoryRegionConfig>();
                for (IYamlStorable regionYaml : CollectionsUtils.safeCollection((Collection)childYaml.getYamlChildren())) {
                    StorageTeeRelativeMemoryRegionConfig config2;
                    if (regionYaml instanceof YamlStorableList) {
                        regionYaml = YamlStorableHelper.skipMapLayer((YamlStorableList)((YamlStorableList)regionYaml), (String)"relative_region");
                    }
                    if (!(config2 = new StorageTeeRelativeMemoryRegionConfig()).updateFromYamlStorable(regionYaml)) continue;
                    regionsFromYaml.add(config2);
                }
                relativeRegionsLoc = regionsFromYaml;
                continue;
            }
            if (yamlId.equals(MASTERS_ID)) {
                ArrayList<StorageTeeAhbMasterSlaveConfig> mastersFromYaml = new ArrayList<StorageTeeAhbMasterSlaveConfig>();
                IYamlStorable masterLongForm = YamlStorableHelper.convertToLongForm((IYamlStorable)childYaml, (String)SECURITY_LEVEL_ID, (String)MASTER_ID);
                Collection mastersYamls = YamlStorableHelper.getChildrenCheckIdAndSkipMapLayer((IYamlStorable)masterLongForm, (String)MASTERS_ID);
                iterator = mastersYamls.iterator();
                while (iterator.hasNext()) {
                    config = new StorageTeeAhbMasterConfig();
                    IYamlStorable masterYaml = (IYamlStorable)iterator.next();
                    if (!config.updateFromYamlStorable(masterYaml)) continue;
                    mastersFromYaml.add(config);
                }
                mastersLoc = mastersFromYaml;
                continue;
            }
            if (!yamlId.equals(PERIPHERALS_ID)) continue;
            ArrayList<StorageTeeAhbMasterSlaveConfig> peripheralsFromYaml = new ArrayList<StorageTeeAhbMasterSlaveConfig>();
            IYamlStorable peripheralsLongForm = YamlStorableHelper.convertToLongForm((IYamlStorable)childYaml, (String)SECURITY_LEVEL_ID, (String)PERIPHERAL_ID);
            Collection peripheralsYamls = YamlStorableHelper.getChildrenCheckIdAndSkipMapLayer((IYamlStorable)peripheralsLongForm, (String)PERIPHERALS_ID);
            iterator = peripheralsYamls.iterator();
            while (iterator.hasNext()) {
                config = new StorageTeeAhbPeripheralConfig();
                IYamlStorable peripheralYaml = (IYamlStorable)iterator.next();
                if (!config.updateFromYamlStorable(peripheralYaml)) continue;
                peripheralsFromYaml.add(config);
            }
            peripheralsLoc = peripheralsFromYaml;
        }
        this.setRelativeRegions(relativeRegionsLoc);
        this.setMasterConfigs(mastersLoc);
        this.setSlaveConfigs(peripheralsLoc);
        return true;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.masters, this.peripherals, this.relativeRegions);
        return result;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        StorageTeeAhb other = (StorageTeeAhb)obj;
        return Objects.equals(this.masters, other.masters) && Objects.equals(this.peripherals, other.peripherals) && Objects.equals(this.relativeRegions, other.relativeRegions);
    }
}

