/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.storage.tee;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.common.utils.yaml.IYamlStorable;
import com.nxp.swtools.common.utils.yaml.YamlStorableHelper;
import com.nxp.swtools.common.utils.yaml.YamlStorableList;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeeApuConfig;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeeGlobalOption;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeeMpuBank;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeeSau;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeeSecurityPeripheralBase;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeeSecurityPeripheralsContainer;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeeUserMemoryRegionConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

public class StorageTeeFuncGroupDelegate {
    @Nullable
    private StorageTeeSecurityPeripheralBase securityPeripheral;
    @Nullable
    private StorageTeeSau sau;
    @Nullable
    private ArrayList<StorageTeeGlobalOption> globalOptions;
    @Nullable
    private ArrayList<StorageTeeUserMemoryRegionConfig> userMemRegions;
    @Nullable
    private ArrayList<StorageTeeApuConfig> apus;
    @Nullable
    private ArrayList<StorageTeeMpuBank> mpus;

    public boolean isEmpty() {
        ArrayList<StorageTeeGlobalOption> globalOptionsLoc = this.globalOptions;
        ArrayList<StorageTeeUserMemoryRegionConfig> userMemRegionsLoc = this.userMemRegions;
        ArrayList<StorageTeeApuConfig> apusLoc = this.apus;
        ArrayList<StorageTeeMpuBank> mpusLoc = this.mpus;
        return !(this.securityPeripheral != null || this.sau != null || globalOptionsLoc != null && !globalOptionsLoc.isEmpty() || userMemRegionsLoc != null && !userMemRegionsLoc.isEmpty() || apusLoc != null && !apusLoc.isEmpty() || mpusLoc != null && !mpusLoc.isEmpty());
    }

    public @Nullable StorageTeeSecurityPeripheralBase getSecurityPeripheral() {
        return this.securityPeripheral;
    }

    public void setSecurityPeripheral(@Nullable StorageTeeSecurityPeripheralBase securityPeripheral) {
        this.securityPeripheral = securityPeripheral;
    }

    public @Nullable StorageTeeSau getSau() {
        return this.sau;
    }

    public void setSau(@Nullable StorageTeeSau sau) {
        this.sau = sau;
    }

    public @Nullable ArrayList<StorageTeeGlobalOption> getGlobalOptions() {
        return this.globalOptions != null && this.globalOptions.isEmpty() ? null : this.globalOptions;
    }

    public void setGlobalOptions(@Nullable ArrayList<StorageTeeGlobalOption> globalOptions) {
        this.globalOptions = globalOptions != null && globalOptions.isEmpty() ? null : globalOptions;
    }

    public @Nullable ArrayList<StorageTeeUserMemoryRegionConfig> getUserMemRegions() {
        return this.userMemRegions != null && this.userMemRegions.isEmpty() ? null : this.userMemRegions;
    }

    public void setUserMemRegions(@Nullable ArrayList<StorageTeeUserMemoryRegionConfig> userMemRegions) {
        this.userMemRegions = userMemRegions != null && userMemRegions.isEmpty() ? null : userMemRegions;
    }

    public @Nullable ArrayList<StorageTeeApuConfig> getApus() {
        return this.apus != null && this.apus.isEmpty() ? null : this.apus;
    }

    public void setApus(@Nullable ArrayList<StorageTeeApuConfig> apus) {
        this.apus = apus != null && apus.isEmpty() ? null : apus;
    }

    public @Nullable ArrayList<StorageTeeMpuBank> getMpus() {
        return this.mpus != null && this.mpus.isEmpty() ? null : this.mpus;
    }

    public void setMpus(@Nullable ArrayList<StorageTeeMpuBank> mpus) {
        this.mpus = mpus != null && mpus.isEmpty() ? null : mpus;
    }

    public ArrayList<StorageTeeGlobalOption> provideGlobalOptions() {
        return this.globalOptions != null ? this.globalOptions : new ArrayList<StorageTeeGlobalOption>();
    }

    public Map<String, String> getGlobalOptionsMap() {
        return (Map)this.provideGlobalOptions().stream().collect(CollectorsUtils.toMap(StorageTeeGlobalOption::getId, StorageTeeGlobalOption::getValue));
    }

    public StorageTeeSau provideSau() {
        StorageTeeSau sauLoc = this.getSau();
        if (sauLoc == null) {
            sauLoc = new StorageTeeSau();
            this.setSau(sauLoc);
        }
        return sauLoc;
    }

    public ArrayList<StorageTeeUserMemoryRegionConfig> provideUserMemRegions() {
        return this.userMemRegions != null ? this.userMemRegions : new ArrayList<StorageTeeUserMemoryRegionConfig>();
    }

    public void saveToYaml(YamlStorableList<IYamlStorable> yamlStorable) {
        ArrayList<StorageTeeMpuBank> mpusLoc;
        ArrayList<StorageTeeGlobalOption> globalOptionsLoc;
        if (this.securityPeripheral != null) {
            this.securityPeripheral.fillYamlStorable((IYamlStorable)yamlStorable);
        }
        if (this.sau != null) {
            this.sau.fillYamlStorable((IYamlStorable)yamlStorable);
        }
        if (!(globalOptionsLoc = this.provideGlobalOptions()).isEmpty()) {
            YamlStorableList globalOptionsYaml = new YamlStorableList("global_options", Boolean.FALSE);
            globalOptionsLoc.forEach(globalOption -> globalOption.fillYamlStorable((IYamlStorable)globalOptionsYaml));
            yamlStorable.addYamlChild(YamlStorableHelper.convertToShortForm((IYamlStorable)globalOptionsYaml, (String)"value"));
        }
        YamlStorableList userMemRegionsYaml = new YamlStorableList("user_memory_regions", Boolean.TRUE);
        userMemRegionsYaml.setForceSequence(true);
        this.provideUserMemRegions().forEach(userMemRegion -> userMemRegion.fillYamlStorable((IYamlStorable)userMemRegionsYaml));
        yamlStorable.addYamlChild((IYamlStorable)userMemRegionsYaml);
        ArrayList<StorageTeeApuConfig> apusLoc = this.getApus();
        if (apusLoc != null) {
            YamlStorableList apusYaml = new YamlStorableList("apus", Boolean.FALSE);
            apusLoc.forEach(apu -> apu.fillYamlStorable((IYamlStorable)apusYaml));
            yamlStorable.addYamlChild((IYamlStorable)apusYaml);
        }
        if ((mpusLoc = this.getMpus()) != null) {
            YamlStorableList mpusYaml = new YamlStorableList("mpus", Boolean.FALSE);
            mpusLoc.forEach(mpu -> mpu.fillYamlStorable((IYamlStorable)mpusYaml));
            yamlStorable.addYamlChild((IYamlStorable)mpusYaml);
        }
    }

    public void loadFromYaml(IYamlStorable yaml) {
        StorageTeeSau sauLoc = null;
        ArrayList<StorageTeeGlobalOption> globalOptionsLoc = new ArrayList<StorageTeeGlobalOption>();
        ArrayList<StorageTeeUserMemoryRegionConfig> userMemRegionsLoc = new ArrayList<StorageTeeUserMemoryRegionConfig>();
        ArrayList<StorageTeeApuConfig> apusLoc = null;
        ArrayList<StorageTeeMpuBank> mpusLoc = null;
        StorageTeeSecurityPeripheralBase securityPeripheralLoc = null;
        Collection children = YamlStorableHelper.getChildrenAndSkipMapLayer((IYamlStorable)yaml);
        for (IYamlStorable childYaml : children) {
            Iterator iterator;
            StorageTeeSecurityPeripheralBase securityPeripheralFromYaml = StorageTeeSecurityPeripheralsContainer.createFromYaml(childYaml);
            if (securityPeripheralFromYaml != null && securityPeripheralLoc == null) {
                securityPeripheralLoc = securityPeripheralFromYaml;
                continue;
            }
            if (childYaml.getYamlId().equals("sau")) {
                StorageTeeSau sauFromYaml = new StorageTeeSau();
                if (!sauFromYaml.updateFromYamlStorable(childYaml)) continue;
                sauLoc = sauFromYaml;
                continue;
            }
            if (childYaml.getYamlId().equals("global_options")) {
                IYamlStorable childYamlLongForm = YamlStorableHelper.convertToLongForm((IYamlStorable)childYaml, (String)"value", (String)"option");
                Collection globalOptionsYamls = YamlStorableHelper.getChildrenCheckIdAndSkipMapLayer((IYamlStorable)childYamlLongForm, (String)"global_options");
                iterator = globalOptionsYamls.iterator();
                while (iterator.hasNext()) {
                    StorageTeeGlobalOption globalOptStorage = new StorageTeeGlobalOption();
                    IYamlStorable globalOptYaml = (IYamlStorable)iterator.next();
                    if (!globalOptStorage.updateFromYamlStorable(globalOptYaml)) continue;
                    globalOptionsLoc.add(globalOptStorage);
                }
                continue;
            }
            if (childYaml.getYamlId().equals("user_memory_regions")) {
                for (IYamlStorable userMemRegionYaml : CollectionsUtils.safeCollection((Collection)childYaml.getYamlChildren())) {
                    StorageTeeUserMemoryRegionConfig newUserMemRegionStorage;
                    if (userMemRegionYaml instanceof YamlStorableList) {
                        userMemRegionYaml = YamlStorableHelper.skipMapLayer((YamlStorableList)((YamlStorableList)userMemRegionYaml), (String)"user_memory_region");
                    }
                    if (!(newUserMemRegionStorage = new StorageTeeUserMemoryRegionConfig()).updateFromYamlStorable(userMemRegionYaml)) continue;
                    userMemRegionsLoc.add(newUserMemRegionStorage);
                }
                continue;
            }
            if (childYaml.getYamlId().equals("apus")) {
                ArrayList<StorageTeeApuConfig> apusFromYaml = new ArrayList<StorageTeeApuConfig>();
                Collection apusYaml = YamlStorableHelper.getChildrenCheckIdAndSkipMapLayer((IYamlStorable)childYaml, (String)"apus");
                iterator = apusYaml.iterator();
                while (iterator.hasNext()) {
                    StorageTeeApuConfig apuStorable = new StorageTeeApuConfig();
                    IYamlStorable apuYaml = (IYamlStorable)iterator.next();
                    if (!apuStorable.updateFromYamlStorable(apuYaml)) continue;
                    apusFromYaml.add(apuStorable);
                }
                apusLoc = apusFromYaml.isEmpty() ? null : apusFromYaml;
                continue;
            }
            if (!childYaml.getYamlId().equals("mpus")) continue;
            ArrayList<StorageTeeMpuBank> mpusFromYaml = new ArrayList<StorageTeeMpuBank>();
            Collection mpusYaml = YamlStorableHelper.getChildrenCheckIdAndSkipMapLayer((IYamlStorable)childYaml, (String)"mpus");
            iterator = mpusYaml.iterator();
            while (iterator.hasNext()) {
                StorageTeeMpuBank mpuStorable = new StorageTeeMpuBank();
                IYamlStorable mpuYaml = (IYamlStorable)iterator.next();
                if (!mpuStorable.updateFromYamlStorable(mpuYaml)) continue;
                mpusFromYaml.add(mpuStorable);
            }
            ArrayList<StorageTeeMpuBank> arrayList = mpusLoc = mpusFromYaml.isEmpty() ? null : mpusFromYaml;
        }
        if (securityPeripheralLoc != null) {
            this.setSecurityPeripheral(securityPeripheralLoc);
        }
        this.setSau(sauLoc);
        this.setGlobalOptions(globalOptionsLoc);
        this.setUserMemRegions(userMemRegionsLoc);
        this.setApus(apusLoc);
        this.setMpus(mpusLoc);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode() * prime;
        result = result * prime + Objects.hash(this.securityPeripheral, this.sau, this.globalOptions, this.userMemRegions, this.apus, this.mpus);
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StorageTeeFuncGroupDelegate other = (StorageTeeFuncGroupDelegate)obj;
        return Objects.equals(this.securityPeripheral, other.securityPeripheral) && Objects.equals(this.sau, other.sau) && Objects.equals(this.globalOptions, other.globalOptions) && Objects.equals(this.userMemRegions, other.userMemRegions) && Objects.equals(this.apus, other.apus) && Objects.equals(this.mpus, other.mpus);
    }
}

