/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.storage.tee;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.yaml.IYamlConvertible;
import com.nxp.swtools.common.utils.yaml.IYamlStorable;
import com.nxp.swtools.common.utils.yaml.YamlStorableHelper;
import com.nxp.swtools.common.utils.yaml.YamlStorableList;
import com.nxp.swtools.common.utils.yaml.YamlStorableValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Root;

@Root(name="region_properties", strict=false)
public class StorageTeeMpuSharedAttributes
implements IYamlConvertible {
    public static final String CACHEABLE_ID = "cacheable";
    public static final String WRITE_BACKED_ID = "write_back";
    public static final String READ_ALLOCATED_ID = "read_allocation";
    public static final String WRITE_ALLOCATED_ID = "write_allocation";
    public static final String TRANSIENT_ID = "transientness";
    @Attribute(name="id", required=true)
    private String id = "";
    @Attribute(name="cacheable", required=false)
    @Nullable
    private @Attribute(name="cacheable", required=false) @Nullable Boolean cacheable;
    @Attribute(name="write_back", required=false)
    @Nullable
    private @Attribute(name="write_back", required=false) @Nullable Boolean writeBacked;
    @Attribute(name="read_allocation", required=false)
    @Nullable
    private @Attribute(name="read_allocation", required=false) @Nullable Boolean readAllocated;
    @Attribute(name="write_allocation", required=false)
    @Nullable
    private @Attribute(name="write_allocation", required=false) @Nullable Boolean writeAllocated;
    @Attribute(name="transientness", required=false)
    @Nullable
    private @Attribute(name="transientness", required=false) @Nullable Boolean transientAttr;

    public StorageTeeMpuSharedAttributes(String id) {
        this.id = id;
    }

    public StorageTeeMpuSharedAttributes() {
    }

    public void fillYamlStorable(IYamlStorable yaml) {
        ArrayList<YamlStorableValue> storage = new ArrayList<YamlStorableValue>();
        storage.add(new YamlStorableValue("id", this.getId()));
        if (this.cacheable != null) {
            storage.add(new YamlStorableValue(CACHEABLE_ID, Boolean.toString(this.isCacheable())));
        }
        if (this.writeBacked != null) {
            storage.add(new YamlStorableValue(WRITE_BACKED_ID, Boolean.toString(this.isWriteBacked())));
        }
        if (this.readAllocated != null) {
            storage.add(new YamlStorableValue(READ_ALLOCATED_ID, Boolean.toString(this.isReadAllocated())));
        }
        if (this.writeAllocated != null) {
            storage.add(new YamlStorableValue(WRITE_ALLOCATED_ID, Boolean.toString(this.isWriteAllocated())));
        }
        if (this.transientAttr != null) {
            storage.add(new YamlStorableValue(TRANSIENT_ID, Boolean.toString(this.isTransientAttr())));
        }
        yaml.addYamlChild((IYamlStorable)new YamlStorableList("region_properties", storage, Boolean.TRUE));
    }

    public boolean updateFromYamlStorable(IYamlStorable yaml) {
        String idLoc = "";
        Boolean cacheableLoc = null;
        Boolean writeBackedLoc = null;
        Boolean readAllocatedLoc = null;
        Boolean writeAllocatedLoc = null;
        Boolean transientAttrLoc = null;
        Collection children = YamlStorableHelper.getChildrenAndSkipMapLayer((IYamlStorable)yaml);
        for (IYamlStorable childYaml : children) {
            String yamlId = childYaml.getYamlId();
            if (!(childYaml instanceof YamlStorableValue)) continue;
            if (yamlId.equals("id")) {
                idLoc = childYaml.getYamlValue();
                continue;
            }
            if (yamlId.equals(CACHEABLE_ID)) {
                cacheableLoc = childYaml.getValueAsBoolean();
                continue;
            }
            if (yamlId.equals(WRITE_BACKED_ID)) {
                writeBackedLoc = childYaml.getValueAsBoolean();
                continue;
            }
            if (yamlId.equals(READ_ALLOCATED_ID)) {
                readAllocatedLoc = childYaml.getValueAsBoolean();
                continue;
            }
            if (yamlId.equals(WRITE_ALLOCATED_ID)) {
                writeAllocatedLoc = childYaml.getValueAsBoolean();
                continue;
            }
            if (!yamlId.equals(TRANSIENT_ID)) continue;
            transientAttrLoc = childYaml.getValueAsBoolean();
        }
        this.id = idLoc;
        this.cacheable = cacheableLoc;
        this.writeBacked = writeBackedLoc;
        this.readAllocated = readAllocatedLoc;
        this.writeAllocated = writeAllocatedLoc;
        this.transientAttr = transientAttrLoc;
        return true;
    }

    public boolean isCacheable() {
        return this.cacheable != null ? this.cacheable : false;
    }

    public boolean isWriteBacked() {
        return this.writeBacked != null ? this.writeBacked : false;
    }

    public boolean isReadAllocated() {
        return this.readAllocated != null ? this.readAllocated : false;
    }

    public boolean isWriteAllocated() {
        return this.writeAllocated != null ? this.writeAllocated : false;
    }

    public boolean isTransientAttr() {
        return this.transientAttr != null ? this.transientAttr : false;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setCacheable(boolean cacheable) {
        this.cacheable = cacheable;
    }

    public void setWriteBacked(boolean writeBacked) {
        this.writeBacked = writeBacked;
    }

    public void setReadAllocated(boolean readAllocated) {
        this.readAllocated = readAllocated;
    }

    public void setWriteAllocated(boolean writeAllocated) {
        this.writeAllocated = writeAllocated;
    }

    public void setTransientAttr(boolean transientAttr) {
        this.transientAttr = transientAttr;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.writeBacked, this.cacheable, this.readAllocated, this.transientAttr, this.writeAllocated);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StorageTeeMpuSharedAttributes other = (StorageTeeMpuSharedAttributes)obj;
        return this.id.equals(other.id) && Objects.equals(this.writeBacked, other.writeBacked) && Objects.equals(this.cacheable, other.cacheable) && Objects.equals(this.readAllocated, other.readAllocated) && Objects.equals(this.transientAttr, other.transientAttr) && Objects.equals(this.writeAllocated, other.writeAllocated);
    }
}

