/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.storage.tee;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.yaml.IYamlStorable;
import com.nxp.swtools.common.utils.yaml.YamlStorableHelper;
import com.nxp.swtools.common.utils.yaml.YamlStorableList;
import com.nxp.swtools.common.utils.yaml.YamlStorableValue;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeeDisableableConfig;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeeSauMemoryRegionConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;

@Root(strict=false)
public class StorageTeeSau
extends StorageTeeDisableableConfig {
    public static final String SAU_ID = "sau";
    public static final String GENERATE_CODE_FOR_DISABLED_REGIONS_ID = "generate_code_for_disabled_regions";
    public static final String ALL_NS_ID = "all_non_secure";
    private static final String REGIONS_ID = "regions";
    @Attribute(name="all_non_secure", required=false)
    protected boolean allNonSecure;
    @Attribute(name="generate_code_for_disabled_regions", required=false)
    private boolean generateCodeForDisabledRegions;
    @ElementList(inline=true, required=false, type=StorageTeeSauMemoryRegionConfig.class)
    private List<StorageTeeSauMemoryRegionConfig> storageRegionConfigs = new ArrayList<StorageTeeSauMemoryRegionConfig>();

    public boolean isAllNonSecure() {
        return this.allNonSecure;
    }

    public void setAllNonSecure(boolean allNonSecure) {
        this.allNonSecure = allNonSecure;
    }

    public boolean isGenerateCodeForDisabledRegions() {
        return this.generateCodeForDisabledRegions;
    }

    public void setGenerateCodeForDisabledRegions(boolean generateCodeForDisabledRegions) {
        this.generateCodeForDisabledRegions = generateCodeForDisabledRegions;
    }

    public List<StorageTeeSauMemoryRegionConfig> getStorageRegionConfigs() {
        return this.storageRegionConfigs;
    }

    public void setStorageRegionConfigs(List<StorageTeeSauMemoryRegionConfig> storageRegionConfigs) {
        this.storageRegionConfigs = storageRegionConfigs;
    }

    @Override
    protected String getYamlId() {
        return SAU_ID;
    }

    @Override
    protected List<IYamlStorable> createYamlStorable() {
        List<IYamlStorable> storable = super.createYamlStorable();
        storable.add((IYamlStorable)new YamlStorableValue(ALL_NS_ID, Boolean.toString(this.isAllNonSecure())));
        storable.add((IYamlStorable)new YamlStorableValue(GENERATE_CODE_FOR_DISABLED_REGIONS_ID, Boolean.toString(this.isGenerateCodeForDisabledRegions())));
        YamlStorableList storageRegionConfigsYaml = new YamlStorableList(REGIONS_ID, Boolean.TRUE);
        storageRegionConfigsYaml.setForceSequence(true);
        this.storageRegionConfigs.forEach(each -> each.fillYamlStorable((IYamlStorable)storageRegionConfigsYaml));
        storable.add((IYamlStorable)storageRegionConfigsYaml);
        return storable;
    }

    @Override
    protected boolean loadYamlConvertible(Collection<IYamlStorable> children) {
        if (!super.loadYamlConvertible(children)) {
            return false;
        }
        boolean allNonSecureLoc = false;
        boolean generateCodeForDisabledRegionsLoc = false;
        ArrayList<StorageTeeSauMemoryRegionConfig> storageRegionConfigsLoc = new ArrayList<StorageTeeSauMemoryRegionConfig>();
        for (IYamlStorable childYaml : children) {
            if (childYaml instanceof YamlStorableValue) {
                if (childYaml.getYamlId().equals(ALL_NS_ID)) {
                    allNonSecureLoc = Boolean.parseBoolean(childYaml.getYamlValue());
                    continue;
                }
                if (!childYaml.getYamlId().equals(GENERATE_CODE_FOR_DISABLED_REGIONS_ID)) continue;
                generateCodeForDisabledRegionsLoc = Boolean.parseBoolean(childYaml.getYamlValue());
                continue;
            }
            if (!(childYaml instanceof YamlStorableList) || !childYaml.getYamlId().equals(REGIONS_ID)) continue;
            for (IYamlStorable regionYaml : CollectionsUtils.safeCollection((Collection)childYaml.getYamlChildren())) {
                StorageTeeSauMemoryRegionConfig config;
                if (regionYaml instanceof YamlStorableList) {
                    regionYaml = YamlStorableHelper.skipMapLayer((YamlStorableList)((YamlStorableList)regionYaml), (String)"region");
                }
                if (!(config = new StorageTeeSauMemoryRegionConfig()).updateFromYamlStorable(regionYaml)) continue;
                storageRegionConfigsLoc.add(config);
            }
        }
        this.setAllNonSecure(allNonSecureLoc);
        this.setGenerateCodeForDisabledRegions(generateCodeForDisabledRegionsLoc);
        this.setStorageRegionConfigs(storageRegionConfigsLoc);
        return true;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.allNonSecure, this.generateCodeForDisabledRegions, this.storageRegionConfigs);
        return result;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        StorageTeeSau other = (StorageTeeSau)obj;
        return this.allNonSecure == other.allNonSecure && this.generateCodeForDisabledRegions == other.generateCodeForDisabledRegions && Objects.equals(this.storageRegionConfigs, other.storageRegionConfigs);
    }
}

