/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.features;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.provider.features.Feature;
import com.nxp.swtools.provider.features.IFeatureSet;
import com.nxp.swtools.provider.features.PeriphSpecific;
import com.nxp.swtools.provider.features.Specific;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.ElementListUnion;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Commit;
import org.simpleframework.xml.core.PersistenceException;
import org.simpleframework.xml.core.Validate;

@Root(name="core_specific", strict=false)
public class CoreSpecific
extends Specific
implements IFeatureSet {
    @ElementListUnion(value={@ElementList(entry="feature", inline=true, required=false, type=Feature.class), @ElementList(entry="peripheral_specific", inline=true, required=false, type=PeriphSpecific.class)})
    @NonNull
    private @ElementListUnion(value={@ElementList(entry="feature", inline=true, required=false, type=Feature.class), @ElementList(entry="peripheral_specific", inline=true, required=false, type=PeriphSpecific.class)}) @ElementList(entry="feature", inline=true, required=false, type=Feature.class) @ElementList(entry="peripheral_specific", inline=true, required=false, type=PeriphSpecific.class) @NonNull List<@NonNull IFeatureSet> featureSets;
    @Attribute(name="cores")
    @NonNull
    private @Attribute(name="cores") @NonNull String coresString = "";
    @NonNull
    private @NonNull Set<@NonNull Feature> features = new LinkedHashSet<Feature>();
    @NonNull
    private @NonNull Set<@NonNull String> cores = new LinkedHashSet<String>();
    @NonNull
    private @NonNull Set<@NonNull String> periphs = new LinkedHashSet<String>();
    @NonNull
    private @NonNull Map<Feature, Set<@NonNull String>> periphsByFeature = new LinkedHashMap<Feature, Set<String>>();

    @Deprecated
    protected CoreSpecific() {
        this.featureSets = new ArrayList<IFeatureSet>();
    }

    @Commit
    public void commit() {
        CoreSpecific.commitFeatures(this.featureSets, this.features);
        CoreSpecific.commitPeriphs(this.featureSets, this.periphs, this.periphsByFeature);
        this.cores = CoreSpecific.valuesAsSet(this.coresString);
    }

    @Override
    public @Nullable Set<@NonNull String> getCores() {
        return this.cores;
    }

    @Override
    public @Nullable Set<@NonNull String> getCoresByFeature(@NonNull Feature f) {
        if (!this.features.contains(f)) {
            return null;
        }
        return this.cores;
    }

    @Override
    public @NonNull Set<@NonNull Feature> getFeatures() {
        return this.features;
    }

    @Override
    public @Nullable Set<@NonNull String> getParts() {
        return null;
    }

    @Override
    public @Nullable Set<@NonNull String> getPartsByFeature(@NonNull Feature f) {
        return null;
    }

    @Override
    public @NonNull Set<@NonNull String> getPeriphs() {
        return this.periphs;
    }

    @Override
    public @Nullable Set<@NonNull String> getPeriphsByFeature(@NonNull Feature f) {
        return this.periphsByFeature.get(f);
    }

    @Validate
    public void validate() throws PersistenceException {
        CoreSpecific.validate(this.featureSets);
        CoreSpecific.validate(this.coresString);
    }
}

