/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.features;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.provider.features.Feature;
import com.nxp.swtools.provider.features.IFeatureSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.simpleframework.xml.core.PersistenceException;

public class Specific {
    @NonNull
    private static String VALUE_SEPARATOR = " ";

    protected static void commitCores(@NonNull List<@NonNull IFeatureSet> featureSets, @NonNull Set<@NonNull String> cores, @NonNull Map<Feature, Set<@NonNull String>> coresByFeature) {
        for (IFeatureSet set : featureSets) {
            for (Feature f : set.getFeatures()) {
                Set<@NonNull String> prevCores = coresByFeature.get(f);
                Set<@NonNull String> c = set.getCoresByFeature(f);
                if (c == null) continue;
                if (prevCores != null) {
                    prevCores.addAll(c);
                    coresByFeature.put(f, prevCores);
                    continue;
                }
                coresByFeature.put(f, c);
            }
            Set<@NonNull String> localCores = set.getCores();
            if (localCores == null) continue;
            cores.addAll(localCores);
        }
    }

    protected static void commitFeatures(@NonNull List<@NonNull IFeatureSet> featureSets, @NonNull Set<@NonNull Feature> features) {
        for (IFeatureSet set : featureSets) {
            features.addAll(set.getFeatures());
        }
    }

    protected static void commitParts(@NonNull List<@NonNull IFeatureSet> featureSets, @NonNull Set<@NonNull String> parts, @NonNull Map<Feature, Set<@NonNull String>> partsByFeature) {
        for (IFeatureSet set : featureSets) {
            for (Feature f : set.getFeatures()) {
                Set<@NonNull String> prevParts = partsByFeature.get(f);
                Set<@NonNull String> p = set.getPartsByFeature(f);
                if (p == null) continue;
                if (prevParts != null) {
                    prevParts.addAll(p);
                    partsByFeature.put(f, prevParts);
                    continue;
                }
                partsByFeature.put(f, p);
            }
            Set<@NonNull String> localParts = set.getParts();
            if (localParts == null) continue;
            parts.addAll(localParts);
        }
    }

    protected static void commitPeriphs(@NonNull List<@NonNull IFeatureSet> featureSets, @NonNull Set<@NonNull String> periphs, @NonNull Map<Feature, Set<@NonNull String>> periphsByFeature) {
        for (IFeatureSet set : featureSets) {
            for (Feature f : set.getFeatures()) {
                Set<@NonNull String> prevPeriphs = periphsByFeature.get(f);
                Set<@NonNull String> p = set.getPeriphsByFeature(f);
                if (p == null) continue;
                if (prevPeriphs != null) {
                    prevPeriphs.addAll(p);
                    periphsByFeature.put(f, prevPeriphs);
                    continue;
                }
                periphsByFeature.put(f, p);
            }
            Set<@NonNull String> localPeriphs = set.getPeriphs();
            if (localPeriphs == null) continue;
            periphs.addAll(localPeriphs);
        }
    }

    protected static void validate(@NonNull List<@NonNull IFeatureSet> featureSets) throws PersistenceException {
        HashSet<@NonNull String> fset = new HashSet<String>();
        for (IFeatureSet set : featureSets) {
            if (!(set instanceof Feature)) continue;
            for (Feature f : set.getFeatures()) {
                if (fset.contains(f.getName())) {
                    throw new PersistenceException("Duplicate feature: %1s", new Object[]{f.toString()});
                }
                fset.add(f.getName());
            }
        }
    }

    protected static void validate(@NonNull String values) throws PersistenceException {
        ArrayList<@NonNull String> plist = new ArrayList<String>();
        for (String p : Specific.valuesAsList(values)) {
            if (plist.contains(p)) {
                throw new PersistenceException("Duplicate value: %1s", new Object[]{p});
            }
            plist.add(p);
        }
    }

    protected static @NonNull List<@NonNull String> valuesAsList(@NonNull String values) {
        return Arrays.asList(values.split(VALUE_SEPARATOR));
    }

    protected static @NonNull Set<@NonNull String> valuesAsSet(@NonNull String values) {
        return new HashSet<String>(Arrays.asList(values.split(VALUE_SEPARATOR)));
    }
}

