/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.debug.internal.s32debugger.launch;

import com.freescale.s32ds.cross.core.ProjectContextSettings;
import com.nxp.s32ds.cle.ide.debugger.registry.LaunchConfigurationCreator;
import com.nxp.s32ds.cle.ide.launch.core.LaunchConfigurationUtil;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceCoreDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.DeviceDescriptors;
import com.nxp.s32ds.debug.ide.core.S32DebuggerErrorStatuses;
import com.nxp.s32ds.debug.ide.s32debugger.flash.core.S32DebuggerFlashProgrammerLaunchUtils;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

public class S32DebuggerFlashProgrammerLaunchConfigurationCreator
implements LaunchConfigurationCreator {
    public ILaunchConfigurationWorkingCopy createLaunchConfigurationWorkingCopy(Map<String, Object> attributes) throws CoreException {
        IResource launchResource;
        IProject hostProject = LaunchConfigurationUtil.extractProject(attributes);
        String component = LaunchConfigurationUtil.extractComponent(attributes);
        ILaunchConfigurationType debugerLaunchType = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType("com.nxp.s32ds.debug.ide.s32debugger.flash.core.s32DebuggerFlashProgrammerLaunchConfigurationType");
        if (debugerLaunchType == null) {
            throw new CoreException(S32DebuggerErrorStatuses.getLaunchConfigurationTypeUndefinedStatus());
        }
        ILaunchConfigurationWorkingCopy workingCopy = null;
        IFolder container = hostProject.getFolder("Project_Settings/Debugger");
        if (container == null || !container.isAccessible()) {
            container = hostProject;
        }
        if ((launchResource = container.findMember(String.valueOf(component) + ".launch")) != null && launchResource.isAccessible()) {
            throw new CoreException(S32DebuggerErrorStatuses.getLaunchConfigurationExistsStatus((IPath)launchResource.getLocation()));
        }
        String configurationName = hostProject.getName();
        workingCopy = debugerLaunchType.newInstance((IContainer)container, configurationName);
        this.setupLaunchConfigurationWorkingCopy(workingCopy, attributes);
        return workingCopy;
    }

    public void setupLaunchConfigurationWorkingCopy(ILaunchConfigurationWorkingCopy lcWorkingCopy, Map<String, Object> attributes) throws CoreException {
        DeviceDescriptor deviceDescriptor;
        IProject hostProject = LaunchConfigurationUtil.extractProject(attributes);
        ProjectContextSettings pc = new ProjectContextSettings(hostProject);
        String deviceCoreId = pc.getAttributeByKey("com.nxp.s32ds.cle.runtime.hardware.registry.deviceCore.id");
        if (deviceCoreId == null || deviceCoreId.isEmpty()) {
            deviceCoreId = LaunchConfigurationUtil.extractHardwareDeviceId(attributes);
            deviceDescriptor = DeviceDescriptors.getDeviceDescriptor((String)deviceCoreId);
        } else {
            DeviceCoreDescriptor deviceCoreDescriptor = DeviceDescriptors.getDeviceCoreDescriptor((String)deviceCoreId);
            deviceDescriptor = DeviceDescriptors.getDeviceDescriptor((String)deviceCoreDescriptor.getDeviceId());
        }
        if (deviceDescriptor == null) {
            throw new CoreException(S32DebuggerErrorStatuses.getLaunchConfigurationTypeUndefinedStatus());
        }
        String executable = LaunchConfigurationUtil.extractProjectExecutable(attributes);
        String devRevision = LaunchConfigurationUtil.extractHardwareDeviceRevision(attributes);
        S32DebuggerFlashProgrammerLaunchUtils.addDefaultS32DebuggerParametersToLaunch((ILaunchConfigurationWorkingCopy)lcWorkingCopy, (DeviceDescriptor)deviceDescriptor, (String)devRevision);
        S32DebuggerFlashProgrammerLaunchUtils.addDefaultExecutableParametersToLaunch((ILaunchConfigurationWorkingCopy)lcWorkingCopy, (String)executable);
        S32DebuggerFlashProgrammerLaunchUtils.addDefaultFlashDataParametersToLaunch((ILaunchConfigurationWorkingCopy)lcWorkingCopy, (DeviceDescriptor)deviceDescriptor);
        lcWorkingCopy.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", executable);
        lcWorkingCopy.setContainer((IContainer)hostProject);
        lcWorkingCopy.setMappedResources(new IResource[]{hostProject});
    }
}

