/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.debug.s32debugger.launch.markers;

import com.nxp.s32ds.cle.debug.internal.s32debugger.launch.checkers.CheckersErrorMessages;
import com.nxp.s32ds.cle.debug.s32debugger.S32DebuggerActivator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class S32DebuggerLaunchConfigurationScriptMarker {
    private static final String MARKER_ID = "com.nxp.s32ds.cle.debug.s32debugger.init.script.outdated.launch.marker";

    public static IStatus createMarker(IResource launchFile, IProject project) {
        try {
            IMarker marker = launchFile.createMarker(MARKER_ID);
            if (marker.exists()) {
                marker.setAttribute("severity", 1);
                String msg = NLS.bind((String)CheckersErrorMessages.S32DebuggerLaunchConfigurationScriptMarker_userWarningMessage, (Object)launchFile.getName());
                marker.setAttribute("message", (Object)msg);
                marker.setAttribute("location", (Object)project.getName());
                marker.setAttribute(CheckersErrorMessages.S32DebuggerLaunchConfigurationMarker_markerAttFileName, (Object)launchFile.getName());
            }
        }
        catch (CoreException ce) {
            S32DebuggerActivator.getInstance().log(ce.getStatus());
            return ce.getStatus();
        }
        return Status.OK_STATUS;
    }

    public static boolean containsMarker(IResource resource) {
        try {
            IMarker[] markers = resource.findMarkers(MARKER_ID, true, 2);
            if (markers != null && markers.length > 0) {
                return true;
            }
        }
        catch (CoreException ce) {
            S32DebuggerActivator.getInstance().log(ce.getStatus());
        }
        return false;
    }
}

