/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.s32debugger.validation;

import com.nxp.s32ds.cle.runtime.debugger.connections.registry.DebuggerConnectionAccessor;
import com.nxp.s32ds.cle.runtime.debugger.connections.registry.DebuggerConnections;
import com.nxp.s32ds.cle.runtime.debugger.connections.registry.DeviceConnection;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.DeviceDescriptors;
import com.nxp.s32ds.debug.ide.core.DebuggerUtils;
import com.nxp.s32ds.debug.ide.s32debugger.internal.validation.S32DebuggerErrorMessages;
import com.nxp.s32ds.debug.ide.s32debugger.internal.validation.S32DebuggerParametersNamesMessages;
import com.nxp.s32ds.debug.ide.s32debugger.internal.validation.S32DebuggerValidationActivator;
import com.nxp.s32ds.debug.ide.s32debugger.validation.S32DebuggerParams;
import com.nxp.s32ds.debug.ide.s32debugger.validation.S32DebuggerStartupParams;
import com.nxp.s32ds.debug.ide.validation.CommonFieldValidator;
import com.nxp.s32ds.debug.ide.validation.ErrorMessages;
import com.nxp.s32ds.debug.ide.validation.HostnameIPFieldValidator;
import com.nxp.s32ds.debug.ide.validation.NumberFieldValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class S32DebuggerAttributesValidator {
    private static final int MINIMAL_JTAG_SPEED_KHZ = 16000;
    private static final int MAXIMUM_JTAG_SPEED_KHZ = 3000000;
    private static final int MAXIMUM_TIME_VALUE = 10000;
    private static final int MAXIMUM_PORT_VALUE = 65535;
    private static final int ZERO_VALUE = 0;
    private String connectionString;

    private void processStatus(IStatus status, ArrayList<IStatus> errors) {
        if (!status.isOK()) {
            errors.add(status);
        }
    }

    public String getDebuggerConnectionString() {
        return this.connectionString;
    }

    public ArrayList<IStatus> validateDebuggerParameters(S32DebuggerParams debuggerParams, boolean checkForLaunch) {
        ArrayList<IStatus> errors = new ArrayList<IStatus>();
        String deviceCoreId = debuggerParams.getDeviceCoreId();
        if (deviceCoreId != null) {
            this.processStatus(new CommonFieldValidator(S32DebuggerParametersNamesMessages.FieldValidator_device_core).validate(this.deviceCoreValidateString(deviceCoreId)), errors);
        }
        if (debuggerParams.isInitialCore()) {
            String connectionQualifier = debuggerParams.getDevicePort();
            DeviceConnection connection = DeviceConnection.createFromFullConnectionString((String)connectionQualifier);
            if (connection != null) {
                String baseSpeed;
                if (connection.isUsbConnection()) {
                    this.processStatus(new CommonFieldValidator(S32DebuggerParametersNamesMessages.FieldValidator_usb_device).validate(connection.getDeviceConnectionData()), errors);
                } else {
                    this.processStatus(new HostnameIPFieldValidator(S32DebuggerParametersNamesMessages.FieldValidator_hostname_or_ip).validate(connection.getDeviceConnectionData()), errors);
                }
                if (checkForLaunch) {
                    this.connectionString = DebuggerUtils.getConnectionStringForDeviceConnection((String)connectionQualifier);
                    if (this.connectionString == null) {
                        errors.add((IStatus)new Status(4, S32DebuggerValidationActivator.getInstance().getBundleId(), S32DebuggerErrorMessages.S32DebuggerLaunchAttributesValidator_wrong_device));
                    } else if (this.connectionString.isEmpty()) {
                        errors.add((IStatus)new Status(4, S32DebuggerValidationActivator.getInstance().getBundleId(), S32DebuggerErrorMessages.S32DebuggerLaunchAttributesValidator_no_connection));
                    }
                }
                int jtagSpeedMin = 16000;
                DebuggerConnectionAccessor devAccessor = DebuggerConnections.getDebuggerConnectionAccessorByConnectionName((String)connection.getDeviceConnectionId());
                if (devAccessor != null && (baseSpeed = devAccessor.getBaseSpeed()) != null) {
                    jtagSpeedMin = 0;
                }
                this.processStatus(new NumberFieldValidator(S32DebuggerParametersNamesMessages.FieldValidator_jtag_speed_khz, jtagSpeedMin, 3000000).validate((Object)debuggerParams.getJtagSpeedKHz()), errors);
            } else if (!connectionQualifier.isEmpty()) {
                errors.add((IStatus)new Status(4, S32DebuggerValidationActivator.getInstance().getBundleId(), S32DebuggerErrorMessages.S32DebuggerLaunchAttributesValidator_no_connections));
            } else {
                errors.add((IStatus)new Status(4, S32DebuggerValidationActivator.getInstance().getBundleId(), S32DebuggerErrorMessages.S32DebuggerLaunchAttributesValidator_specify_connection));
            }
            if (debuggerParams.isDoResetAndDelay()) {
                this.processStatus(new NumberFieldValidator(S32DebuggerParametersNamesMessages.FieldValidator_delay, 0, 10000).validate((Object)debuggerParams.getDelayInMSeconds()), errors);
            }
        }
        this.processStatus(new NumberFieldValidator(S32DebuggerParametersNamesMessages.FieldValidator_remote_timeout, 0, 10000).validate((Object)debuggerParams.getRemoteTimeoutInSeconds()), errors);
        this.processStatus(new NumberFieldValidator(S32DebuggerParametersNamesMessages.FieldValidator_gdb_server_port, 0, 65535).validate((Object)debuggerParams.getServerPort()), errors);
        if (debuggerParams.isSemihostingEnabled()) {
            this.processStatus(new NumberFieldValidator(S32DebuggerParametersNamesMessages.FieldValidator_semihosting_port, 0, 65535).validate((Object)debuggerParams.getSemihostingPort()), errors);
        }
        this.processStatus(new CommonFieldValidator(S32DebuggerParametersNamesMessages.FieldValidator_script, false).validate(debuggerParams.getInitializationScript()), errors);
        this.processStatus(new CommonFieldValidator(S32DebuggerParametersNamesMessages.FieldValidator_client, true).validate(debuggerParams.getClientExecutable()), errors);
        errors.addAll(debuggerParams.getReadErrors());
        return errors;
    }

    public ArrayList<IStatus> validateStartupParameters(S32DebuggerStartupParams startupParams) {
        ArrayList<IStatus> errors = new ArrayList<IStatus>();
        if (startupParams.isDoLoadImage() && !startupParams.isUseProjectBinaryForImage()) {
            this.processStatus(new CommonFieldValidator(S32DebuggerParametersNamesMessages.FieldValidator_image_binary, false).validate(startupParams.getImageFileName()), errors);
        }
        if (startupParams.isDoLoadSymbols() && !startupParams.isUseProjectBinaryForSymbols()) {
            this.processStatus(new CommonFieldValidator(S32DebuggerParametersNamesMessages.FieldValidator_symbols_binary, false).validate(startupParams.getSymbolsFileName()), errors);
        }
        if (startupParams.isDoSetPcRegister()) {
            this.processStatus(new CommonFieldValidator(S32DebuggerParametersNamesMessages.FieldValidator_pc_register_value).validate(startupParams.getPcRegisterValue()), errors);
        }
        if (startupParams.isDoSetStopAt()) {
            this.processStatus(new CommonFieldValidator(S32DebuggerParametersNamesMessages.FieldValidator_breakpoint_address).validate(startupParams.getStopAt()), errors);
        }
        errors.addAll(startupParams.getReadErrors());
        return errors;
    }

    public IStatus validateParameters(S32DebuggerParams debuggerParams, S32DebuggerStartupParams startupParams, boolean checkForLaunch) {
        ArrayList<IStatus> debuggerErrors = this.validateDebuggerParameters(debuggerParams, checkForLaunch);
        ArrayList<IStatus> startupErrors = this.validateStartupParameters(startupParams);
        ArrayList<IStatus> errors = debuggerErrors;
        errors.addAll(startupErrors);
        Collection errorStatuses = errors.stream().filter(status -> status.getSeverity() == 4).collect(Collectors.toList());
        if (!errorStatuses.isEmpty()) {
            StringBuilder builder = new StringBuilder(ErrorMessages.LaunchSequence_wrong_attributes);
            errorStatuses.forEach(status -> {
                builder.append("\n");
                builder.append(status.getMessage());
            });
            return new Status(4, S32DebuggerValidationActivator.getInstance().getBundleId(), builder.toString());
        }
        return Status.OK_STATUS;
    }

    private String deviceCoreValidateString(String deviceCoreId) {
        return DeviceDescriptors.getDeviceCoreDescriptor((String)deviceCoreId) == null ? "" : deviceCoreId;
    }
}

