/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.s32debugger.validation;

import com.freescale.s32ds.cross.core.ProjectContextSettings;
import com.nxp.s32ds.cle.runtime.debugger.connections.registry.DebuggerConnectionDescriptor;
import com.nxp.s32ds.cle.runtime.debugger.connections.registry.DebuggerConnections;
import com.nxp.s32ds.cle.runtime.debugger.connections.registry.DeviceConnection;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceCoreDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.DeviceDescriptors;
import com.nxp.s32ds.debug.ide.core.AttributeReadingUtils;
import com.nxp.s32ds.debug.ide.s32debugger.internal.validation.S32DebuggerErrorMessages;
import com.nxp.s32ds.debug.ide.s32debugger.internal.validation.S32DebuggerValidationActivator;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

public class S32DebuggerParams {
    private static final String BUNDLE_NAME = "com.nxp.s32ds.debug.ide.s32debugger.core";
    private static final String CURRENT_VERSION = "1.3";
    public static final String SECURE_TYPE_PASSWORD = "PWD";
    public static final String SECURE_TYPE_C_AND_R = "CR";
    public static final String DEVICE = "com.nxp.s32ds.debug.ide.s32debugger.core.device";
    public static final String CORE = "com.nxp.s32ds.debug.ide.s32debugger.core.core";
    public static final String DEVICE_REVISION = "com.nxp.s32ds.debug.ide.s32debugger.core.deviceRevision";
    public static final String CONFIGURATION_VERSION = "com.nxp.s32ds.debug.ide.s32debugger.core.version";
    public static final String DEVICE_CORE_ID = "com.nxp.s32ds.debug.ide.s32debugger.core.deviceCoreId";
    public static final String INITIALIZATION_SCRIPT = "com.nxp.s32ds.debug.ide.s32debugger.core.initializationScriptPath";
    public static final String USE_ETHERNET = "com.nxp.s32ds.debug.ide.s32debugger.core.useEthernet";
    public static final String DEVICE_PORT = "com.nxp.s32ds.debug.ide.s32debugger.core.port";
    public static final String PROBE_HOSTNAME_OR_IP = "com.nxp.s32ds.debug.ide.s32debugger.core.hostnameOrIp";
    public static final String JTAG_SPEED_KHZ = "com.nxp.s32ds.debug.ide.s32debugger.core.jtagSpeedKHz";
    public static final String REMOTE_TIMEOUT_IN_SECONDS = "com.nxp.s32ds.debug.ide.s32debugger.core.remoteTimeoutInSeconds";
    public static final String DO_RESET_AND_DELAY = "com.nxp.s32ds.debug.ide.s32debugger.core.doResetAndDelay";
    public static final String DELAY_IN_MSECONDS = "com.nxp.s32ds.debug.ide.s32debugger.core.delayInMSeconds";
    public static final String DO_LAUNCH_SERVER = "com.nxp.s32ds.debug.ide.s32debugger.core.doLaunchServer";
    public static final String SERVER_PORT = "com.nxp.s32ds.debug.ide.s32debugger.core.serverPortNumber";
    public static final String IS_SERVER_LOG_ENABLED = "com.nxp.s32ds.debug.ide.s32debugger.core.isServerLogEnabled";
    public static final String CLIENT_COMMANDS = "com.nxp.s32ds.debug.ide.s32debugger.core.clientCommands";
    public static final String INITIAL_CORE = "com.nxp.s32ds.debug.ide.s32debugger.core.initialCore";
    public static final String CLIENT_EXECUTABLE = "org.eclipse.cdt.dsf.gdb.DEBUG_NAME";
    public static final String FORCE_THREADLIST_UPDATE_ON_SUSPEND = "org.eclipse.cdt.dsf.gdb.UPDATE_THREADLIST_ON_SUSPEND";
    public static final String IS_SEMIHOSTING_ENABLED = "com.nxp.s32ds.debug.ide.s32debugger.core.isSemihostingEnabled";
    public static final String SEMIHOSTING_PORT = "com.nxp.s32ds.debug.ide.s32debugger.core.semihostingPort";
    public static final String USE_SECURE_DEBUGGING = "com.nxp.s32ds.debug.ide.s32debugger.core.useSecureDebugging";
    public static final String SECURE_DEBUGGING_TYPE = "com.nxp.s32ds.debug.ide.s32debugger.core.secureDebuggingType";
    public static final String DEFAULT_EMPTY_VALUE = "";
    public static final String DEFAULT_DEVICE_REVISION = "";
    public static final String DEFAULT_DEVICE_CORE_ID = "";
    public static final String DEFAULT_INITIALIZATION_SCRIPT = "";
    public static final String DEFAULT_DEVICE_PORT = "";
    public static final String DEFAULT_PROBE_HOSTNAME_OR_IP = "";
    public static final String DEFAULT_CLIENT_COMMANDS = "";
    public static final String DEFAULT_JTAG_SPEED_KHZ = "16000";
    public static final String DEFAULT_REMOTE_TIMEOUT_IN_SECONDS = "30";
    public static final boolean DEFAULT_DO_RESET_AND_DELAY = false;
    public static final String DEFAULT_DELAY_IN_MSECONDS = "0";
    public static final boolean DEFAULT_DO_LAUNCH_SERVER = true;
    public static final String DEFAULT_SERVER_PORT = "45000";
    public static final boolean DEFAULT_IS_SEMIHOSTING_ENABLED = true;
    public static final String DEFAULT_SEMIHOSTING_PORT = "45001";
    public static final boolean DEFAULT_USE_SECURE_DEBUGGING = false;
    public static final String DEFAULT_SECURE_DEBUGGING_TYPE = "";
    public static final boolean DEFAULT_USE_ETHERNET = true;
    public static final boolean DEFAULT_INITIAL_CORE = true;
    public static final boolean DEFAULT_IS_SERVER_LOG_ENABLED = false;
    public static final String DEFAULT_CLIENT_EXECUTABLE = "gdb";
    private static final boolean DEFAULT_FORCE_THREADLIST_UPDATE_ON_SUSPEND = false;
    private static final String PROJECT_ATTR = "org.eclipse.cdt.launch.PROJECT_ATTR";
    private String device = "";
    private String core = "";
    private String deviceRevision = "";
    private String version = "1.3";
    private String deviceCoreId = "";
    private String initializationScript = "";
    private boolean useEthernet = true;
    private String devicePort = "";
    private String probeHostnameOrIP = "";
    private String jtagSpeedKHz = "16000";
    private String remoteTimeoutInSeconds = "30";
    private boolean doResetAndDelay = false;
    private String delayInMSeconds = "0";
    private boolean doLaunchServer = true;
    private String serverPort = "45000";
    private boolean isLogEnabled = false;
    private String clientCommands = "";
    private boolean initialCore = true;
    private String clientExecutable = "gdb";
    private boolean forceThreadListUpdateOnSuspend = false;
    private boolean isSemihostingEnabled = true;
    private String semihostingPort = "45001";
    private boolean useSecureDebugging = false;
    private String secureDebuggingType = "";
    private ArrayList<IStatus> errors;

    public String getLCVersion() {
        return this.version;
    }

    public String getSecureDebuggingType() {
        return this.secureDebuggingType;
    }

    public void setSecureDebuggingType(String secureDebuggingType) {
        this.secureDebuggingType = secureDebuggingType;
    }

    public boolean isUseSecureDebugging() {
        return this.useSecureDebugging;
    }

    public void setUseSecureDebugging(boolean useSecureDebugging) {
        this.useSecureDebugging = useSecureDebugging;
    }

    public String getSemihostingPort() {
        return this.semihostingPort;
    }

    public void setSemihostingPort(String semihostingPort) {
        this.semihostingPort = semihostingPort;
    }

    public boolean isSemihostingEnabled() {
        return this.isSemihostingEnabled;
    }

    public void setSemihostingEnabled(boolean isSemihostingEnabled) {
        this.isSemihostingEnabled = isSemihostingEnabled;
    }

    public boolean isForceThreadListUpdateOnSuspend() {
        return this.forceThreadListUpdateOnSuspend;
    }

    public void setForceThreadListUpdateOnSuspend(boolean forceThreadListUpdateOnSuspend) {
        this.forceThreadListUpdateOnSuspend = forceThreadListUpdateOnSuspend;
    }

    public String getClientExecutable() {
        return this.clientExecutable;
    }

    public void setClientExecutable(String clientExecutable) {
        this.clientExecutable = clientExecutable;
    }

    public String getDeviceId() {
        return this.device;
    }

    public void setDeviceId(String device) {
        this.device = device;
    }

    public String getCoreName() {
        return this.core;
    }

    private void setCoreName(String core) {
        this.core = core;
    }

    public String getDeviceCoreId() {
        if ("".equals(this.deviceCoreId) && !this.device.isEmpty() && !this.core.isEmpty()) {
            List deviceCoreDescriptors = DeviceDescriptors.getDeviceCoreDescriptors((String)this.device);
            for (DeviceCoreDescriptor deviceCoreDescriptor : deviceCoreDescriptors) {
                if (!deviceCoreDescriptor.getName().equals(this.core)) continue;
                return deviceCoreDescriptor.getId();
            }
        }
        return this.deviceCoreId;
    }

    public void setDeviceCoreId(String coreId) {
        this.deviceCoreId = coreId;
    }

    public String getInitializationScript() {
        return this.initializationScript;
    }

    public void setInitializationScript(String initializationScript) {
        this.initializationScript = initializationScript;
    }

    @Deprecated
    public boolean isUseEthernet() {
        return this.useEthernet;
    }

    @Deprecated
    public void setUseEthernet(boolean useEthernet) {
        this.useEthernet = useEthernet;
    }

    public String getDevicePort() {
        return this.devicePort;
    }

    public void setDevicePort(String devicePort) {
        this.devicePort = devicePort;
    }

    @Deprecated
    public String getProbeHostnameOrIP() {
        return this.probeHostnameOrIP;
    }

    @Deprecated
    public void setProbeHostnameOrIP(String probeHostnameOrIP) {
        this.probeHostnameOrIP = probeHostnameOrIP;
    }

    public String getJtagSpeedKHz() {
        return this.jtagSpeedKHz;
    }

    public void setJtagSpeedKHz(String jtagSpeedKHz) {
        this.jtagSpeedKHz = jtagSpeedKHz;
    }

    public String getRemoteTimeoutInSeconds() {
        return this.remoteTimeoutInSeconds;
    }

    public void setRemoteTimeoutInSeconds(String remoteTimeoutInSeconds) {
        this.remoteTimeoutInSeconds = remoteTimeoutInSeconds;
    }

    public boolean isDoResetAndDelay() {
        return this.doResetAndDelay;
    }

    public void setDoResetAndDelay(boolean doResetAndDelay) {
        this.doResetAndDelay = doResetAndDelay;
    }

    public String getDelayInMSeconds() {
        return this.delayInMSeconds;
    }

    public void setDelayInMSeconds(String delayInMSeconds) {
        this.delayInMSeconds = delayInMSeconds;
    }

    public boolean isDoLaunchServer() {
        return this.doLaunchServer;
    }

    public void setDoLaunchServer(boolean doLaunchServer) {
        this.doLaunchServer = doLaunchServer;
    }

    public String getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(String serverPort) {
        this.serverPort = serverPort;
    }

    public boolean isLogEnabled() {
        return this.isLogEnabled;
    }

    public void setLogEnabled(boolean isLogEnabled) {
        this.isLogEnabled = isLogEnabled;
    }

    public String getClientCommands() {
        return this.clientCommands;
    }

    public void setClientCommands(String clientCommands) {
        this.clientCommands = clientCommands;
    }

    public boolean isInitialCore() {
        return this.initialCore;
    }

    public void setInitialCore(boolean initialCore) {
        this.initialCore = initialCore;
    }

    public ArrayList<IStatus> getReadErrors() {
        return this.errors;
    }

    public static S32DebuggerParams getParams(ILaunchConfiguration lc) {
        S32DebuggerParams params = new S32DebuggerParams();
        params.errors = new ArrayList();
        params.setClientCommands((String)AttributeReadingUtils.readAttribute(params.errors, (String)CLIENT_COMMANDS, (Object)"", (ILaunchConfiguration)lc));
        params.setDevicePort((String)AttributeReadingUtils.readAttribute(params.errors, (String)DEVICE_PORT, (Object)"", (ILaunchConfiguration)lc));
        params.setCoreName((String)AttributeReadingUtils.readAttribute(params.errors, (String)CORE, (Object)"", (ILaunchConfiguration)lc));
        params.setDeviceId((String)AttributeReadingUtils.readAttribute(params.errors, (String)DEVICE, (Object)"", (ILaunchConfiguration)lc));
        params.setDeviceCoreId((String)AttributeReadingUtils.readAttribute(params.errors, (String)DEVICE_CORE_ID, (Object)"", (ILaunchConfiguration)lc));
        params.setDelayInMSeconds((String)AttributeReadingUtils.readAttribute(params.errors, (String)DELAY_IN_MSECONDS, (Object)DEFAULT_DELAY_IN_MSECONDS, (ILaunchConfiguration)lc));
        params.setDoLaunchServer((Boolean)AttributeReadingUtils.readAttribute(params.errors, (String)DO_LAUNCH_SERVER, (Object)true, (ILaunchConfiguration)lc));
        params.setDoResetAndDelay((Boolean)AttributeReadingUtils.readAttribute(params.errors, (String)DO_RESET_AND_DELAY, (Object)false, (ILaunchConfiguration)lc));
        params.setInitialCore((Boolean)AttributeReadingUtils.readAttribute(params.errors, (String)INITIAL_CORE, (Object)true, (ILaunchConfiguration)lc));
        params.setInitializationScript((String)AttributeReadingUtils.readAttribute(params.errors, (String)INITIALIZATION_SCRIPT, (Object)"", (ILaunchConfiguration)lc));
        params.setJtagSpeedKHz((String)AttributeReadingUtils.readAttribute(params.errors, (String)JTAG_SPEED_KHZ, (Object)DEFAULT_JTAG_SPEED_KHZ, (ILaunchConfiguration)lc));
        params.setLogEnabled((Boolean)AttributeReadingUtils.readAttribute(params.errors, (String)IS_SERVER_LOG_ENABLED, (Object)false, (ILaunchConfiguration)lc));
        params.setRemoteTimeoutInSeconds((String)AttributeReadingUtils.readAttribute(params.errors, (String)REMOTE_TIMEOUT_IN_SECONDS, (Object)DEFAULT_REMOTE_TIMEOUT_IN_SECONDS, (ILaunchConfiguration)lc));
        params.setServerPort((String)AttributeReadingUtils.readAttribute(params.errors, (String)SERVER_PORT, (Object)DEFAULT_SERVER_PORT, (ILaunchConfiguration)lc));
        params.setClientExecutable((String)AttributeReadingUtils.readAttribute(params.errors, (String)CLIENT_EXECUTABLE, (Object)DEFAULT_CLIENT_EXECUTABLE, (ILaunchConfiguration)lc));
        params.setForceThreadListUpdateOnSuspend((Boolean)AttributeReadingUtils.readAttribute(params.errors, (String)FORCE_THREADLIST_UPDATE_ON_SUSPEND, (Object)false, (ILaunchConfiguration)lc));
        params.setSemihostingEnabled((Boolean)AttributeReadingUtils.readAttribute(params.errors, (String)IS_SEMIHOSTING_ENABLED, (Object)true, (ILaunchConfiguration)lc));
        params.setSemihostingPort((String)AttributeReadingUtils.readAttribute(params.errors, (String)SEMIHOSTING_PORT, (Object)DEFAULT_SEMIHOSTING_PORT, (ILaunchConfiguration)lc));
        params.setUseSecureDebugging((Boolean)AttributeReadingUtils.readAttribute(params.errors, (String)USE_SECURE_DEBUGGING, (Object)false, (ILaunchConfiguration)lc));
        params.setSecureDebuggingType((String)AttributeReadingUtils.readAttribute(params.errors, (String)SECURE_DEBUGGING_TYPE, (Object)"", (ILaunchConfiguration)lc));
        params.setDeviceRevision((String)AttributeReadingUtils.readAttribute(params.errors, (String)DEVICE_REVISION, (Object)S32DebuggerParams.getDeviceRevisionForProject(lc, params), (ILaunchConfiguration)lc));
        S32DebuggerParams.adaptParameters1_1ToHigher(params, lc);
        return params;
    }

    private static String getDeviceRevisionForProject(ILaunchConfiguration lc, S32DebuggerParams params) {
        String projectName;
        block4: {
            projectName = lc.getAttribute(PROJECT_ATTR, "");
            if (!projectName.isEmpty()) break block4;
            return "";
        }
        try {
            IWorkspaceRoot workspace = ResourcesPlugin.getWorkspace().getRoot();
            IProject projectHandler = workspace.getProject(projectName);
            ProjectContextSettings ps = new ProjectContextSettings(projectHandler);
            String projectDeviceCoreId = ps.getAttributeByKey("com.nxp.s32ds.cle.runtime.hardware.registry.deviceCore.id");
            if (projectDeviceCoreId.equals(params.getDeviceCoreId())) {
                return ps.getAttributeByKey("com.nxp.s32ds.cle.runtime.hardware.registry.device.revision.id");
            }
        }
        catch (CoreException e) {
            Logger.getLogger(BUNDLE_NAME).log(Level.INFO, e.getMessage());
        }
        return "";
    }

    public String getDeviceRevision() {
        return this.deviceRevision;
    }

    public void setDeviceRevision(String revision) {
        this.deviceRevision = revision;
    }

    public static void applyDefaults(ILaunchConfigurationWorkingCopy lc) {
        lc.setAttribute(CLIENT_COMMANDS, "");
        lc.setAttribute(DEVICE_PORT, "");
        lc.setAttribute(DELAY_IN_MSECONDS, DEFAULT_DELAY_IN_MSECONDS);
        lc.setAttribute(DEVICE_CORE_ID, "");
        lc.setAttribute(DEVICE_REVISION, "");
        lc.setAttribute(DO_LAUNCH_SERVER, true);
        lc.setAttribute(DO_RESET_AND_DELAY, false);
        lc.setAttribute(INITIALIZATION_SCRIPT, "");
        lc.setAttribute(INITIAL_CORE, true);
        lc.setAttribute(JTAG_SPEED_KHZ, DEFAULT_JTAG_SPEED_KHZ);
        lc.setAttribute(IS_SERVER_LOG_ENABLED, false);
        lc.setAttribute(REMOTE_TIMEOUT_IN_SECONDS, DEFAULT_REMOTE_TIMEOUT_IN_SECONDS);
        lc.setAttribute(SERVER_PORT, DEFAULT_SERVER_PORT);
        lc.setAttribute(CLIENT_EXECUTABLE, DEFAULT_CLIENT_EXECUTABLE);
        lc.setAttribute(FORCE_THREADLIST_UPDATE_ON_SUSPEND, false);
        lc.setAttribute(IS_SEMIHOSTING_ENABLED, true);
        lc.setAttribute(SEMIHOSTING_PORT, DEFAULT_SEMIHOSTING_PORT);
        lc.setAttribute(USE_SECURE_DEBUGGING, false);
        lc.setAttribute(SECURE_DEBUGGING_TYPE, "");
        lc.setAttribute(SECURE_DEBUGGING_TYPE, "");
    }

    public void applyParams(ILaunchConfigurationWorkingCopy lc) {
        lc.setAttribute(CLIENT_COMMANDS, this.getClientCommands());
        lc.setAttribute(DEVICE_PORT, this.getDevicePort());
        lc.setAttribute(DELAY_IN_MSECONDS, this.getDelayInMSeconds());
        String deviceCoreId = this.getDeviceCoreId();
        if (deviceCoreId != null) {
            lc.setAttribute(DEVICE_CORE_ID, this.getDeviceCoreId());
        } else {
            String deviceId = this.getDeviceId();
            if (deviceId != null) {
                lc.setAttribute(DEVICE, deviceId);
            }
        }
        lc.setAttribute(DEVICE_REVISION, this.getDeviceRevision());
        lc.setAttribute(DO_LAUNCH_SERVER, this.isDoLaunchServer());
        lc.setAttribute(DO_RESET_AND_DELAY, this.isDoResetAndDelay());
        lc.setAttribute(INITIAL_CORE, this.isInitialCore());
        lc.setAttribute(INITIALIZATION_SCRIPT, this.getInitializationScript());
        lc.setAttribute(JTAG_SPEED_KHZ, this.getJtagSpeedKHz());
        lc.setAttribute(IS_SERVER_LOG_ENABLED, this.isLogEnabled());
        lc.setAttribute(REMOTE_TIMEOUT_IN_SECONDS, this.getRemoteTimeoutInSeconds());
        lc.setAttribute(SERVER_PORT, this.getServerPort());
        lc.setAttribute(CLIENT_EXECUTABLE, this.getClientExecutable());
        lc.setAttribute(FORCE_THREADLIST_UPDATE_ON_SUSPEND, this.isForceThreadListUpdateOnSuspend());
        lc.setAttribute(IS_SEMIHOSTING_ENABLED, this.isSemihostingEnabled());
        lc.setAttribute(SEMIHOSTING_PORT, this.getSemihostingPort());
        lc.setAttribute(USE_SECURE_DEBUGGING, this.isUseSecureDebugging());
        lc.setAttribute(SECURE_DEBUGGING_TYPE, this.getSecureDebuggingType());
    }

    private static void adaptParameters1_1ToHigher(S32DebuggerParams params, ILaunchConfiguration lc) {
        Boolean useEthernet = (Boolean)AttributeReadingUtils.readAttribute(params.errors, (String)USE_ETHERNET, (Object)Boolean.FALSE, (ILaunchConfiguration)lc);
        if (useEthernet != null && useEthernet.booleanValue() && "".equals(params.getDevicePort())) {
            DebuggerConnectionDescriptor descriptor = DebuggerConnections.getDebuggerConnectionDeviceDescriptors().stream().filter(desc -> desc.isEthernetConnection()).findFirst().get();
            if (descriptor != null) {
                DeviceConnection connection = new DeviceConnection(descriptor.getConnectionName(), false);
                String ip = (String)AttributeReadingUtils.readAttribute(params.errors, (String)PROBE_HOSTNAME_OR_IP, (Object)"", (ILaunchConfiguration)lc);
                connection.setDeviceConnectionData(ip);
                params.setDevicePort(connection.getFullConnectionString());
            } else {
                S32DebuggerValidationActivator.getInstance().logError(S32DebuggerErrorMessages.S32DebuggerParameters_no_s32_ethernet_descriptor);
            }
        }
    }
}

