/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.migration.internal.ui.wizard;

import com.nxp.s32ds.cle.ide.migration.internal.ui.Messages;
import com.nxp.s32ds.cle.ide.migration.internal.ui.MigrationUiActivator;
import com.nxp.s32ds.cle.ide.migration.internal.ui.wizard.MigrateProjectWizardPage;
import com.nxp.s32ds.cle.ide.migration.internal.ui.wizard.MigrationWizardPageBase;
import com.nxp.s32ds.cle.ide.migration.internal.ui.wizard.diagnostic.MigrationDiagnosticTreeViewer;
import com.nxp.s32ds.cle.runtime.migration.diagnostic.MigrationDiagnostic;
import com.nxp.s32ds.cle.runtime.migration.sequence.MigrationSequenceDescriptor;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class MigrateProjectWizardDiagnosticPage
extends MigrationWizardPageBase {
    private static final String WIZARD_PAGE_NAME = MigrateProjectWizardDiagnosticPage.class.getSimpleName();
    private final MigrateProjectWizardPage migrateProjectWizardPage;
    private MigrationDiagnosticTreeViewer treeViewer;

    protected MigrateProjectWizardDiagnosticPage(MigrateProjectWizardPage migrateProjectWizardPage) {
        super(WIZARD_PAGE_NAME, Messages.MigrateProjectWizardPage_title);
        this.migrateProjectWizardPage = migrateProjectWizardPage;
        this.setDefaultMessage(Messages.MigrateProjectWizardPage_migrate_project_s_using_the_migration);
    }

    @Override
    protected void doCreateControl(Composite parent) {
        this.treeViewer = new MigrationDiagnosticTreeViewer(parent);
        GridDataFactory.swtDefaults().grab(true, true).align(4, 4).applyTo((Control)this.treeViewer.getTree());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.freescale.s32ds.cross.wizard.MIGRATE_WIZ_context");
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.updateContent();
        }
    }

    private void updateContent() {
        MigrationSequenceDescriptor migrationDescriptor = this.migrateProjectWizardPage.getMigration();
        ArrayList<MigrationDiagnostic> diagnosticsList = new ArrayList<MigrationDiagnostic>();
        for (IProject project : this.migrateProjectWizardPage.getSelectedProjects()) {
            MigrationDiagnostic diagnostic = new MigrationDiagnostic(project);
            if (migrationDescriptor.getSequence().match(project, diagnostic)) continue;
            diagnosticsList.add(diagnostic);
        }
        this.treeViewer.setInput(diagnosticsList);
    }

    @Override
    protected IStatus validate() {
        MigrationSequenceDescriptor migration = this.migrateProjectWizardPage.getMigration();
        if (migration == null || !this.migrateProjectWizardPage.getSelectedProjects().stream().allMatch(p -> migration.getSequence().match(p, new MigrationDiagnostic(p)))) {
            return MigrationUiActivator.getInstance().createError(Messages.MigrateProjectWizardDiagnosticPage_project_s_cannot_be_migrated);
        }
        return Status.OK_STATUS;
    }
}

